/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.addressmatching;

import com.supermap.analyst.addressmatching.AddressMatchResultsNative;
import com.supermap.analyst.addressmatching.EnglishAddressMatchResult;
import com.supermap.analyst.addressmatching.InternalHandleDisposable;
import com.supermap.analyst.addressmatching.InternalResource;

class EnglishAddressMatchResults
extends InternalHandleDisposable {
    public EnglishAddressMatchResults() {
        long l = AddressMatchResultsNative.jni_NewEng();
        this.setHandle(l, true);
    }

    public void dispose() {
        if (this.getHandle() != 0L) {
            AddressMatchResultsNative.jni_DeleteEng(this.getHandle());
            this.setHandle(0L);
        }
    }

    public int getCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCount()", "Handle_ObjectHasBeenDisposed", "addressmatching_resources");
            throw new IllegalStateException(string);
        }
        return AddressMatchResultsNative.jni_GetEngResultCount(this.getHandle());
    }

    public EnglishAddressMatchResult get(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("get(int index)", "Handle_ObjectHasBeenDisposed", "addressmatching_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "addressmatching_resources");
            throw new IndexOutOfBoundsException(string);
        }
        EnglishAddressMatchResult englishAddressMatchResult = null;
        long l = AddressMatchResultsNative.jni_GetEngResultHandle(this.getHandle(), n);
        englishAddressMatchResult = new EnglishAddressMatchResult(l);
        return englishAddressMatchResult;
    }
}

