/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.hibernate3.support;

import java.io.UnsupportedEncodingException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.transaction.TransactionManager;
import org.springframework.jdbc.support.lob.LobCreator;
import org.springframework.jdbc.support.lob.LobHandler;
import org.springframework.orm.hibernate3.support.AbstractLobType;

public class BlobStringType
extends AbstractLobType {
    public BlobStringType() {
    }

    protected BlobStringType(LobHandler lobHandler, TransactionManager jtaTransactionManager) {
        super(lobHandler, jtaTransactionManager);
    }

    public int[] sqlTypes() {
        return new int[]{2004};
    }

    public Class<?> returnedClass() {
        return String.class;
    }

    @Override
    protected Object nullSafeGetInternal(ResultSet rs, String[] names, Object owner, LobHandler lobHandler) throws SQLException, UnsupportedEncodingException {
        byte[] bytes = lobHandler.getBlobAsBytes(rs, names[0]);
        if (bytes != null) {
            String encoding = this.getCharacterEncoding();
            return encoding != null ? new String(bytes, encoding) : new String(bytes);
        }
        return null;
    }

    @Override
    protected void nullSafeSetInternal(PreparedStatement ps, int index, Object value, LobCreator lobCreator) throws SQLException, UnsupportedEncodingException {
        if (value != null) {
            String str = (String)value;
            String encoding = this.getCharacterEncoding();
            byte[] bytes = encoding != null ? str.getBytes(encoding) : str.getBytes();
            lobCreator.setBlobAsBytes(ps, index, bytes);
        } else {
            lobCreator.setBlobAsBytes(ps, index, null);
        }
    }

    protected String getCharacterEncoding() {
        return null;
    }
}

