/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.config;

import net.sf.ehcache.store.compound.CopyStrategy;

public class CopyStrategyConfiguration {
    private volatile String className = "net.sf.ehcache.store.compound.SerializationCopyStrategy";
    private CopyStrategy strategy;

    public String getClassName() {
        return this.className;
    }

    public void setClass(String className) {
        this.className = className;
    }

    public synchronized CopyStrategy getCopyStrategyInstance() {
        if (this.strategy == null) {
            Class<?> copyStrategy = null;
            try {
                copyStrategy = Class.forName(this.className);
                this.strategy = (CopyStrategy)copyStrategy.newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Couldn't find the CopyStrategy class!", e);
            }
            catch (InstantiationException e) {
                throw new RuntimeException("Couldn't instantiate the CopyStrategy instance!", e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Couldn't instantiate the CopyStrategy instance!", e);
            }
            catch (ClassCastException e) {
                throw new RuntimeException(copyStrategy != null ? copyStrategy.getSimpleName() + " doesn't implement net.sf.ehcache.store.compound.CopyStrategy" : "Error with CopyStrategy", e);
            }
        }
        return this.strategy;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.className == null ? 0 : this.className.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CopyStrategyConfiguration other = (CopyStrategyConfiguration)obj;
        return !(this.className == null ? other.className != null : !this.className.equals(other.className));
    }
}

