/**
 * 流程定义及部署管理
 * 
 * @author 袁晓冬
 */
$.namespace("wf.process");
/** 一览控件 */
wf.process.$grid = null;
/** 公用代码【是否】 */
wf.process.sfCodeArray = null;
/** 流程公用弹出窗口 */
wf.process.$popWin = null;
/** 查询面板-名称 */
wf.process.q$processname = null;
/** 查询面板-key */
wf.process.q$key = null;
/** 初始化组件引用 */
wf.process.initComp = function() {
    wf.process.$grid = $('#grid');
    wf.process.$popWin = $('#popWin');
    wf.process.q$processname = $('#qprocessname');
    wf.process.q$key = $('#qkey');
}
/** 页面初始化 */
wf.process.init = function() {
    wf.process.initComp();
        // 初始化一览列表
    wf.process.$grid.datagrid({
        pageSize : 20,
        url : $.ctx + "/wf/process/list",
    });
}
/**
 * XML链接格式化
 */
wf.process.xmlFormatter = function(value, rowData, rowIndex) {
    return "<a target='_blank' href='" + $.ctx + "/wf/process/readResource?processDefinitionId="
            + rowData.processDefinitionId + "&resourceType=xml'>查看</a>";
}
/**
 * 流程图链接格式化
 */
wf.process.imageFormatter = function(value, rowData, rowIndex) {
    return "<a target='_blank' href='" + $.ctx + "/wf/process/readResource?processDefinitionId="
            + rowData.processDefinitionId + "&resourceType=image'>查看</a>";
}
/**
 * 删除流程
 */
wf.process.deleteProcess = function() {
    var rows = wf.process.$grid.datagrid("getSelections");
    if (rows.length > 0) {
        $.messager.confirm("确认", "确定要删除吗？", function(msg) {
            if (msg) {
                // 确认删除
                var ids = [];
                $.each(rows, function(i) {
                    ids.push(rows[i].deploymentId);
                });
                $.post($.ctx + "/wf/process/delete", {
                    ids : ids.join(",")
                }, function(data, status) {
                    if (data.success) {
                        wf.process.$grid.datagrid('reload');
                    }
                    else {
                        $.messager.showError(data.message);
                    }
                }, "json");
            }
            ;
        });
    }
    else {
        $.messager.alert("提示", "请选择要删除的流程！");
    }

}
/**
 * 更新流程状态
 */
wf.process.updateState = function() {
    var row = wf.process.getOneRow();
    if (!row) return;
    var msg = "确定要";
    if (row.suspended) {
        msg += "激活";
    }
    else {
        msg += "挂起";
    }
    msg += "流程【" + row.processName + "】吗？"
    $.messager.confirm("确认", msg, function(msg) {
        if (msg) {
            $.post($.ctx + "/wf/process/updateState", {
                processDefinitionId : row.processDefinitionId,
                state : row.suspended ? "active" : "suspend"
            }, function(data, status) {
                if (data.success) {
                    wf.process.$grid.datagrid('reload');
                }
                else {
                    $.messager.showError(data.message);
                }
            }, "json");
        }
    });
}
/**
 * 选择一条记录
 */
wf.process.getOneRow = function() {
    var rows = wf.process.$grid.datagrid("getSelections");
    if (rows.length > 0) {
        if (rows.length == 1) {
            return rows[0];
        }
        else {
            $.messager.alert("提示", "只能选择一条记录！");
            return null;
        }
    }
    else {
        $.messager.alert("提示", "请选择记录！");
        return null;
    }
}
/**
 * 部署流程
 */
wf.process.deploy = function() {
    $.messager.alert("提示", "敬请期待！");
}
/** 刷新一览列表 */
wf.process.refreshGrid = function() {
    
    
    // 刷新一览列表
    wf.process.$grid.datagrid({
    	pageSize : 20,
        url : $.ctx + "/wf/process/list",
        
    });
}