/**
 * 系统首页
 * 
 * @author 袁晓冬
 */
$.namespace("org.main");
/** 菜单树 */
org.main.$orgTree = null;
/** 一览控件 */
org.main.$grid = null;
/** 新增窗口 */
org.main.$popWin = null;
/** 用户窗口 */
org.main.$userWin = null;
/** 查询面板-组织名 */
org.main.q$orgname = null;
/** 查询面板-是否有效 */
org.main.q$valid = null;
/** 是否公用代码 */
org.main.sfCodeArray = null;
/** 初始化组件引用 */
org.main.initComp = function() {
    org.main.$orgTree = $('#orgTree');
    org.main.$grid = $('#grid');
    org.main.q$valid = $('#qvalid');
    org.main.q$orgname = $('#qorgname');
    org.main.$popWin = $('#popWin');
    org.main.$userWin =  $('#userWin');
}
org.main.refreshTree = function() {
    // 初始化字典树
    org.main.$orgTree.tree({
        url : $.ctx + "/org/tree",
        method : 'get',
        checkbox : true,
        queryParams : {},
        onClick : function(node) {
            org.main.refreshGrid(node);
        }
    });
}

/** 页面初始化 */
org.main.init = function() {
    org.main.initComp();
    org.main.initCombox();
    org.main.refreshTree();
    // 初始化一览
    org.main.$grid.datagrid({
        pageSize : 20,

        onBeforeLoad : function(param) {
            param.orgname = $.trim(org.main.q$orgname.val());
            param.valid = org.main.q$valid.combobox('getValue');
        }
    });
}
/**
 * 初始化下拉框
 */
org.main.initCombox = function() {
    // 初始化人员状态下拉框
    var dataArr = new Array();
    dataArr = dataArr.concat(org.main.sfCodeArray);
    dataArr.push({
        'code' : '',
        'text' : '全部'
    });
    org.main.q$valid.combobox({
        valueField : 'code',
        textField : 'text',
        data : dataArr,
        editable : false
    });
};
/** 根据树图所选择的节点刷新一览列表 */
org.main.refreshGrid = function(node) {
    if (!node) {
        node = org.main.$orgTree.tree('getSelected');
    }
    if (!node) { return; }
    // 刷新一览列表
    org.main.$grid.datagrid({
        pageSize : 20,
        url : $.ctx + "/org/list",
        queryParams : {
            pid : node.id
        }
    });
}
/**
 * 创建组织处理
 */
org.main.doAddRoot = function() {
    org.main.addOrg();
}
/**
 * 创建下级组织处理
 */
org.main.doAdd = function() {
    var selectedNode = org.main.$orgTree.tree('getSelected');
    if (!selectedNode) {
        $.messager.alert('提示', '请选择上级组织！');
        return;
    }
    if (selectedNode.leaf != 'true') {
        org.main.addOrg(selectedNode.id);
    }
}
/**
 * 记录编辑处理
 */
org.main.doEdit = function() {
    var rows = org.main.$grid.datagrid("getSelections");
    if (rows.length > 0) {
        if (rows.length == 1) {
            org.main.$popWin.dialog({
                href : $.ctx + "/org/edit",
                title : "编辑",
                queryParams : {
                    id : rows[0].id
                },
                onClose : org.main.refreshGrid
            }).dialog('open');
        }
        else {
            $.messager.alert("提示", "只能选择一条记录！");
        }
    }
    else {
        $.messager.alert("提示", "请选择要修改的记录！");
    }
}
/** 删除处理 */
org.main.doDel = function() {
    var rows = org.main.$grid.datagrid("getSelections");
    if (rows.length > 0) {
        $.messager.confirm("确认", "确定要删除吗？", function(msg) {
            if (msg) {
                // 确认删除
                var ids = [];
                $.each(rows, function(i) {
                    ids.push(rows[i].id);
                });
                $.post($.ctx + "/org/delete", {
                    ids : ids.join(",")
                }, function(data, status) {
                    if (data.success) {
                        // close the dialog
                        org.main.$popWin.dialog('close');
                        var selectedNode = org.main.$orgTree.tree('getSelected');
                        org.main.$orgTree.tree('reload', selectedNode.target);
                        org.main.refreshGrid(selectedNode);
                    }
                    else {
                        $.messager.showError(data.message);
                    }
                }, "json");
            }
        });
    }
    else {
        $.messager.alert("提示", "请选择要删除的记录！");
    }
}
/**
 * 新增菜单
 */
org.main.addOrg = function(pid) {
    if (!pid) pid = ""
    org.main.$popWin.dialog({
        href : $.ctx + '/org/add?pid=' + pid,
        title : "新增"
    }).dialog('open');
}

/**
 * 组织性质维护
 */
org.main.attrManeger = function() {
    var selectedNode = org.main.$orgTree.tree('getSelected');
    if (!selectedNode) {
        $.messager.alert('提示', '请选择上级字典编码！');
        return;
    }
    // 组织性质维护
    if (selectedNode.leaf != 'true') {
        org.main.$popWin.dialog({
            href : $.ctx + '/org/attr?id=' + selectedNode.id,
            title : "组织性质维护"
        }).dialog('open');
    }
}
// 刷新树图
org.main.treeReload = function() {
    var selectedNode = org.main.$orgTree.tree('getSelected');
    if (!selectedNode) {
        org.main.$orgTree.tree('reload');
    }
    else {
        org.main.$orgTree.tree('reload', selectedNode.target);
    }
}
org.main.setQx = function() {
    role.main.setPermission = function(roleId) {
        role.main.$permWin.dialog({
            href : $.ctx + '/org/auth/' + roleId,
            title : "设置组织权限"
        }).dialog('open');
    }
}
/**
 * 用户管理
 */
org.main.userMgr = function() {

}