/**
 * 菜单详细画面用js
 * 
 * @author 袁晓冬
 */
$.namespace("menu.btn");
/** 是否公用代码 */
menu.btn.sfCodeArray = null;
menu.btn.$leaf = null;
menu.btn.$valid = null;
/** 初始化组件引用 */
menu.btn.initComp = function() {
    menu.btn.$leaf = $('#leaf');
    menu.btn.$valid = $('#valid');
}
/** 页面初始化 */
menu.btn.init = function() {
    // 转换数据字符串为对象
    if (menu.btn.data) {
        menu.btn.data = $.parseJSON(menu.btn.data);
    }
    menu.btn.initComp();
    menu.btn.initCombox();
}
/**
 * 初始化下拉框
 */
menu.btn.initCombox = function() {
    // 初始化人员状态下拉框
    var dataArr = new Array();
    dataArr = dataArr.concat(menu.btn.sfCodeArray);
    menu.btn.$leaf.combobox({
        valueField : 'code',
        textField : 'text',
        data : dataArr,
        editable : false,
        onLoadSuccess : function() {
            // 默认选中可用
            if (menu.btn.data["leaf"] === 'N') {
                menu.btn.$leaf.combobox('select', consts.CODE_TY_SF_F);
            } else {
                menu.btn.$leaf.combobox('select', consts.CODE_TY_SF_S);
            }
        }
    });
    menu.btn.$valid.combobox({
        valueField : 'code',
        textField : 'text',
        data : dataArr,
        editable : false,
        onLoadSuccess : function() {
            // 默认选中可用
            if (menu.btn.data["valid"] === 'N') {
                menu.btn.$valid.combobox('select', consts.CODE_TY_SF_F);
            } else {
                menu.btn.$valid.combobox('select', consts.CODE_TY_SF_S);
            }
        }
    });
};
/**
 * 保存菜单
 */
menu.btn.save = function() {
    $('#rform').form('submit', {
        url : $.ctx + '/menu/saveBtn',
        onSubmit : function() {
            return $(this).form('validate');
        },
        success : function(data, status) {
            if (data) {
                data = $.parseJSON(data);
            }
            if (data.success) {
                // close the dialog
                menu.main.$popWin.dialog('close');
                // 刷新树图
                var selectedNode = menu.main.$menuBtnTree.tree('getSelected');
                menu.main.$menuBtnTree.tree('reload', selectedNode.target);
                menu.main.refreshGrid(selectedNode);
            } else {
                $.messager.showError(data.message);
            }
        }
    });
}