/**
 * 通讯录组名js
 * 
 * @author yangrui
 */
$.namespace("grsw.zm.main");

grsw.zm.main.$popWin = null;

/** 页面初始化 */
grsw.zm.main.init = function() {
    // grsw.zm.main.$popWin = $("#zmpopWin");
    grsw.zm.main.initpage();

};
/** 页面初始化 */
grsw.zm.main.initpage = function() {
    $("#pagetools").hide();
    // 把form传入，构造翻页控件
    pageinfo($("#zmform"));// 见common.js
}

// 通讯录组名信息查询
grsw.zm.main.search = function() {
    $("#form").submit();
};

/**
 * 全选/全不选
 */
grsw.zm.main.all = function() {
    if ($("#all").prop("checked")) {
        $(".fwgl_table_checkbox").each(function() {
            $(this).prop("checked", true);
        });
    }
    else {
        $(".fwgl_table_checkbox").each(function() {
            $(this).prop("checked", false);
        });
    }
}

/**
 * 获取选中的数据 返回选中数据的id数组
 */
grsw.zm.main.getSelectedRecords = function() {
    var ids = new Array();
    $(".fwgl_table_checkbox").each(function() {
        if ($(this).prop("checked")) {
            ids.push($(this).val());
        }
    });
    return ids;
}

/** 跳到新增页面 */
grsw.zm.main.doAdd = function() {
    $dialog = $("#zmpopWin").dialog({
        href : $.ctx + '/zm/add',
        title : "新增",
        width : 420,
        height : 250,
        onClose : function() {
            // $dialog.dialog('destroy');
        },
        buttons : [ {
            text : '保存',
            iconCls : 'icon-xt-ok',
            handler : function() {
                if (grsw.zm.main.save()) {
                    $dialog.dialog('close');
                }
            }
        }, {
            text : '取消',
            iconCls : 'icon-cancel',
            handler : function() {
                $dialog.dialog('close');
            }
        } ]
    });
    $dialog.dialog('open');
}


/**
 * 判断是否为空
 * 
 * @param str
 * @returns {Boolean}
 */
function isEmpty(str) {
    if (str != null && str != "" && str.length != 0) {
        return false;
    }
    else {
        return true;
    }
}

// 保存
grsw.zm.main.save = function() {
    if(isEmpty($('#zmname').val())){
        $.messager.alert("提示", "组名不能为空！", 'info', function() {
            $("#zmname").focus();
        });
        return false;
    }
    var opinion = $('#reason').val();
    if(opinion&&opinion.length>20){
        $.messager.alert("消息", "描述请小于20字。");
        return false;
    }
    
    $('#zmform').form('submit', {
        url : $.ctx + '/zm/save',
        onSubmit : function() {
        },
        success : function(data, status) {
            if (data) {
                data = $.parseJSON(data);
            }
            if (data.success) {
                // 刷新树图
                window.location = $.ctx + '/zm/main';
            }
            else {
                $.messager.showError(data.message);
            }
        }
    })
}
// 编辑
grsw.zm.main.doEdit = function(id) {
  
    $dialog = $("#zmpopWin").dialog({
        href : $.ctx + '/zm/edit?id=' + id,
        title : "修改",
        width : 420,
        height : 250,
        onClose : function() {
            // $dialog.dialog('destroy');
        },
        buttons : [ {
            text : '保存',
            iconCls : 'icon-xt-ok',
            handler : function() {
                if (grsw.zm.main.save()) {
                    $dialog.dialog('close');
                }
            }
        }, {
            text : '取消',
            iconCls : 'icon-cancel',
            handler : function() {

                $dialog.dialog('close');
            }
        } ]
    });
    $dialog.dialog('open');
}

/** 删除处理 */
grsw.zm.main.doDel = function() {
    var ids = grsw.zm.main.getSelectedRecords();
    if (ids.length > 0) {
        $.messager.confirm("确认", "确定要删除吗？", function(msg) {
            if (msg) {
                // 确认删除
                $.post($.ctx + "/zm/delete", {
                    ids : ids.join(",")
                }, function(data, status) {
                    if (data.success) {
                        location.href = $.ctx + "/zm/main";
                    }
                    else {
                        $.messager.alert("提示", data.message);
                    }
                }, "json");
            }
            ;
        });
    }
    else {
        $.messager.alert("提示", "请选择要删除的记录！");
    }
}

grsw.zm.main.doShow = function(id) {
    location.href = $.ctx + "/txl/main?zmid=" + id;
}