/**
 * 通讯录js
 */
$.namespace("grsw.mytxl.main");

grsw.mytxl.main.$popWin = null;

/** 页面初始化 */
grsw.mytxl.main.init = function() {
    grsw.mytxl.main.$popWin = $("#txlpopWin");
    grsw.mytxl.main.initpage();

};

/** 跳到查看页面 */
grsw.mytxl.main.doAdd = function() {
    $dialog = $("#txlpopWin").dialog({
        href : $.ctx + '/txl/add',
        title : "新增",
        width : 500,
        height : 335,
        top : $(document).scrollTop() + ($(window).height() - 400) * 0.5,
        left : $(document).scrollLeft() + ($(window).width() - 600) * 0.5,
        onClose : function() {
            // $dialog.dialog('destroy');
        },
        buttons : [ {
            text : '保存',
            iconCls : 'icon-xt-ok',
            handler : function() {
                if (grsw.mytxl.main.save()) {
                    $dialog.dialog('close');
                }
            }
        }, {
            text : '取消',
            iconCls : 'icon-cancel',
            handler : function() {
                $("#txlpopWin").dialog('close');
            }
        } ]
    });
    $dialog.dialog('open');
}

/**
 * 全选/全不选
 */
grsw.mytxl.main.all = function() {
    if ($("#all").prop("checked")) {
        $(".fwgl_table_checkbox").each(function() {
            $(this).prop("checked", true);
        });
    }
    else {
        $(".fwgl_table_checkbox").each(function() {
            $(this).prop("checked", false);
        });
    }
}

/**
 * 获取选中的数据 返回选中数据的id数组
 */
grsw.mytxl.main.getSelectedRecords = function() {
    var ids = new Array();
    $(".fwgl_table_checkbox").each(function() {
        if ($(this).prop("checked")) {
            ids.push($(this).val());
        }
    });
    return ids;
}

/** 页面初始化 */
grsw.mytxl.main.initpage = function() {
    $("#pagetools").hide();
    // 把form传入，构造翻页控件
    pageinfo($("#txlform"));// 见common.js
}

// 通讯录信息查询
grsw.mytxl.main.search = function() {
    $("#txlform").submit();
};

/**
 * 判断是否为空
 * 
 * @param str
 * @returns {Boolean}
 */
function isEmpty(str) {
    if (str != null && str != "" && str.length != 0) {
        return false;
    }
    else {
        return true;
    }
}

grsw.mytxl.main.check = function() {
    var name = $("#name").val();
    var tel = $("#tel").val();
    var mobile = $("#mobile").val();
    var email = $("#email").val();
    var orgname = $("#orgname").val();
    var zmid = $('#zmid').val();
    var sortno = $('#sortno').val();
    var flag = true;
    if (isEmpty(zmid)) {
        $.messager.alert("提示", "请选组名！", 'info', function() {
            $("#zmid").focus();
        });
        flag = false;
        return false;
    }
    if (isEmpty(name)) {
        $.messager.alert("提示", "请输入姓名！", 'info', function() {
            $("#name").focus();
        });
        flag = false;
        return false;
    }
    if (isEmpty(orgname)) {
        $.messager.alert("提示", "请输入部门！", 'info', function() {
            $("#orgname").focus();
        });
        flag = false;
        return false;
    }

    // 输入手机号合理性判断
    var telValidate = /^[+\d\s]+$/;
    if (!isEmpty($("#mobile").val())) {
        if (telValidate.test($("#mobile").val()) == false) {
            $.messager.alert("提示", "请输入合理的手机号！", 'info', function() {
                $("#mobile").focus();
            });
            flag = false;
            return false;
        }
    }
   /* // 输入电话号码合理性判断
    var telValidate = /^([0-9\d+-]+)$/;
    if (!isEmpty($("#tel").val())) {
        if (telValidate.test($("#tel").val()) == false) {
            $.messager.alert("提示", "请输入合理的电话号码！", 'info', function() {
                $("#tel").focus();
            });
            flag = false;
            return false;
        }
    }*/
    // email的合理判断
    var telValidate = /^([\.a-zA-Z0-9_-])+@([a-zA-Z0-9_-])+(\.[a-zA-Z0-9_-])+/;
    if (!isEmpty($("#email").val())) {
        if (telValidate.test($("#email").val()) == false) {
            $.messager.alert("提示", "请输入正确的邮箱地址!", 'info', function() {
                $("#email").focus();
            });
            flag = false;
            return false;
        }
    }
    
    if (isEmpty(sortno)) {
        $.messager.alert("提示", "请填写排序号！", 'info', function() {
            $("#sortno").focus();
        });
        flag = false;
        return false;
    }
    if(!isEmpty(sortno)&&isNaN(parseInt(sortno))){
    	$.messager.alert("提示", "排序号必须为数字！", 'info', function() {
            $("#sortno").focus();
        });
        flag = false;
        return false;
    }
    return flag;
}
// 保存
grsw.mytxl.main.save = function() {
    var flag = grsw.mytxl.main.check();
    if (flag) {
        $('#mytxlform').form('submit', {
            url : $.ctx + '/txl/save',
            onSubmit : function() {
            },
            success : function(data, status) {
                if (data) {
                    data = $.parseJSON(data);
                }
                if (data.success) {
                    // 刷新树图
                    window.location = $.ctx + '/txl/main';
                }
                else {
                    $.messager.showError(data.message);
                }
            }
        })
    }
}

// 编辑
grsw.mytxl.main.doEdit = function(id) {
    $dialog = $("#txlpopWin").dialog({
        href : $.ctx + '/txl/edit?id=' + id,
        title : "修改",
        width : 500,
        height : 335,
        top : $(document).scrollTop() + ($(window).height() - 400) * 0.5,
        left : $(document).scrollLeft() + ($(window).width() - 600) * 0.5,
        onClose : function() {
            // $dialog.dialog('destroy');
        },
        buttons : [ {
            text : '保存',
            iconCls : 'icon-xt-ok',
            handler : function() {
                if (grsw.mytxl.main.save()) {
                    $dialog.dialog('close');
                }
            }
        }, {
            text : '取消',
            iconCls : 'icon-cancel',
            handler : function() {
                $("#txlpopWin").dialog('close');
            }
        } ]
    });
    $dialog.dialog('open');
}

grsw.mytxl.main.addZm = function() {
    $dialog = $("#zmpopWin").dialog({
        href : $.ctx + '/zm/add',
        title : "新增组名",
        width : 400,
        height : 250,
        top : $(document).scrollTop() + ($(window).height() - 300) * 0.5,
        left : $(document).scrollLeft() + ($(window).width() - 500) * 0.5,
        onClose : function() {
            // $dialog.dialog('destroy');
        },
        buttons : [ {
            text : '保存',
            iconCls : 'icon-xt-ok',
            handler : function() {
                if (grsw.mytxl.main.saveZm()) {
                    $dialog.dialog('close');
                }
            }
        }, {
            text : '取消',
            iconCls : 'icon-cancel',
            handler : function() {
                $dialog.dialog('close');
            }
        } ]
    });
    $dialog.dialog('open');
}

grsw.mytxl.main.saveZm = function() {
    if(isEmpty($('#zmname').val())){
        $.messager.alert("提示", "组名不能为空！", 'info', function() {
            $("#zmname").focus();
        });
        return false;
    }
    $('#zmform').form('submit', {
        url : $.ctx + '/zm/save',
        onSubmit : function() {
        },
        success : function(data, status) {
            if (data) {
                data = $.parseJSON(data);
            }
            if (data.success) {
                var option = $("<option>").val(data.attrs.zm.id).text(data.attrs.zm.name);
                $("#zmid").append(option);
                $dialog.dialog('close');
                $.messager.alert("提示", "组名添加成功！");
            }
            else {
                $.messager.showError(data.message);
            }
        }
    })

}

/** 删除处理 */
grsw.mytxl.main.doDel = function() {
    var ids = grsw.mytxl.main.getSelectedRecords();
    if (ids.length > 0) {
        $.messager.confirm("确认", "确定要删除吗？", function(msg) {
            if (msg) {
                // 确认删除
                $.post($.ctx + "/txl/delete", {
                    ids : ids.join(",")
                }, function(data, status) {
                    if (data.success) {
                        location.href = $.ctx + "/txl/main";
                    }
                    else {
                        $.messager.alert("提示", data.message);
                    }
                }, "json");
            }
            ;
        });
    }
    else {
        $.messager.alert("提示", "请选择要删除的记录！");
    }
}

/**
 * 列表字段排序
 */
grsw.mytxl.main.setSort=function(sortname,order){
    $("#pagesort").val(sortname);
    $("#pageorder").val(order);
    $("#txlform").submit();
}