/**
 * 数据权限管理js
 * 
 * @author 袁晓冬
 */
$.namespace("dataperm.main");
/** 一览控件 */
dataperm.main.$grid = null;
/** 通用弹窗 */
dataperm.main.$popWin = null;
/** 公用代码【是否】 */
dataperm.main.sfCodeArray = null;
/** 查询面板-角色编码 */
dataperm.main.q$roleCode = null;
/** 查询面板-数据分类 */
dataperm.main.q$dataType = null;
/** 查询面板-操作权限 */
dataperm.main.q$oper = null;

/** 初始化组件引用 */
dataperm.main.initComp = function() {
	dataperm.main.$grid = $('#grid');
	dataperm.main.q$roleCode = $('#qroleCode');
	dataperm.main.q$dataType = $('#qdataType');
	dataperm.main.q$oper = $('#qoper');
	dataperm.main.$popWin = $('#popWin');
	

}
/** 页面初始化 */
dataperm.main.init = function() {
	dataperm.main.initComp();
	// 初始化一览列表
	dataperm.main.$grid.datagrid({
		pageSize : 20,
		url : $.ctx + "/dataPerm/list",
	});

}

/** 根据树图所选择的节点刷新一览列表 */
dataperm.main.refreshGrid = function(node) {
	
	// 刷新一览列表
	dataperm.main.$grid.datagrid({
		url : $.ctx + "/dataPerm/list",
	});
}
/**
 * 记录新增处理
 */
dataperm.main.doAdd = function() {

	dataperm.main.$popWin.dialog({
		href : $.ctx + '/dataPerm/add',
		title : "权限新增"
	}).dialog('open');

}
/**
 * 记录编辑处理
 */
dataperm.main.doEdit = function() {
	var rows = dataperm.main.$grid.datagrid("getSelections");
	if (rows.length > 0) {
		if (rows.length == 1) {
			dataperm.main.$popWin.dialog({
				href : $.ctx + "/dataPerm/edit",
				title : "编辑",
				queryParams : {
					id : rows[0].id
				},
				onClose : dataperm.main.refreshGrid
			}).dialog('open');
		} else {
			$.messager.alert("提示", "只能选择一条记录！");
		}
	} else {
		$.messager.alert("提示", "请选择要修改的记录！");
	}
}
/** 删除处理 */
dataperm.main.doDel = function() {
	var rows = dataperm.main.$grid.datagrid("getSelections");
	if (rows.length > 0) {
		$.messager.confirm("确认", "确定要删除吗？", function(msg) {
			if (msg) {
				// 确认删除
				var ids = [];
				$.each(rows, function(i) {
					ids.push(rows[i].id);
				});
				$.post($.ctx + "/dataPerm/delete", {
					ids : ids.join(",")
				}, function(data, status) {
					if (data.success) {
						// close the dialog
						dataperm.main.$popWin.dialog('close');
						dataperm.main.refreshGrid();
					} else {
						$.messager.showError(data.message);
					}
				}, "json");
			}
			;
		});
	} else {
		$.messager.alert("提示", "请选择记录！");
	}
}
