/**
 * 新通javascript组件
 */
(function(init) {
    if (init) {
        var pathName = document.location.pathname;
        var index = pathName.substr(1).indexOf("/");
        var ctx = pathName.substr(0, index + 1);
        Xt = {
            ctx : ctx,
            /**
             * config.wfid:流程ID
             */
            showChooseUserDialog : function(config) {
                config = config || {};
                var href = ctx + '/wf/task/chooseUser?wfid=' + config.wfid + "&taskId=" + config.taskId + "&flag="
                        + config.flag+ "&id="+ config.id;
                if (!(Xt.userDialog)) {
                    Xt.userDialog = $('<div/>');
                }
                Xt.userDialog.dialog({
                    title : '选择环节用户',
                    width : 600,
                    height : 300,
                    iconCls : 'pag-search',
                    closed : true,
                    cache : false,
                    href : href,
                    modal : true,
                    toolbar : '#toolbar',
                    onLoad : function() {
                    },
                    onClose : function() {
                        Xt.userDialog.dialog('destroy');
                    },
                    buttons : [ {
                        text : '完成',
                        iconCls : 'icon-xt-ok',
                        handler : function() {
                            var rows = [];
                            if($("#days").val().replace(/\s/g,"") != "" && $("#days").val().replace(/\s/g,"")){
                            	if(parseInt($("#days").val())>10){
                            		$.messager.alert("提示", "限办天数不可超过10天");
                            		return;
                            	}else if($("#days").val() == "0" || parseInt($("#days").val()) == 0){
                            		$.messager.alert("提示", "限办天数不可为0天");
                            		return;
                            	}
                            	
                            }

                        		
                        	
                            if (config.flag == "th") {
                                var row = {
                                    step : $("#step").val(),
                                    users : $("#hIds").val(),
                                    days : $("#days").val()
                                }
                                rows.push(row);
                            }
                            else {
                                var row = {
                                    step : $("#step").val(),
                                    users : $("#hIds").val(),
                                    days : $("#days").val(),
                                    id : $("#id").val()
                                }
                                rows.push(row);
                            }
                            if (rows.length <= 0 || isEmpty(rows[0].step) || isEmpty(rows[0].users)) {
                                $.messager.alert("提示", "请选择下一环节和办理人");
                            }
                            else {
                                if (config.callback && typeof config.callback == 'function') {
                                    config.callback(true, rows);
                                }
                                Xt.userDialog.dialog('close');
                            }
                        }
                    }, {
                        text : '取消',
                        iconCls : 'icon-cancel',
                        handler : function() {
                            if (config.callback && typeof config.callback == 'function') {
                                config.callback(false);
                            }
                            Xt.userDialog.dialog('close');
                        }
                    } ]

                }).dialog('open');
            },

            showChooseUserBackDialog : function(config) {
                config = config || {};
                var href = ctx + '/wf/task/chooseUser?wfid=' + config.wfid + "&taskId=" + config.taskId + "&flag="
                        + config.flag;
                if (!(Xt.backUserDialog)) {
                    Xt.backUserDialog = $('<div/>');
                }
                if (!(Xt.config)) {
                    Xt.config = config;
                }
                Xt.backUserDialog.dialog({
                    title : '选择环节用户',
                    width : 800,
                    height : 380,
                    iconCls : 'pag-search',
                    closed : true,
                    cache : false,
                    href : href,
                    modal : true,
                    toolbar : '#toolbar',
                    onLoad : function() {
                    },
                    onClose : function() {
                        Xt.backUserDialog.dialog('destroy');
                    },
                    buttons : [ {
                        text : '取消',
                        iconCls : 'icon-cancel',
                        handler : function() {
                            if (config.callback && typeof config.callback == 'function') {
                                config.callback(false);
                            }
                            Xt.backUserDialog.dialog('close');
                        }
                    } ]

                }).dialog('open');
            },
            
            /**
             * 弹出意见
             */
            showGryjDialog : function(config) {
                var href = ctx + '/wf/task/gryj?yj='+encodeURI(encodeURI(config.yj));
                if (!(Xt.gryjDialog)) {
                    Xt.gryjDialog = $('<div/>');
                }
                Xt.gryjDialog.dialog({
                    title : '填写意见',
                    width : 430,
                    height : 330,
                    iconCls : 'pag-search',
                    closed : true,
                    cache : false,
                    href : href,
                    modal : true,
                    toolbar : '#toolbar',
                    onLoad : function() {
                    },
                    onClose : function() {
                        Xt.gryjDialog.dialog('destroy');
                    },
                    buttons : [ {
                        text : '完成',
                        iconCls : 'icon-xt-ok',
                        handler : function() {
                        	var opinion = $('#opinion1').val();
                            if(opinion&&opinion.length>200){
                                $.messager.alert("提示", "意见请小于200字。");
                                return false;
                            }else{
                            	if (config.callback && typeof config.callback == 'function') {
                                    config.callback(true);
                                }
                            	Xt.gryjDialog.dialog('close');
                            }
                            
                        }
                    }, {
                        text : '取消',
                        iconCls : 'icon-cancel',
                        handler : function() {
                            if (config.callback && typeof config.callback == 'function') {
                                config.callback(false);
                            }
                            Xt.gryjDialog.dialog('close');
                        }
                    } ]

                }).dialog('open');
            }
        }
    }
}(typeof (Xt) === "undefined"));