/**
 * 字典维护详细画面
 * 
 * @author 袁晓冬
 */
$.namespace("code.detail");
/** 是否公用代码 */
code.detail.sfCodeArray = null;
code.detail.$leaf = null;
code.detail.$valid = null;
/** 初始化组件引用 */
code.detail.initComp = function() {
    code.detail.$leaf = $('#leaf');
    code.detail.$valid = $('#valid');
}
/** 页面初始化 */
code.detail.init = function() {
    // 转换数据字符串为对象
    if (code.detail.data) {
        code.detail.data = $.parseJSON(code.detail.data);
    }
    code.detail.initComp();
    code.detail.initCombox();
}
/**
 * 初始化下拉框
 */
code.detail.initCombox = function() {
    // 初始化人员状态下拉框
    var dataArr = new Array();
    dataArr = dataArr.concat(code.detail.sfCodeArray);
    code.detail.$leaf.combobox({
        valueField : 'code',
        textField : 'text',
        data : dataArr,
        editable : false,
        onLoadSuccess : function() {
            // 默认选中可用
            if (code.detail.data["leaf"] === 'N') {
                code.detail.$leaf.combobox('select', consts.CODE_TY_SF_F);
            } else {
                code.detail.$leaf.combobox('select', consts.CODE_TY_SF_S);
            }
        }
    });
    code.detail.$valid.combobox({
        valueField : 'code',
        textField : 'text',
        data : dataArr,
        editable : false,
        onLoadSuccess : function() {
            // 默认选中可用
            if (code.detail.data["valid"] === 'N') {
                code.detail.$valid.combobox('select', consts.CODE_TY_SF_F);
            } else {
                code.detail.$valid.combobox('select', consts.CODE_TY_SF_S);
            }
        }
    });

};
/**
 * 保存菜单
 */
code.detail.save = function() {
    $('#rform').form('submit', {
        url : $.ctx + '/code/save',
        onSubmit : function() {
            return $(this).form('validate');
        },
        success : function(data, status) {
            if (data) {
                data = $.parseJSON(data);
            }
            if (data.success) {
                code.main.$popWin.dialog('close');
                var selectedNode = code.main.$codeTree.tree('getSelected');
                code.main.$codeTree.tree('reload', selectedNode.target);
                code.main.refreshGrid();
            } else {
                $.messager.showError(data.message);
            }
        }
    });
}