-- drop user gkoa cascade;
-- create user gkoa IDENTIFIED by gkoa;
-- grant connect,dba to gkoa;
-- 业务操作日志表
CREATE TABLE T_XTFRAME_BIZ_LOG
(
  ID           VARCHAR2(40) NOT NULL,
  USERID       VARCHAR2(40),
  LOG_TYPE     VARCHAR2(100),
  COST         NUMBER,
  METHOD       VARCHAR2(250),
  URL          VARCHAR2(200),
  IP           VARCHAR2(25),
  HANDLER_TYPE VARCHAR2(20),
  PARAM        VARCHAR2(1000),
  BROWSER      VARCHAR2(50),
  OS           VARCHAR2(50),
  REMARK       VARCHAR2(250),
  INSERT_TIME  TIMESTAMP(6)
);

COMMENT ON TABLE  T_XTFRAME_BIZ_LOG   IS '业务操作日志表';
COMMENT ON COLUMN T_XTFRAME_BIZ_LOG.ID  IS '唯一标识';
COMMENT ON COLUMN T_XTFRAME_BIZ_LOG.USERID  IS '操作人ID';
COMMENT ON COLUMN T_XTFRAME_BIZ_LOG.LOG_TYPE  IS '日志类型';
COMMENT ON COLUMN T_XTFRAME_BIZ_LOG.COST  IS '记录状态';
COMMENT ON COLUMN T_XTFRAME_BIZ_LOG.METHOD  IS '操作方法';
COMMENT ON COLUMN T_XTFRAME_BIZ_LOG.URL  IS '请求URL';
COMMENT ON COLUMN T_XTFRAME_BIZ_LOG.IP  IS '客户端IP';
COMMENT ON COLUMN T_XTFRAME_BIZ_LOG.HANDLER_TYPE  IS '访问类型';
COMMENT ON COLUMN T_XTFRAME_BIZ_LOG.PARAM  IS '请求参数';
COMMENT ON COLUMN T_XTFRAME_BIZ_LOG.BROWSER  IS '浏览器版本';
COMMENT ON COLUMN T_XTFRAME_BIZ_LOG.OS  IS '操作系统版本';
COMMENT ON COLUMN T_XTFRAME_BIZ_LOG.REMARK  IS '备注';
COMMENT ON COLUMN T_XTFRAME_BIZ_LOG.INSERT_TIME  IS '记录时间';

ALTER TABLE T_XTFRAME_BIZ_LOG ADD PRIMARY KEY (ID);
 
-- 字典表
CREATE TABLE T_XTFRAME_CODE
(
  ID     VARCHAR2(40) NOT NULL,
  PID    VARCHAR2(40),
  PCODE  VARCHAR2(40),
  TEXT   VARCHAR2(100),
  CODE   VARCHAR2(100),
  VAL    VARCHAR2(100),
  LEAF   CHAR(1),
  VALID  CHAR(1),
  SORTNO INTEGER
);

COMMENT ON TABLE  T_XTFRAME_CODE  IS '字典表';
COMMENT ON COLUMN T_XTFRAME_CODE.ID  IS '唯一标识';
COMMENT ON COLUMN T_XTFRAME_CODE.PID  IS '上级ID';
COMMENT ON COLUMN T_XTFRAME_CODE.PCODE  IS '上级编码';
COMMENT ON COLUMN T_XTFRAME_CODE.TEXT  IS '名称';
COMMENT ON COLUMN T_XTFRAME_CODE.CODE  IS '编码';
COMMENT ON COLUMN T_XTFRAME_CODE.VAL  IS '编码值';
COMMENT ON COLUMN T_XTFRAME_CODE.LEAF  IS '是否末级';
COMMENT ON COLUMN T_XTFRAME_CODE.VALID  IS '是否有效';

ALTER TABLE T_XTFRAME_CODE ADD PRIMARY KEY (ID);
  
-- 数据权限表
CREATE TABLE T_XTFRAME_DATA_PERM
(
  ID        VARCHAR2(40) NOT NULL,
  BUSSKEY   VARCHAR2(40) NOT NULL,
  USER_ID   VARCHAR2(40),
  ROLE_CODE VARCHAR2(40),
  DATA_TYPE VARCHAR2(100),
  OPER      VARCHAR2(100),
  TEXT1     VARCHAR2(100),
  TEXT2     VARCHAR2(100),
  TEXT3     VARCHAR2(100),
  TEXT4     VARCHAR2(100),
  TEXT5     VARCHAR2(100)
);

COMMENT ON TABLE  T_XTFRAME_DATA_PERM  IS '数据权限表';
COMMENT ON COLUMN T_XTFRAME_DATA_PERM.ID  IS '唯一标识';
COMMENT ON COLUMN T_XTFRAME_DATA_PERM.BUSSKEY  IS '业务数据唯一标识';
COMMENT ON COLUMN T_XTFRAME_DATA_PERM.USER_ID  IS '权限用户';
COMMENT ON COLUMN T_XTFRAME_DATA_PERM.ROLE_CODE  IS '权限角色编码';
COMMENT ON COLUMN T_XTFRAME_DATA_PERM.DATA_TYPE  IS '记录状态';
COMMENT ON COLUMN T_XTFRAME_DATA_PERM.OPER  IS '操作权限';
COMMENT ON COLUMN T_XTFRAME_DATA_PERM.TEXT1  IS '字段1';
COMMENT ON COLUMN T_XTFRAME_DATA_PERM.TEXT2  IS '字段2';
COMMENT ON COLUMN T_XTFRAME_DATA_PERM.TEXT3  IS '字段3';
COMMENT ON COLUMN T_XTFRAME_DATA_PERM.TEXT4  IS '字段4';
COMMENT ON COLUMN T_XTFRAME_DATA_PERM.TEXT5  IS '字段5';

ALTER TABLE T_XTFRAME_DATA_PERM ADD PRIMARY KEY (ID);

-- 功能表
CREATE TABLE T_XTFRAME_FUNC
(
  ID     VARCHAR2(40) NOT NULL,
  NAME   VARCHAR2(100),
  CODE   VARCHAR2(40),
  MID    VARCHAR2(40),
  ICON   VARCHAR2(40),
  VALID  CHAR(1),
  SORTNO INTEGER
);

COMMENT ON TABLE  T_XTFRAME_FUNC  IS '功能表';
COMMENT ON COLUMN T_XTFRAME_FUNC.ID  IS '唯一标识';
COMMENT ON COLUMN T_XTFRAME_FUNC.NAME  IS '功能名称';
COMMENT ON COLUMN T_XTFRAME_FUNC.CODE  IS '功能编码';
COMMENT ON COLUMN T_XTFRAME_FUNC.MID  IS '所属菜单';
COMMENT ON COLUMN T_XTFRAME_FUNC.ICON  IS '显示图标';
COMMENT ON COLUMN T_XTFRAME_FUNC.VALID  IS '是否有效';
COMMENT ON COLUMN T_XTFRAME_FUNC.SORTNO  IS '排序号';

ALTER TABLE T_XTFRAME_FUNC  ADD PRIMARY KEY (ID);

--任务信息表
CREATE TABLE T_XTFRAME_JOBINFO
(
  ID              VARCHAR2(40) NOT NULL,
  DISP            VARCHAR2(100),
  CREATE_TIME     DATE DEFAULT CURRENT_TIMESTAMP,
  START_TIME      DATE,
  END_TIME        DATE,
  CIRCLE          CHAR(1),
  RESULT          VARCHAR2(100),
  INTERVAL        NUMBER,
  STATUS          VARCHAR2(100),
  PARAM           VARCHAR2(100),
  CLAZZ           VARCHAR2(100),
  CRON_EXPRESSION VARCHAR2(100)
);

COMMENT ON TABLE  T_XTFRAME_JOBINFO  IS '任务信息表';
COMMENT ON COLUMN T_XTFRAME_JOBINFO.ID  IS '唯一标识';
COMMENT ON COLUMN T_XTFRAME_JOBINFO.DISP  IS '任务描述';
COMMENT ON COLUMN T_XTFRAME_JOBINFO.CREATE_TIME  IS '任务创建时间';
COMMENT ON COLUMN T_XTFRAME_JOBINFO.START_TIME  IS '任务启动时间';
COMMENT ON COLUMN T_XTFRAME_JOBINFO.END_TIME  IS '任务结束时间';
COMMENT ON COLUMN T_XTFRAME_JOBINFO.CIRCLE  IS '是否循环';
COMMENT ON COLUMN T_XTFRAME_JOBINFO.RESULT  IS '上次执行结果';
COMMENT ON COLUMN T_XTFRAME_JOBINFO.INTERVAL  IS '间隔时间';
COMMENT ON COLUMN T_XTFRAME_JOBINFO.STATUS  IS '任务状态';
COMMENT ON COLUMN T_XTFRAME_JOBINFO.PARAM  IS '执行参数';

ALTER TABLE T_XTFRAME_JOBINFO  ADD PRIMARY KEY (ID);
 

-- 菜单表
CREATE TABLE T_XTFRAME_MENU
(
  ID       VARCHAR2(40) NOT NULL,
  PID      VARCHAR2(40),
  NAME     VARCHAR2(100),
  CODE     VARCHAR2(40),
  ICON     VARCHAR2(40),
  ICON2    VARCHAR2(40),
  URL      VARCHAR2(150),
  LEAF     CHAR(1),
  VALID    CHAR(1),
  OUT_LINK CHAR(1),
  SORTNO   INTEGER
);

COMMENT ON COLUMN T_XTFRAME_MENU.ID IS '唯一标识';
COMMENT ON COLUMN T_XTFRAME_MENU.PID IS '上级菜单';
COMMENT ON COLUMN T_XTFRAME_MENU.NAME IS '菜单名称';
COMMENT ON COLUMN T_XTFRAME_MENU.CODE IS '菜单编码';
COMMENT ON COLUMN T_XTFRAME_MENU.ICON IS '显示图标';
COMMENT ON COLUMN T_XTFRAME_MENU.ICON2 IS '显示图标2';
COMMENT ON COLUMN T_XTFRAME_MENU.URL IS '菜单路径';
COMMENT ON COLUMN T_XTFRAME_MENU.LEAF IS '是否末级菜单';
COMMENT ON COLUMN T_XTFRAME_MENU.VALID IS '是否有效';
COMMENT ON COLUMN T_XTFRAME_MENU.OUT_LINK IS '是否外部链接';
COMMENT ON COLUMN T_XTFRAME_MENU.SORTNO IS '排序号';
COMMENT ON TABLE  T_XTFRAME_MENU  IS '菜单表';

ALTER TABLE T_XTFRAME_MENU  ADD PRIMARY KEY (ID);


---- 组织表
CREATE TABLE T_XTFRAME_ORG
(
  ID     VARCHAR2(40) NOT NULL,
  PID    VARCHAR2(40),
  NAME   VARCHAR2(100),
  CODE   VARCHAR2(100),
  VALID  CHAR(1),
  SORTNO INTEGER,
  REMARK VARCHAR2(255)
);
  
COMMENT ON TABLE  T_XTFRAME_ORG  IS '组织表';
COMMENT ON COLUMN T_XTFRAME_ORG.ID  IS '唯一标识';
COMMENT ON COLUMN T_XTFRAME_ORG.PID  IS '上级组织ID';
COMMENT ON COLUMN T_XTFRAME_ORG.NAME  IS '名称';
COMMENT ON COLUMN T_XTFRAME_ORG.CODE  IS '编码';
COMMENT ON COLUMN T_XTFRAME_ORG.VALID  IS '是否有效';
COMMENT ON COLUMN T_XTFRAME_ORG.SORTNO  IS '排序号';

ALTER TABLE T_XTFRAME_ORG  ADD PRIMARY KEY (ID);


--组织功能授权表
CREATE TABLE T_XTFRAME_ORG_FUNC
(
  ORGID VARCHAR2(40) NOT NULL,
  FID   VARCHAR2(100) NOT NULL
);
COMMENT ON TABLE  T_XTFRAME_ORG_FUNC  IS '组织功能授权表';
COMMENT ON COLUMN T_XTFRAME_ORG_FUNC.ORGID  IS '组织ID';
COMMENT ON COLUMN T_XTFRAME_ORG_FUNC.FID  IS '功能ID';

ALTER TABLE T_XTFRAME_ORG_FUNC  ADD PRIMARY KEY (ORGID, FID);
  


-- 组织菜单授权表
CREATE TABLE T_XTFRAME_ORG_MENU
(
  ORGID VARCHAR2(40) NOT NULL,
  MID   VARCHAR2(100) NOT NULL
);

COMMENT ON TABLE  T_XTFRAME_ORG_MENU  IS ' 组织菜单授权表';
COMMENT ON COLUMN T_XTFRAME_ORG_MENU.ORGID  IS '组织ID';
COMMENT ON COLUMN T_XTFRAME_ORG_MENU.MID  IS '菜单ID';

ALTER TABLE T_XTFRAME_ORG_MENU  ADD PRIMARY KEY (ORGID, MID);
  
-- 角色表
CREATE TABLE T_XTFRAME_ROLE
(
  ID     VARCHAR2(40) NOT NULL,
  ORGID  VARCHAR2(40),
  NAME   VARCHAR2(100),
  CODE   VARCHAR2(100) NOT NULL,
  VALID  CHAR(1),
  SORTNO INTEGER
);

COMMENT ON TABLE  T_XTFRAME_ROLE  IS '角色表';
COMMENT ON COLUMN T_XTFRAME_ROLE.ID  IS '唯一标识';
COMMENT ON COLUMN T_XTFRAME_ROLE.ORGID  IS '所在组织ID';
COMMENT ON COLUMN T_XTFRAME_ROLE.NAME  IS '名称';
COMMENT ON COLUMN T_XTFRAME_ROLE.CODE  IS '编码';
COMMENT ON COLUMN T_XTFRAME_ROLE.VALID  IS '是否有效';
COMMENT ON COLUMN T_XTFRAME_ROLE.SORTNO  IS '排序号';

ALTER TABLE T_XTFRAME_ROLE  ADD PRIMARY KEY (ID);
  
-- 角色功能授权表
CREATE TABLE T_XTFRAME_ROLE_FUNC
(
  RID VARCHAR2(40) NOT NULL,
  FID VARCHAR2(100) NOT NULL
);

COMMENT ON TABLE T_XTFRAME_ROLE_FUNC  IS '角色功能授权表';
COMMENT ON COLUMN T_XTFRAME_ROLE_FUNC.RID  IS '角色ID';
COMMENT ON COLUMN T_XTFRAME_ROLE_FUNC.FID  IS '功能ID';

ALTER TABLE T_XTFRAME_ROLE_FUNC  ADD PRIMARY KEY (RID, FID);
  
-- 角色菜单授权表
CREATE TABLE T_XTFRAME_ROLE_MENU
(
  RID VARCHAR2(40) NOT NULL,
  MID VARCHAR2(100) NOT NULL
);

COMMENT ON COLUMN T_XTFRAME_ROLE_MENU.RID IS '角色ID';
COMMENT ON COLUMN T_XTFRAME_ROLE_MENU.MID IS '菜单ID';
COMMENT ON TABLE  T_XTFRAME_ROLE_MENU  IS ' 角色菜单授权表';

ALTER TABLE T_XTFRAME_ROLE_MENU  ADD PRIMARY KEY (RID,MID);


-- 角色用户关联表
CREATE TABLE T_XTFRAME_ROLE_USER
(
  RID    VARCHAR2(40) NOT NULL,
  USERID VARCHAR2(40) NOT NULL
);
  
COMMENT ON TABLE  T_XTFRAME_ROLE_USER  IS '角色用户关联表';
COMMENT ON COLUMN T_XTFRAME_ROLE_USER.RID  IS '角色ID';
COMMENT ON COLUMN T_XTFRAME_ROLE_USER.USERID  IS '用户ID';
ALTER TABLE T_XTFRAME_ROLE_USER  ADD PRIMARY KEY (RID, USERID);
  

-- 系统参数表
CREATE TABLE T_XTFRAME_SYS_PARAM
(
  ID    VARCHAR2(40) NOT NULL,
  KEY   VARCHAR2(100),
  VALUE VARCHAR2(100) NOT NULL,
  CLAZZ VARCHAR2(40),
  DISP  VARCHAR2(200),
  VALID CHAR(1)
);
  
COMMENT ON TABLE  T_XTFRAME_SYS_PARAM  IS '系统参数表';
COMMENT ON COLUMN T_XTFRAME_SYS_PARAM.ID  IS '唯一标识';
COMMENT ON COLUMN T_XTFRAME_SYS_PARAM.KEY  IS '参数主键';
COMMENT ON COLUMN T_XTFRAME_SYS_PARAM.VALUE  IS '参数值';
COMMENT ON COLUMN T_XTFRAME_SYS_PARAM.CLAZZ  IS '所属类';
COMMENT ON COLUMN T_XTFRAME_SYS_PARAM.DISP  IS '属性描述';
COMMENT ON COLUMN T_XTFRAME_SYS_PARAM.VALID  IS '是否有效';
ALTER TABLE T_XTFRAME_SYS_PARAM  ADD PRIMARY KEY (ID);
  

--用户表
CREATE TABLE T_XTFRAME_USER
(
  ID         VARCHAR2(40) NOT NULL,
  NAME       VARCHAR2(100),
  UNAME      VARCHAR2(100) NOT NULL,
  ORG        VARCHAR2(40),
  ORG_NAME   VARCHAR2(100),
  PASSWORD   VARCHAR2(100),
  CREATETIME TIMESTAMP(0) DEFAULT CURRENT_TIMESTAMP NOT NULL,
  VALID      CHAR(1),
  SORTNO     INTEGER,
  WEIXINID   VARCHAR2(100)
);
COMMENT ON TABLE  T_XTFRAME_USER  IS '用户表';
COMMENT ON COLUMN T_XTFRAME_USER.ID  IS '唯一标识';
COMMENT ON COLUMN T_XTFRAME_USER.NAME  IS '姓名';
COMMENT ON COLUMN T_XTFRAME_USER.UNAME  IS '登录账号';
COMMENT ON COLUMN T_XTFRAME_USER.ORG  IS '所在组织';
COMMENT ON COLUMN T_XTFRAME_USER.PASSWORD  IS '登录密码';
COMMENT ON COLUMN T_XTFRAME_USER.CREATETIME  IS '创建时间';
COMMENT ON COLUMN T_XTFRAME_USER.VALID  IS '是否有效';
COMMENT ON COLUMN T_XTFRAME_USER.SORTNO  IS '排序号';
COMMENT ON COLUMN T_XTFRAME_USER.WEIXINID  IS '微信ID';
ALTER TABLE T_XTFRAME_USER  ADD PRIMARY KEY (ID);


-- 用户功能授权表
CREATE TABLE T_XTFRAME_USER_FUNC
(
  USERID VARCHAR2(40) NOT NULL,
  FID    VARCHAR2(100) NOT NULL
);

COMMENT ON TABLE  T_XTFRAME_USER_FUNC  IS '用户功能授权表';
COMMENT ON COLUMN T_XTFRAME_USER_FUNC.USERID  IS '用户ID';
COMMENT ON COLUMN T_XTFRAME_USER_FUNC.FID  IS '功能ID';
ALTER TABLE T_XTFRAME_USER_FUNC ADD PRIMARY KEY (USERID, FID);
 

-- 用户菜单授权表
CREATE TABLE T_XTFRAME_USER_MENU
(
  USERID VARCHAR2(40) NOT NULL,
  MID    VARCHAR2(100) NOT NULL
);

COMMENT ON COLUMN T_XTFRAME_USER_MENU.USERID IS '用户ID';
COMMENT ON COLUMN T_XTFRAME_USER_MENU.MID IS '菜单ID';
COMMENT ON TABLE  T_XTFRAME_USER_MENU  IS ' 用户菜单授权表';
ALTER TABLE T_XTFRAME_USER_MENU  ADD PRIMARY KEY (USERID,MID);


-- 流程配置表
CREATE TABLE T_XTFRAME_WF_CONFIG
(
  ID           VARCHAR2(40) NOT NULL,
  PROCESS_KEY  VARCHAR2(40),
  PROCESS_NAME VARCHAR2(100),
  TASK_KEY     VARCHAR2(40),
  TASK_NAME    VARCHAR2(100),
  SFKTH        VARCHAR2(1),
  TYPE         VARCHAR2(1),
  BLGZ         VARCHAR2(1),
  VALID        CHAR(1),
  SORTNO       INTEGER,
  REMARK       VARCHAR2(100)
);

COMMENT ON TABLE  T_XTFRAME_WF_CONFIG  IS '流程配置表';
COMMENT ON COLUMN T_XTFRAME_WF_CONFIG.ID  IS '唯一标识';
COMMENT ON COLUMN T_XTFRAME_WF_CONFIG.PROCESS_KEY  IS '流程ID';
COMMENT ON COLUMN T_XTFRAME_WF_CONFIG.PROCESS_NAME  IS '流程名称';
COMMENT ON COLUMN T_XTFRAME_WF_CONFIG.TASK_KEY  IS '环节ID';
COMMENT ON COLUMN T_XTFRAME_WF_CONFIG.TASK_NAME  IS '环节名称';
COMMENT ON COLUMN T_XTFRAME_WF_CONFIG.SFKTH  IS '是否可退回';
COMMENT ON COLUMN T_XTFRAME_WF_CONFIG.TYPE  IS '节点类型（0：结束，1：开始）';
COMMENT ON COLUMN T_XTFRAME_WF_CONFIG.BLGZ  IS '办理规则(1：一人完成后提交，2：全部完成后提交)';
COMMENT ON COLUMN T_XTFRAME_WF_CONFIG.VALID  IS '是否有效';
COMMENT ON COLUMN T_XTFRAME_WF_CONFIG.SORTNO  IS '排序号';
ALTER TABLE T_XTFRAME_WF_CONFIG  ADD PRIMARY KEY (ID);
  

-- 流程处理人配置表
CREATE TABLE T_XTFRAME_WF_CONFIG_CLR
(
  ID          VARCHAR2(40) NOT NULL,
  PROCESS_KEY VARCHAR2(40),
  TASK_KEY    VARCHAR2(40),
  TYPE        VARCHAR2(40),
  CLRID       VARCHAR2(40),
  CLRMC       VARCHAR2(40),
  VALID       CHAR(1),
  SORTNO      INTEGER
);

COMMENT ON TABLE  T_XTFRAME_WF_CONFIG_CLR  IS '流程处理人配置表';
COMMENT ON COLUMN T_XTFRAME_WF_CONFIG_CLR.ID  IS '唯一标识';
COMMENT ON COLUMN T_XTFRAME_WF_CONFIG_CLR.PROCESS_KEY  IS '流程KEY';
COMMENT ON COLUMN T_XTFRAME_WF_CONFIG_CLR.TASK_KEY  IS '环节KEY';
COMMENT ON COLUMN T_XTFRAME_WF_CONFIG_CLR.TYPE  IS '处理人类型（1：组织，2：角色，3：用户）';
COMMENT ON COLUMN T_XTFRAME_WF_CONFIG_CLR.CLRID  IS '处理人ID（组织ID，角色ID，用户ID）';
COMMENT ON COLUMN T_XTFRAME_WF_CONFIG_CLR.CLRMC  IS '处理人名称（组织名称，角色名称，用户名称）';
COMMENT ON COLUMN T_XTFRAME_WF_CONFIG_CLR.VALID  IS '是否有效';
COMMENT ON COLUMN T_XTFRAME_WF_CONFIG_CLR.SORTNO  IS '排序号';
ALTER TABLE T_XTFRAME_WF_CONFIG_CLR  ADD PRIMARY KEY (ID);
  

-- 流程环节配置表
CREATE TABLE T_XTFRAME_WF_CONFIG_STEP
(
  ID             VARCHAR2(40) NOT NULL,
  PROCESS_KEY    VARCHAR2(40),
  TASK_KEY       VARCHAR2(40),
  NEXT_TASK_KEY  VARCHAR2(40),
  NEXT_TASK_NAME VARCHAR2(100),
  SFMR           VARCHAR2(1),
  VALID          CHAR(1),
  SORTNO         INTEGER
);

COMMENT ON TABLE  T_XTFRAME_WF_CONFIG_STEP  IS '流程环节配置表';
COMMENT ON COLUMN T_XTFRAME_WF_CONFIG_STEP.ID  IS '唯一标识';
COMMENT ON COLUMN T_XTFRAME_WF_CONFIG_STEP.PROCESS_KEY  IS '流程KEY';
COMMENT ON COLUMN T_XTFRAME_WF_CONFIG_STEP.TASK_KEY  IS '环节KEY';
COMMENT ON COLUMN T_XTFRAME_WF_CONFIG_STEP.NEXT_TASK_KEY  IS '下一环节KEY';
COMMENT ON COLUMN T_XTFRAME_WF_CONFIG_STEP.NEXT_TASK_NAME  IS '下一环节名称';
COMMENT ON COLUMN T_XTFRAME_WF_CONFIG_STEP.SFMR  IS '是否默认';
COMMENT ON COLUMN T_XTFRAME_WF_CONFIG_STEP.VALID  IS '是否有效';
COMMENT ON COLUMN T_XTFRAME_WF_CONFIG_STEP.SORTNO  IS '排序号';
ALTER TABLE T_XTFRAME_WF_CONFIG_STEP  ADD PRIMARY KEY (ID);

