// Copyright (c) 1998 by W3C
//
// DOM is a trademark of W3C
// The DOM level 1 specification, from which this
// source is derived, is copyright by W3C.
// See: http://www.w3.org/TR/REC-DOM-Level-1/
//

package org.w3c.dom.html;

import org.w3c.dom.*;

/**

  <P>The HTML document body. This element is always present in the DOM API, even if the tags are not present in the source document. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/global.html#edef-BODY">BODY element definition</A>
 in HTML 4.0.
  
</P>

<HR>

<!-- ======== PROPERTY SUMMARY ======== -->

<A NAME="property_summary"><!-- --></A>
<TABLE BORDER=1 CELLPADDING=3 CELLSPACING=0 WIDTH=100%>
<TR BGCOLOR=#CCCCFF ID=TableHeadingColor>
<TD COLSPAN=3><FONT SIZE=+2><B>Property Summary</B>
</FONT></TD></TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-aLink><CODE>&nbsp;aLink</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getALink()'>getALink</a>
<a href='#setALink(java.lang.String)'>setALink</a>
</TD>
<TD>
  <P>Color of active links (after mouse-button down, but before mouse-button up). See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/global.html#adef-alink">alink attribute definition</A>
 in HTML 4.0. This attribute is deprecated in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-background><CODE>&nbsp;background</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getBackground()'>getBackground</a>
<a href='#setBackground(java.lang.String)'>setBackground</a>
</TD>
<TD>
  <P>URI of the background texture tile image. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/global.html#adef-background">background attribute definition</A>
 in HTML 4.0. This attribute is deprecated in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-bgColor><CODE>&nbsp;bgColor</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getBgColor()'>getBgColor</a>
<a href='#setBgColor(java.lang.String)'>setBgColor</a>
</TD>
<TD>
  <P>Document background color. See the 
    <A  href="http://www.w3.org/TR/REC-html40/present/graphics.html#adef-bgcolor">bgcolor attribute definition</A>
 in HTML 4.0. This attribute is deprecated in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-link><CODE>&nbsp;link</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getLink()'>getLink</a>
<a href='#setLink(java.lang.String)'>setLink</a>
</TD>
<TD>
  <P>Color of links that are not active and unvisited. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/global.html#adef-link">link attribute definition</A>
 in HTML 4.0. This attribute is deprecated in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-text><CODE>&nbsp;text</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getText()'>getText</a>
<a href='#setText(java.lang.String)'>setText</a>
</TD>
<TD>
  <P>Document text color. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/global.html#adef-text">text attribute definition</A>
 in HTML 4.0. This attribute is deprecated in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-vLink><CODE>&nbsp;vLink</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getVLink()'>getVLink</a>
<a href='#setVLink(java.lang.String)'>setVLink</a>
</TD>
<TD>
  <P>Color of links that have been visited by the user. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/global.html#adef-vlink">vlink attribute definition</A>
 in HTML 4.0. This attribute is deprecated in HTML 4.0.
  
</P>
</TD>
</TR>
</TABLE>
&nbsp;
*/
public interface HTMLBodyElement
extends HTMLElement
{
	/** Assigns the value of the <code><a href=#att-aLink>aLink</a></code> property.
	 */
	void setALink (String aLink);

	/**
	 * Returns the value of the <code><a href=#att-aLink>aLink</a></code> property.
	*/
	String getALink ();


	/** Assigns the value of the <code><a href=#att-background>background</a></code> property.
	 */
	void setBackground (String background);

	/**
	 * Returns the value of the <code><a href=#att-background>background</a></code> property.
	*/
	String getBackground ();


	/** Assigns the value of the <code><a href=#att-bgColor>bgColor</a></code> property.
	 */
	void setBgColor (String bgColor);

	/**
	 * Returns the value of the <code><a href=#att-bgColor>bgColor</a></code> property.
	*/
	String getBgColor ();


	/** Assigns the value of the <code><a href=#att-link>link</a></code> property.
	 */
	void setLink (String link);

	/**
	 * Returns the value of the <code><a href=#att-link>link</a></code> property.
	*/
	String getLink ();


	/** Assigns the value of the <code><a href=#att-text>text</a></code> property.
	 */
	void setText (String text);

	/**
	 * Returns the value of the <code><a href=#att-text>text</a></code> property.
	*/
	String getText ();


	/** Assigns the value of the <code><a href=#att-vLink>vLink</a></code> property.
	 */
	void setVLink (String vLink);

	/**
	 * Returns the value of the <code><a href=#att-vLink>vLink</a></code> property.
	*/
	String getVLink ();


}
