/*
 * @(#)ExternSheet.java	1.4 98/11/18
 * 
 * Copyright (c) 1998 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 */


package com.sun.xml.xsl;

import java.net.URL;

import org.w3c.dom.Attr;

import com.sun.xml.tree.ParseContext;
import com.sun.xml.tree.ElementNode;


/**
 * This class represents style sheets that get imported or included
 * from an external source.
 */
final class ExternSheet extends ElementNode
{
    /**
     * Does relative URL interpretation for the "href" attribute
     */
    public void startParse (ParseContext context)
    {
	Attr	href = getAttributeNode (StyleSheet.uri, "href");

	if (href == null)
	    throw new IllegalArgumentException ("no href attribute");
	try {
	    String baseURI = context.getLocator ().getSystemId ();
	    String ref = href.getValue ();

	    ref = new URL (new URL (baseURI), ref).toString ();
	    href.setValue (ref);
	} catch (Exception e) {
	    // ignore
	}
    }
}
