/*
 * Decompiled with CFR 0.152.
 */
package com.xtframe.web.support;

import com.xtframe.core.job.service.JobInfoService;
import com.xtframe.web.support.XtWebConfiguration;
import com.xtframe.web.support.XtWebContext;
import org.quartz.Scheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class XtWebContextFactoryBean
implements FactoryBean<XtWebContext>,
DisposableBean,
ApplicationContextAware {
    private static Logger log = LoggerFactory.getLogger(XtWebContextFactoryBean.class);
    private XtWebConfiguration webConfiguration;
    private XtWebContext webContext;
    protected ApplicationContext applicationContext;
    private Scheduler scheduler;
    private JobInfoService jobService;

    public void destroy() throws Exception {
        log.info("XtWebContextFactoryBean destroy");
    }

    public XtWebContext getObject() throws Exception {
        this.webContext = this.webConfiguration.buildFrameContext(this.applicationContext);
        if (this.scheduler != null) {
            this.jobService = this.webContext.getSecurityContext().getJobService();
            if (this.jobService != null) {
                this.initJob();
            }
        }
        return this.webContext;
    }

    private void initJob() {
        this.jobService.initJobs((Object)this.scheduler);
    }

    public Class<?> getObjectType() {
        return XtWebContext.class;
    }

    public XtWebConfiguration getWebConfiguration() {
        return this.webConfiguration;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public void setWebConfiguration(XtWebConfiguration webConfiguration) {
        this.webConfiguration = webConfiguration;
    }
}

