/*
 * Decompiled with CFR 0.152.
 */
package com.xtframe.web.authz;

import com.xtframe.core.anon.auth.Logical;
import com.xtframe.core.anon.auth.RequiresPermissions;
import com.xtframe.core.utils.SystemParam;
import com.xtframe.sec.utils.SecUtils;
import java.lang.annotation.Annotation;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.authz.aop.AuthorizingAnnotationHandler;
import org.apache.shiro.subject.Subject;

public class PermissionAnnotationHandler
extends AuthorizingAnnotationHandler {
    public PermissionAnnotationHandler() {
        super(RequiresPermissions.class);
    }

    protected String[] getAnnotationValue(Annotation a) {
        RequiresPermissions rpAnnotation = (RequiresPermissions)a;
        String[] param = rpAnnotation.value();
        if (param != null && param.length > 0) {
            int i = 0;
            while (i < param.length) {
                param[i] = String.valueOf(SystemParam.getAppName()) + ":" + param[i];
                ++i;
            }
        }
        return param;
    }

    public void assertAuthorized(Annotation a) throws AuthorizationException {
        if (!(a instanceof RequiresPermissions)) {
            return;
        }
        RequiresPermissions rpAnnotation = (RequiresPermissions)a;
        String[] perms = this.getAnnotationValue(a);
        Subject subject = this.getSubject();
        if (SecUtils.isSuperUser()) {
            return;
        }
        if (perms.length == 1) {
            subject.checkPermission(perms[0]);
            return;
        }
        if (Logical.AND.equals((Object)rpAnnotation.logical())) {
            this.getSubject().checkPermissions(perms);
            return;
        }
        if (Logical.OR.equals((Object)rpAnnotation.logical())) {
            boolean hasAtLeastOnePermission = false;
            String[] stringArray = perms;
            int n = perms.length;
            int n2 = 0;
            while (n2 < n) {
                String permission = stringArray[n2];
                if (this.getSubject().isPermitted(permission)) {
                    hasAtLeastOnePermission = true;
                }
                ++n2;
            }
            if (!hasAtLeastOnePermission) {
                this.getSubject().checkPermission(perms[0]);
            }
        }
    }
}

