/*
 * Decompiled with CFR 0.152.
 */
package com.xtframe.web.authz;

import com.xtframe.core.anon.auth.RequiresAuthentication;
import com.xtframe.core.anon.auth.RequiresGuest;
import com.xtframe.core.anon.auth.RequiresPermissions;
import com.xtframe.core.anon.auth.RequiresRoles;
import com.xtframe.core.anon.auth.RequiresUser;
import com.xtframe.web.authz.AopAllianceAnnotationsAuthorizingMethodInterceptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.aopalliance.aop.Advice;
import org.apache.shiro.mgt.SecurityManager;
import org.springframework.aop.support.StaticMethodMatcherPointcutAdvisor;
import org.springframework.core.annotation.AnnotationUtils;

public class AuthorizationAttributeSourceAdvisor
extends StaticMethodMatcherPointcutAdvisor {
    private static final long serialVersionUID = 1633068683192490735L;
    private static final Class<? extends Annotation>[] AUTHZ_ANNOTATION_CLASSES = new Class[]{RequiresPermissions.class, RequiresRoles.class, RequiresUser.class, RequiresGuest.class, RequiresAuthentication.class};
    protected SecurityManager securityManager = null;

    public AuthorizationAttributeSourceAdvisor() {
        this.setAdvice((Advice)new AopAllianceAnnotationsAuthorizingMethodInterceptor());
    }

    public SecurityManager getSecurityManager() {
        return this.securityManager;
    }

    public void setSecurityManager(SecurityManager securityManager) {
        this.securityManager = securityManager;
    }

    public boolean matches(Method method, Class<?> targetClass) {
        Method m = method;
        if (this.isAuthzAnnotationPresent(m)) {
            return true;
        }
        if (targetClass != null) {
            try {
                m = targetClass.getMethod(m.getName(), m.getParameterTypes());
                if (this.isAuthzAnnotationPresent(m)) {
                    return true;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return false;
    }

    private boolean isAuthzAnnotationPresent(Method method) {
        Class<? extends Annotation>[] classArray = AUTHZ_ANNOTATION_CLASSES;
        int n = AUTHZ_ANNOTATION_CLASSES.length;
        int n2 = 0;
        while (n2 < n) {
            Class<? extends Annotation> annClass = classArray[n2];
            Annotation a = AnnotationUtils.findAnnotation((Method)method, annClass);
            if (a != null) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

