/*
 * Decompiled with CFR 0.152.
 */
package com.xtframe.wf.support;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.impl.RepositoryServiceImpl;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.repository.ProcessDefinition;

public class ProcessDefinitionCache {
    private static Map<String, ProcessDefinition> map = new HashMap<String, ProcessDefinition>();
    private static Map<String, List<ActivityImpl>> activities = new HashMap<String, List<ActivityImpl>>();
    private static Map<String, ActivityImpl> singleActivity = new HashMap<String, ActivityImpl>();
    private static RepositoryService repositoryService;

    public static ProcessDefinition get(String processDefinitionId) {
        ProcessDefinition processDefinition = map.get(processDefinitionId);
        if (processDefinition == null && (processDefinition = (ProcessDefinitionEntity)((RepositoryServiceImpl)repositoryService).getDeployedProcessDefinition(processDefinitionId)) != null) {
            ProcessDefinitionCache.put(processDefinitionId, processDefinition);
        }
        return processDefinition;
    }

    public static void put(String processDefinitionId, ProcessDefinition processDefinition) {
        map.put(processDefinitionId, processDefinition);
        ProcessDefinitionEntity pde = (ProcessDefinitionEntity)processDefinition;
        activities.put(processDefinitionId, pde.getActivities());
        for (ActivityImpl activityImpl : pde.getActivities()) {
            singleActivity.put(String.valueOf(processDefinitionId) + "_" + activityImpl.getId(), activityImpl);
        }
    }

    public static ActivityImpl getActivity(String processDefinitionId, String activityId) {
        ActivityImpl activityImpl;
        ProcessDefinition processDefinition = ProcessDefinitionCache.get(processDefinitionId);
        if (processDefinition != null && (activityImpl = singleActivity.get(String.valueOf(processDefinitionId) + "_" + activityId)) != null) {
            return activityImpl;
        }
        return null;
    }

    public static String getActivityName(String processDefinitionId, String activityId) {
        ActivityImpl activity = ProcessDefinitionCache.getActivity(processDefinitionId, activityId);
        if (activity != null) {
            return Objects.toString(activity.getProperty("name"));
        }
        return null;
    }

    public static void setRepositoryService(RepositoryService repositoryService) {
        ProcessDefinitionCache.repositoryService = repositoryService;
    }
}

