/*
 * Decompiled with CFR 0.152.
 */
package com.xtframe.util;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.logging.Logger;

public class DateTime {
    private static final Logger LOG = Logger.getLogger(DateTime.class.getName());
    public static final long DAY_MILLI = 86400000L;
    public static final long HOUR_MILLI = 3600000L;
    public static String DATE_FORMAT_DATEONLY = "yyyy-MM-dd";
    public static String DATE_FORMAT_DATETIME = "yyyy-MM-dd HH:mm:ss";
    public static int[] DAY_OF_MONTH_LEAP_YEAR = new int[]{31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    public static int[] DAY_OF_MONTH_NON_LEAP_YEAR = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static SimpleDateFormat sdfDateOnly = new SimpleDateFormat(DATE_FORMAT_DATEONLY);
    private static SimpleDateFormat sdfDateTime = new SimpleDateFormat(DATE_FORMAT_DATETIME);
    private static SimpleDateFormat sdfDateTimeFull = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");

    public static Date toDate(String sDate) {
        return DateTime.toDate(sDate, sdfDateOnly);
    }

    public static Date toDate(String sDate, String sFmt) {
        if (sFmt.equals(DATE_FORMAT_DATETIME)) {
            return DateTime.toDate(sDate, sdfDateTime);
        }
        if (sFmt.equals(DATE_FORMAT_DATEONLY)) {
            return DateTime.toDate(sDate, sdfDateOnly);
        }
        return DateTime.toDateAgain(sDate);
    }

    private static Date toDate(String sDate, SimpleDateFormat formatter) {
        if (sDate == null) {
            return null;
        }
        Date dt = null;
        try {
            dt = formatter.parse(sDate);
        }
        catch (Exception e) {
            dt = DateTime.toDateAgain(sDate);
        }
        return dt;
    }

    private static Date toDateAgain(String sDate) {
        if (sDate == null) {
            return null;
        }
        Date dt = null;
        SimpleDateFormat formatter = null;
        if (sDate.length() < DATE_FORMAT_DATEONLY.length()) {
            return null;
        }
        if (sDate.length() < DATE_FORMAT_DATETIME.length()) {
            formatter = new SimpleDateFormat(DATE_FORMAT_DATETIME.substring(0, sDate.length()));
        } else if (sDate.length() > DATE_FORMAT_DATETIME.length()) {
            sDate = sDate.substring(0, DATE_FORMAT_DATETIME.length());
            formatter = sdfDateTime;
        }
        try {
            dt = formatter.parse(sDate);
        }
        catch (Exception e) {
            LOG.warning("Exception when parsing date in DateTime.toDateAgain(), original String=" + sDate + ",formatter pattern=" + formatter.toPattern());
            dt = null;
        }
        return dt;
    }

    public static String toString(long millis) {
        return DateTime.toString(new Date(millis), sdfDateTime);
    }

    public static String toStringFull(long millis) {
        return DateTime.toString(new Date(millis), sdfDateTimeFull);
    }

    public static String toString(Date dt) {
        return DateTime.toString(dt, sdfDateOnly);
    }

    public static String toString(Date dt, String sFmt) {
        if (dt == null) {
            return "";
        }
        if (sFmt.equals(DATE_FORMAT_DATETIME)) {
            return DateTime.toString(dt, sdfDateTime);
        }
        if (sFmt.equals(DATE_FORMAT_DATEONLY)) {
            return DateTime.toString(dt, sdfDateOnly);
        }
        LOG.severe("Unknown date format in DateTime.toString, dateFormat = " + sFmt);
        return dt.toString();
    }

    private static String toString(Date dt, SimpleDateFormat formatter) {
        if (dt == null || formatter == null) {
            return "";
        }
        String sRet = null;
        try {
            sRet = formatter.format(dt);
        }
        catch (Exception e) {
            LOG.severe("Exception in DateTime.toString");
            sRet = dt.toString();
        }
        return sRet;
    }

    public static Date addDays(Date date, int days) {
        long temp = date.getTime();
        return new Date(temp + 86400000L * (long)days);
    }

    private static GregorianCalendar convertToCalendar(Date date) {
        GregorianCalendar obj = new GregorianCalendar();
        obj.setTime(date);
        return obj;
    }

    public static String addDays(String date, int days) {
        try {
            return DateTime.toString(DateTime.addDays(DateTime.toDate(date), days));
        }
        catch (Exception e) {
            LOG.severe("Exception in addDays,date=" + date + ",days add=" + days);
            return "";
        }
    }

    public static String addMonths(String paraDate, int mon) {
        Date date = DateTime.toDate(paraDate);
        if (date == null) {
            return "";
        }
        GregorianCalendar obj = DateTime.convertToCalendar(date);
        int year = obj.get(1);
        int month = obj.get(2) + 1;
        int day = obj.get(5);
        if ((month += mon) < 1) {
            month += 12;
            --year;
        } else if (month > 12) {
            month -= 12;
            ++year;
        }
        int lastDay = 0;
        boolean laterThanLastMonth = false;
        if (obj.isLeapYear(year)) {
            laterThanLastMonth = day > DAY_OF_MONTH_LEAP_YEAR[month - 1];
        } else {
            boolean bl = laterThanLastMonth = day > DAY_OF_MONTH_NON_LEAP_YEAR[month - 1];
        }
        if ((DateTime.isLastDayOfMonth(obj) || laterThanLastMonth) && (lastDay = obj.isLeapYear(year) ? DAY_OF_MONTH_LEAP_YEAR[month - 1] : DAY_OF_MONTH_NON_LEAP_YEAR[month - 1]) < day) {
            day = lastDay;
        }
        obj.set(year, month - 1, day);
        Date resultDate = new Date(obj.getTimeInMillis());
        return DateTime.toString(resultDate);
    }

    public static boolean isSameDay(Timestamp date1, Timestamp date2) {
        String s2 = null;
        String s1 = date1.toString().substring(0, DATE_FORMAT_DATEONLY.length());
        s2 = date2.toString().substring(0, DATE_FORMAT_DATEONLY.length());
        return s1.equalsIgnoreCase(s2);
    }

    public static Timestamp getFirstDayOfWeek(Timestamp timestamp) {
        int no = DateTime.getWeekdayOfTimestamp(timestamp);
        Timestamp out = DateTime.addDays(timestamp, 1 - no);
        return out;
    }

    public static Timestamp getLastDayOfWeek(Timestamp timestamp) {
        int no = DateTime.getWeekdayOfTimestamp(timestamp);
        Timestamp out = DateTime.addDays(timestamp, 7 - no);
        return out;
    }

    public static Timestamp getFirstSundayOfMonth(Timestamp timestamp) {
        Timestamp out = null;
        if (timestamp == null) {
            return null;
        }
        out = DateTime.getFirstDayOfMonth(timestamp);
        out = DateTime.getFirstDayOfWeek(out);
        return out;
    }

    public static Timestamp getLastSaturdayOfMonth(Timestamp timestamp) {
        Timestamp out = null;
        if (timestamp == null) {
            return null;
        }
        out = DateTime.getLastDayOfMonth(timestamp);
        out = DateTime.getLastDayOfWeek(out);
        return out;
    }

    public static Timestamp getFirstDayOfMonth(Timestamp timestamp) {
        Timestamp out = null;
        if (timestamp == null) {
            return null;
        }
        int day = DateTime.getDayOfTimestamp(timestamp);
        out = DateTime.addDays(timestamp, 1 - day);
        return out;
    }

    public static long daysBetween(Timestamp t1, Timestamp t2) {
        return (t2.getTime() - t1.getTime()) / 86400000L;
    }

    private static String formatYMD(int year, int month, int day) {
        String temp = String.valueOf(year) + "/";
        temp = month < 10 ? temp + "0" + String.valueOf(month) + "/" : temp + String.valueOf(month) + "/";
        temp = day < 10 ? temp + "0" + String.valueOf(day) : temp + String.valueOf(day);
        return temp;
    }

    public static Timestamp getLastDayOfMonth(Timestamp timestamp) {
        Timestamp out = null;
        if (timestamp == null) {
            return null;
        }
        GregorianCalendar obj = DateTime.convertToCalendar(timestamp);
        int day = 0;
        int year = obj.get(1);
        int month = obj.get(2) + 1;
        day = obj.isLeapYear(obj.get(1)) ? DAY_OF_MONTH_LEAP_YEAR[month - 1] : DAY_OF_MONTH_NON_LEAP_YEAR[month - 1];
        out = DateTime.toSqlTimestamp(DateTime.formatYMD(year, month, day));
        return out;
    }

    public static int getYearOfTimestamp(Timestamp timestamp) {
        GregorianCalendar obj = DateTime.convertToCalendar(timestamp);
        return obj.get(1);
    }

    public static int getMonthOfTimestamp(Timestamp timestamp) {
        GregorianCalendar obj = DateTime.convertToCalendar(timestamp);
        return obj.get(2) + 1;
    }

    public static int getDayOfTimestamp(Timestamp timestamp) {
        GregorianCalendar obj = DateTime.convertToCalendar(timestamp);
        return obj.get(5);
    }

    public static int getWeekdayOfTimestamp(Timestamp timestamp) {
        GregorianCalendar obj = DateTime.convertToCalendar(timestamp);
        return obj.get(7);
    }

    public static Timestamp getZeroTime(Timestamp timestamp) {
        if (timestamp == null) {
            return null;
        }
        return DateTime.toSqlTimestamp(DateTime.toString(new Date(timestamp.getTime())));
    }

    public static String getHourAndMinuteString(Timestamp timestamp) {
        String out = null;
        GregorianCalendar obj = DateTime.convertToCalendar(timestamp);
        int hour = obj.get(11);
        int minute = obj.get(12);
        out = minute < 10 ? String.valueOf(hour) + ":0" + String.valueOf(minute) : String.valueOf(hour) + ":" + String.valueOf(minute);
        return out;
    }

    public static int getHourOfTimestamp(Timestamp timestamp) {
        GregorianCalendar obj = DateTime.convertToCalendar(timestamp);
        return obj.get(11);
    }

    public static int getMinuteOfTimestamp(Timestamp timestamp) {
        GregorianCalendar obj = DateTime.convertToCalendar(timestamp);
        return obj.get(12);
    }

    public static int getSecondOfTimestamp(Timestamp timestamp) {
        GregorianCalendar obj = DateTime.convertToCalendar(timestamp);
        return obj.get(13);
    }

    public static GregorianCalendar convertToCalendar(Timestamp timestamp) {
        GregorianCalendar obj = new GregorianCalendar();
        obj.setTime(DateTime.convertTimestampToDate(timestamp));
        return obj;
    }

    public static Date convertTimestampToDate(Timestamp timestamp) {
        Date date = null;
        date = new Date(timestamp.getTime());
        return date;
    }

    public static long getSysDateLong() {
        return System.currentTimeMillis();
    }

    public static Timestamp getSysDateTimestamp() {
        return new Timestamp(System.currentTimeMillis());
    }

    public static String getSysDateString() {
        return DateTime.toString(new Date(System.currentTimeMillis()), sdfDateOnly);
    }

    public static String getSysDateTimeString() {
        return DateTime.toString(new Date(System.currentTimeMillis()), sdfDateTime);
    }

    public static String getSysDateFullString() {
        return DateTime.toStringFull(System.currentTimeMillis());
    }

    public static java.sql.Date toSqlDate(String sDate) {
        return new java.sql.Date(DateTime.toDate(sDate).getTime());
    }

    public static String toSqlDateString(java.sql.Date dt) {
        return DateTime.toString(new Date(dt.getTime()));
    }

    public static Timestamp toSqlTimestamp(String sDate) {
        if (sDate == null) {
            return null;
        }
        return DateTime.toSqlTimestamp(sDate, DATE_FORMAT_DATEONLY);
    }

    public static Timestamp toSqlTimestamp(String sDate, String sFmt) {
        Date date = DateTime.toDate(sDate, sFmt);
        if (date != null) {
            return new Timestamp(date.getTime());
        }
        return null;
    }

    public static String toSqlTimestampString(Timestamp dt) {
        return DateTime.toSqlTimestampString(dt, DATE_FORMAT_DATEONLY);
    }

    public static String toSqlTimestampString2(Timestamp dt) {
        if (dt == null) {
            return null;
        }
        String temp = DateTime.toSqlTimestampString(dt, DATE_FORMAT_DATETIME);
        return temp.substring(0, 16 < DATE_FORMAT_DATETIME.length() ? 16 : DATE_FORMAT_DATETIME.length());
    }

    public static String toString(Timestamp dt) {
        return dt == null ? "" : DateTime.toSqlTimestampString2(dt);
    }

    public static String convertTimestampToChinaCalendar(Timestamp timestamp) {
        StringBuffer sb = new StringBuffer();
        if (timestamp == null) {
            sb.append("&nbsp");
        } else {
            sb = new StringBuffer();
            sb.append(DateTime.getYearOfTimestamp(timestamp));
            sb.append("\u5e74");
            sb.append(DateTime.getMonthOfTimestamp(timestamp));
            sb.append("\u6708");
            sb.append(DateTime.getDayOfTimestamp(timestamp));
            sb.append("\u65e5");
            sb.append("\u3000");
            sb.append(DateTime.getHourOfTimestamp(timestamp));
            sb.append(":");
            if (DateTime.getMinuteOfTimestamp(timestamp) < 10) {
                sb.append(0);
                sb.append(DateTime.getMinuteOfTimestamp(timestamp));
            } else {
                sb.append(DateTime.getMinuteOfTimestamp(timestamp));
            }
            sb.append(":");
            if (DateTime.getSecondOfTimestamp(timestamp) < 10) {
                sb.append(0);
                sb.append(DateTime.getSecondOfTimestamp(timestamp));
            } else {
                sb.append(DateTime.getSecondOfTimestamp(timestamp));
            }
        }
        return sb.toString();
    }

    public static String toSqlTimestampString(Timestamp dt, String sFmt) {
        if (dt == null) {
            return null;
        }
        return DateTime.toString(new Date(dt.getTime()), sFmt);
    }

    public static String toHourMinString(Timestamp dt) {
        String temp = null;
        temp = dt.toString();
        temp = temp.substring(11, 16);
        return temp;
    }

    private static boolean isLastDayOfMonth(GregorianCalendar obj) {
        int year = obj.get(1);
        int month = obj.get(2) + 1;
        int day = obj.get(5);
        return obj.isLeapYear(year) ? day >= DAY_OF_MONTH_LEAP_YEAR[month - 1] : day >= DAY_OF_MONTH_NON_LEAP_YEAR[month - 1];
    }

    public static Timestamp addMonths(Timestamp timestamp, int mon) {
        Timestamp out = null;
        GregorianCalendar obj = DateTime.convertToCalendar(timestamp);
        int year = obj.get(1);
        int month = obj.get(2) + 1;
        int day = obj.get(5);
        if ((month += mon) < 1) {
            month += 12;
            --year;
        } else if (month > 12) {
            month -= 12;
            ++year;
        }
        boolean laterThanLastMonth = false;
        if (obj.isLeapYear(year)) {
            laterThanLastMonth = day > DAY_OF_MONTH_LEAP_YEAR[month - 1];
        } else {
            boolean bl = laterThanLastMonth = day > DAY_OF_MONTH_NON_LEAP_YEAR[month - 1];
        }
        if (DateTime.isLastDayOfMonth(obj) || laterThanLastMonth) {
            day = obj.isLeapYear(year) ? DAY_OF_MONTH_LEAP_YEAR[month - 1] : DAY_OF_MONTH_NON_LEAP_YEAR[month - 1];
        }
        String temp = DateTime.formatYMD(year, month, day);
        temp = temp + " " + DateTime.toHourMinString(timestamp) + ":00";
        out = DateTime.toSqlTimestamp(temp, DATE_FORMAT_DATETIME);
        return out;
    }

    public static Timestamp addDays(Timestamp timestamp, int days) {
        Date date = DateTime.convertTimestampToDate(timestamp);
        long temp = date.getTime();
        return new Timestamp(temp + 86400000L * (long)days);
    }

    public static synchronized String getDateString() {
        return DateTime.toString(new Date(System.currentTimeMillis()));
    }

    public static synchronized String getDateString(Calendar now) {
        return DateTime.toString(new Date(now.getTimeInMillis()), DATE_FORMAT_DATETIME);
    }

    public static synchronized String getDateTimeForDB() {
        return DateTime.getDateTimeForDB(new Date());
    }

    public static synchronized String getDateTimeForDB(int year, int month, int day, int hour, int min, int sec) {
        GregorianCalendar cal = new GregorianCalendar(year, month, day, hour, min, sec);
        return DateTime.getDateTimeForDB(cal.getTime()).trim();
    }

    public static synchronized String getDateTimeForDB(Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss ");
        Date currentTime_1 = date;
        String dateString = formatter.format(currentTime_1);
        return dateString.trim();
    }

    public static synchronized String getDateTimeString() {
        SimpleDateFormat formatter = new SimpleDateFormat("E',' MMM d yyyy 'at' hh:mm:ss a");
        Date currentTime_1 = new Date();
        String dateString = formatter.format(currentTime_1);
        return dateString.trim();
    }

    public static synchronized String getDateTimeString(Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat("E',' MMM d yyyy 'at' hh:mm:ss a");
        String dateString = formatter.format(date);
        return dateString.trim();
    }

    public static synchronized String getMinDateTime(String sFmt) {
        GregorianCalendar cal = new GregorianCalendar(1, 0, 1, 0, 0, 0);
        Date dt = cal.getTime();
        return DateTime.toString(dt, sFmt);
    }

    public static synchronized String getMaxDateTime(String sFmt) {
        GregorianCalendar cal = new GregorianCalendar(9999, 11, 31, 23, 59, 59);
        Date dt = cal.getTime();
        return DateTime.toString(dt, sFmt);
    }
}

