/*
 * Decompiled with CFR 0.152.
 */
package org.wltea.analyzer.help;

public class CharacterHelper {
    public static boolean isSpaceLetter(char input) {
        return input == '\b' || input == '\t' || input == '\n' || input == '\r' || input == ' ' || input == '\u00a0';
    }

    public static boolean isEnglishLetter(char input) {
        return input >= 'a' && input <= 'z' || input >= 'A' && input <= 'Z';
    }

    public static boolean isArabicNumber(char input) {
        return input >= '0' && input <= '9';
    }

    public static boolean isCJKCharacter(char input) {
        Character.UnicodeBlock ub = Character.UnicodeBlock.of(input);
        return ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A || ub == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS || ub == Character.UnicodeBlock.HANGUL_SYLLABLES || ub == Character.UnicodeBlock.HANGUL_JAMO || ub == Character.UnicodeBlock.HANGUL_COMPATIBILITY_JAMO || ub == Character.UnicodeBlock.HIRAGANA || ub == Character.UnicodeBlock.KATAKANA || ub == Character.UnicodeBlock.KATAKANA_PHONETIC_EXTENSIONS;
    }

    public static char regularize(char input) {
        if (input == '\u3000') {
            input = (char)32;
        } else if (input > '\uff00' && input < '\uff5f') {
            input = (char)(input - 65248);
        } else if (input >= 'A' && input <= 'Z') {
            input = (char)(input + 32);
        }
        return input;
    }
}

