/*
 * Decompiled with CFR 0.152.
 */
package org.smslib.http;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.smslib.AGateway;
import org.smslib.GatewayException;
import org.smslib.Message;
import org.smslib.OutboundMessage;
import org.smslib.TimeoutException;
import org.smslib.helper.Logger;
import org.smslib.http.HTTPGateway;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class KannelHTTPGateway
extends HTTPGateway {
    String sendUrl;
    String username;
    String password;
    String adminUrl;
    String adminPassword;
    String statusPassword;
    boolean autoStartSmsc;
    boolean autoStopSmsc;
    Object SYNC_Commander;

    public KannelHTTPGateway(String smscId, String sendUrl, String username, String password) {
        super(smscId);
        this.sendUrl = sendUrl;
        this.username = username;
        this.password = password;
        this.SYNC_Commander = new Object();
        this.setAttributes(79);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean sendMessage(OutboundMessage msg) throws TimeoutException, GatewayException, IOException, InterruptedException {
        String text;
        String encodingHeader;
        ArrayList<HTTPGateway.HttpHeader> request = new ArrayList<HTTPGateway.HttpHeader>();
        String from = msg.getFrom();
        request.add(new HTTPGateway.HttpHeader("username", this.username, false));
        request.add(new HTTPGateway.HttpHeader("password", this.password, false));
        request.add(new HTTPGateway.HttpHeader("smsc", this.getGatewayId(), false));
        request.add(new HTTPGateway.HttpHeader("to", msg.getRecipient(), false));
        int priority = msg.getPriority();
        if (priority < 0) {
            priority = 0;
        } else if (priority > 3) {
            priority = 3;
        }
        request.add(new HTTPGateway.HttpHeader("priority", priority + "", false));
        if (msg.getValidityPeriod() >= 0) {
            request.add(new HTTPGateway.HttpHeader("validity", msg.getValidityPeriod() * 60 + "", false));
        }
        if (from == null) {
            from = this.getFrom();
        }
        if (from != null) {
            request.add(new HTTPGateway.HttpHeader("from", from, false));
        }
        Message.MessageEncodings encoding = msg.getEncoding();
        switch (encoding) {
            case ENC8BIT: {
                encodingHeader = "1";
                text = URLEncoder.encode(msg.getText(), "utf-8");
                break;
            }
            case ENCUCS2: {
                encodingHeader = "2";
                text = URLEncoder.encode(msg.getText(), "utf-16BE");
                break;
            }
            default: {
                encodingHeader = "0";
                text = URLEncoder.encode(msg.getText(), "utf-8");
            }
        }
        request.add(new HTTPGateway.HttpHeader("coding", encodingHeader, false));
        if (msg.getFlashSms()) {
            request.add(new HTTPGateway.HttpHeader("mclass", "1", false));
        }
        request.add(new HTTPGateway.HttpHeader("text", text, false));
        String reqLine = this.ExpandHttpHeaders(request);
        URL url = new URL(this.sendUrl + "?" + reqLine);
        Object object = this.SYNC_Commander;
        synchronized (object) {
            List<String> response = this.HttpGet(url);
            if (!response.get(0).startsWith("202")) {
                Logger.getInstance().logError("Error sending message. Response: " + response.get(0) + " - " + response.get(1), null, this.getGatewayId());
                msg.setRefNo(null);
                msg.setDispatchDate(null);
                msg.setMessageStatus(OutboundMessage.MessageStatuses.FAILED);
                msg.setFailureCause(this.getFailureCause(response));
                return false;
            }
            Logger.getInstance().logInfo("Message sent. Response: " + response.get(0) + " - " + response.get(1), null, this.getGatewayId());
        }
        msg.setDispatchDate(new Date());
        msg.setGatewayId(this.getGatewayId());
        msg.setMessageStatus(OutboundMessage.MessageStatuses.SENT);
        this.incOutboundMessageCount();
        return true;
    }

    private OutboundMessage.FailureCauses getFailureCause(List<String> response) {
        if (response.get(0).startsWith("503")) {
            return OutboundMessage.FailureCauses.GATEWAY_FAILURE;
        }
        String errorMessage = response.get(0);
        if (errorMessage.startsWith("Authorization failed")) {
            return OutboundMessage.FailureCauses.GATEWAY_AUTH;
        }
        if (errorMessage.startsWith("Missing receiver")) {
            return OutboundMessage.FailureCauses.BAD_NUMBER;
        }
        if (errorMessage.startsWith("Not routable")) {
            return OutboundMessage.FailureCauses.NO_ROUTE;
        }
        if (errorMessage.startsWith("Sender missing")) {
            return OutboundMessage.FailureCauses.BAD_FORMAT;
        }
        return OutboundMessage.FailureCauses.UNKNOWN;
    }

    public String getSendUrl() {
        return this.sendUrl;
    }

    public void setSendUrl(String sendUrl) {
        this.sendUrl = sendUrl;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getAdminUrl() {
        return this.adminUrl;
    }

    public void setAdminUrl(String adminUrl) {
        this.adminUrl = adminUrl;
        if (!this.adminUrl.endsWith("/")) {
            this.adminUrl = this.adminUrl + "/";
        }
    }

    public String getAdminPassword() {
        return this.adminPassword;
    }

    public void setAdminPassword(String adminPassword) {
        this.adminPassword = adminPassword;
    }

    @Override
    public void startGateway() throws TimeoutException, GatewayException, IOException, InterruptedException {
        if (this.autoStartSmsc && !this.startSmsc()) {
            this.setStatus(AGateway.GatewayStatuses.STARTING);
            super.stopGateway();
            this.setStatus(AGateway.GatewayStatuses.RESTART);
            return;
        }
        super.startGateway();
    }

    @Override
    public void stopGateway() throws TimeoutException, GatewayException, IOException, InterruptedException {
        if (this.autoStopSmsc) {
            this.stopSmsc();
        }
        super.stopGateway();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startSmsc() throws TimeoutException, GatewayException, IOException, InterruptedException {
        boolean started = true;
        KannelSMSCStatuses smscStatus = this.getKannelSMSCStatus();
        if (smscStatus == KannelSMSCStatuses.UNAVAILABLE || smscStatus == KannelSMSCStatuses.UNKNOWN) {
            started = false;
            Logger.getInstance().logError("SMSC was not found on Kannel.", null, this.getGatewayId());
        } else if (smscStatus == KannelSMSCStatuses.DEAD) {
            if (this.adminPassword == null) {
                Logger.getInstance().logWarn("Can't start Kannel SMSC, admin password not set.", null, this.getGatewayId());
            } else {
                List<String> response;
                ArrayList<HTTPGateway.HttpHeader> request = new ArrayList<HTTPGateway.HttpHeader>();
                request.add(new HTTPGateway.HttpHeader("smsc", this.getGatewayId(), false));
                request.add(new HTTPGateway.HttpHeader("password", this.adminPassword, false));
                String reqLine = this.ExpandHttpHeaders(request);
                URL url = new URL(this.adminUrl + "start-smsc.txt?" + reqLine);
                Object object = this.SYNC_Commander;
                synchronized (object) {
                    response = this.HttpGet(url);
                }
                if (response.get(1).startsWith("Denied")) {
                    Logger.getInstance().logError("Could not start SMSC." + response.get(0) + " - " + response.get(1), null, this.getGatewayId());
                    started = false;
                } else {
                    Logger.getInstance().logInfo("Sent command to start SMSC." + response.get(0) + " - " + response.get(1), null, this.getGatewayId());
                }
            }
        }
        return started;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stopSmsc() throws TimeoutException, GatewayException, IOException, InterruptedException {
        boolean stopped = true;
        if (this.adminUrl == null || this.adminPassword == null) {
            Logger.getInstance().logError("Can't stop Kannel SMSC, admin Url and password need to be set.", null, this.getGatewayId());
            stopped = false;
        } else {
            List<String> response;
            ArrayList<HTTPGateway.HttpHeader> request = new ArrayList<HTTPGateway.HttpHeader>();
            request.add(new HTTPGateway.HttpHeader("smsc", this.getGatewayId(), false));
            request.add(new HTTPGateway.HttpHeader("password", this.adminPassword, false));
            String reqLine = this.ExpandHttpHeaders(request);
            URL url = new URL(this.adminUrl + "stop-smsc.txt?" + reqLine);
            Object object = this.SYNC_Commander;
            synchronized (object) {
                response = this.HttpGet(url);
            }
            if (response.get(1).startsWith("Denied")) {
                Logger.getInstance().logError("Could not stop SMSC." + response.get(0) + " - " + response.get(1), null, this.getGatewayId());
                stopped = false;
            } else {
                Logger.getInstance().logInfo("Sent command to stop SMSC." + response.get(0) + " - " + response.get(1), null, this.getGatewayId());
            }
        }
        return stopped;
    }

    public KannelSMSCStatuses getKannelSMSCStatus() {
        if (this.adminUrl == null) {
            Logger.getInstance().logWarn("Can't check Kannel SMSC status, admin URL not set.", null, this.getGatewayId());
            return KannelSMSCStatuses.UNKNOWN;
        }
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        Document doc = null;
        try {
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            String url = this.adminUrl + "status.xml";
            if (this.statusPassword != null) {
                url = url + "?password=" + this.statusPassword;
            }
            doc = docBuilder.parse(url);
        }
        catch (SAXException e) {
            Logger.getInstance().logError("Error getting smsc status.", e, this.getGatewayId());
            return KannelSMSCStatuses.UNKNOWN;
        }
        catch (ParserConfigurationException e) {
            Logger.getInstance().logError("Error getting smsc status.", e, this.getGatewayId());
            return KannelSMSCStatuses.UNKNOWN;
        }
        catch (IOException e) {
            Logger.getInstance().logError("Error getting smsc status. Make sure Kannel is running.", e, this.getGatewayId());
            return KannelSMSCStatuses.UNKNOWN;
        }
        NodeList smscsList = doc.getElementsByTagName("smsc");
        int totalSmscs = smscsList.getLength();
        KannelSMSCStatuses smscStatus = KannelSMSCStatuses.UNAVAILABLE;
        for (int i = 0; i < totalSmscs; ++i) {
            Node smscNode = smscsList.item(i);
            if (smscNode.getNodeType() != 1) continue;
            Element smsc = (Element)smscNode;
            NodeList smscIdNodes = smsc.getElementsByTagName("id");
            String smscId = smscIdNodes.item(0).getTextContent();
            if (!this.getGatewayId().equalsIgnoreCase(smscId)) continue;
            NodeList smscStatusNodes = smsc.getElementsByTagName("status");
            String status = smscStatusNodes.item(0).getTextContent();
            if (status.startsWith("online")) {
                smscStatus = KannelSMSCStatuses.ONLINE;
            } else if (status.startsWith("connecting")) {
                smscStatus = KannelSMSCStatuses.CONNECTING;
            } else if (status.startsWith("re-connecting")) {
                smscStatus = KannelSMSCStatuses.RECONNECTING;
            } else if (status.startsWith("dead")) {
                smscStatus = KannelSMSCStatuses.DEAD;
            }
            return smscStatus;
        }
        return smscStatus;
    }

    @Override
    List<String> HttpGet(URL url) throws IOException {
        String inputLine;
        ArrayList<String> responseList = new ArrayList<String>();
        Logger.getInstance().logInfo("HTTP GET: " + url, null, this.getGatewayId());
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        con.setConnectTimeout(20000);
        con.setAllowUserInteraction(false);
        responseList.add(con.getResponseCode() + " " + con.getResponseMessage());
        InputStream inputStream = con.getErrorStream();
        if (inputStream == null) {
            inputStream = con.getInputStream();
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(inputStream));
        while ((inputLine = in.readLine()) != null) {
            responseList.add(inputLine);
        }
        in.close();
        return responseList;
    }

    public String getStatusPassword() {
        return this.statusPassword;
    }

    public void setStatusPassword(String statusPassword) {
        this.statusPassword = statusPassword;
    }

    public boolean isAutoStartSmsc() {
        return this.autoStartSmsc;
    }

    public void setAutoStartSmsc(boolean autoStartSmsc) {
        this.autoStartSmsc = autoStartSmsc;
    }

    public boolean isAutoStopSmsc() {
        return this.autoStopSmsc;
    }

    public void setAutoStopSmsc(boolean autoStopSmsc) {
        this.autoStopSmsc = autoStopSmsc;
    }

    public static enum KannelSMSCStatuses {
        ONLINE,
        DEAD,
        CONNECTING,
        RECONNECTING,
        UNAVAILABLE,
        UNKNOWN;

    }
}

