/*
 * Decompiled with CFR 0.152.
 */
package org.smslib.helper;

import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.smslib.helper.ReflectionHelper;
import org.smslib.helper.SerialPortEvent;
import org.smslib.helper.SerialPortEventListener;

public class SerialPort {
    private static Class<?> classSerialPort;
    public static final int FLOWCONTROL_RTSCTS_IN;
    public static final int DATABITS_8;
    public static final int STOPBITS_1;
    public static final int PARITY_NONE;
    public static final int FLOWCONTROL_RTSCTS_OUT;
    private Object realObject;

    protected SerialPort(Object myRealObject) {
        this.realObject = myRealObject;
    }

    public void addEventListener(SerialPortEventListener lsnr) {
        try {
            Method method = ReflectionHelper.getMethodOnlyByName(classSerialPort, "addEventListener");
            Class<?> eventI = method.getParameterTypes()[0];
            SerialPortEventListenerHandler handler = new SerialPortEventListenerHandler(lsnr);
            Class<?> proxyClass = Proxy.getProxyClass(eventI.getClassLoader(), eventI);
            method.invoke(this.realObject, proxyClass.getConstructor(InvocationHandler.class).newInstance(handler));
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(new RuntimeException(e.getTargetException().toString()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void close() {
        try {
            Method method = classSerialPort.getMethod("close", null);
            method.invoke(this.realObject, new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(new RuntimeException(e.getTargetException().toString()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void enableReceiveThreshold(int i) {
        try {
            Method method = classSerialPort.getMethod("enableReceiveThreshold", Integer.TYPE);
            method.invoke(this.realObject, i);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(new RuntimeException(e.getTargetException().toString()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void enableReceiveTimeout(int rcvTimeout) {
        Class[] paramTypes = new Class[]{Integer.TYPE};
        try {
            Method method = classSerialPort.getMethod("enableReceiveTimeout", paramTypes);
            method.invoke(this.realObject, rcvTimeout);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(new RuntimeException(e.getTargetException().toString()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public InputStream getInputStream() {
        try {
            Method method = classSerialPort.getMethod("getInputStream", null);
            return (InputStream)method.invoke(this.realObject, new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(new RuntimeException(e.getTargetException().toString()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public OutputStream getOutputStream() {
        try {
            Method method = classSerialPort.getMethod("getOutputStream", null);
            return (OutputStream)method.invoke(this.realObject, new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(new RuntimeException(e.getTargetException().toString()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void notifyOnBreakInterrupt(boolean b) {
        try {
            Method method = classSerialPort.getMethod("notifyOnBreakInterrupt", Boolean.TYPE);
            method.invoke(this.realObject, b);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(new RuntimeException(e.getTargetException().toString()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void notifyOnDataAvailable(boolean b) {
        try {
            Method method = classSerialPort.getMethod("notifyOnDataAvailable", Boolean.TYPE);
            method.invoke(this.realObject, b);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(new RuntimeException(e.getTargetException().toString()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void notifyOnFramingError(boolean b) {
        try {
            Method method = classSerialPort.getMethod("notifyOnFramingError", Boolean.TYPE);
            method.invoke(this.realObject, b);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(new RuntimeException(e.getTargetException().toString()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void notifyOnOutputEmpty(boolean b) {
        try {
            Method method = classSerialPort.getMethod("notifyOnOutputEmpty", Boolean.TYPE);
            method.invoke(this.realObject, b);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(new RuntimeException(e.getTargetException().toString()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void notifyOnOverrunError(boolean b) {
        try {
            Method method = classSerialPort.getMethod("notifyOnOverrunError", Boolean.TYPE);
            method.invoke(this.realObject, b);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(new RuntimeException(e.getTargetException().toString()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void notifyOnParityError(boolean b) {
        try {
            Method method = classSerialPort.getMethod("notifyOnParityError", Boolean.TYPE);
            method.invoke(this.realObject, b);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(new RuntimeException(e.getTargetException().toString()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setFlowControlMode(int flowcontrol) {
        Class[] paramTypes = new Class[]{Integer.TYPE};
        try {
            Method method = classSerialPort.getMethod("setFlowControlMode", paramTypes);
            method.invoke(this.realObject, flowcontrol);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(new RuntimeException(e.getTargetException().toString()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setInputBufferSize(int serial_buffer_size) {
        try {
            Method method = classSerialPort.getMethod("setInputBufferSize", Integer.TYPE);
            method.invoke(this.realObject, serial_buffer_size);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(new RuntimeException(e.getTargetException().toString()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setOutputBufferSize(int serial_buffer_size) {
        try {
            Method method = classSerialPort.getMethod("setOutputBufferSize", Integer.TYPE);
            method.invoke(this.realObject, serial_buffer_size);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(new RuntimeException(e.getTargetException().toString()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setSerialPortParams(int baudrate, int dataBits, int stopBits, int parity) {
        Class[] paramTypes = new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE};
        try {
            Method method = classSerialPort.getMethod("setSerialPortParams", paramTypes);
            method.invoke(this.realObject, baudrate, dataBits, stopBits, parity);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(new RuntimeException(e.getTargetException().toString()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        try {
            classSerialPort = Class.forName("javax.comm.SerialPort");
        }
        catch (ClassNotFoundException e1) {
            try {
                classSerialPort = Class.forName("gnu.io.SerialPort");
            }
            catch (ClassNotFoundException e2) {
                throw new RuntimeException("SerialPort class not found");
            }
        }
        try {
            Field f = classSerialPort.getField("FLOWCONTROL_RTSCTS_IN");
            FLOWCONTROL_RTSCTS_IN = f.getInt(null);
            f = classSerialPort.getField("DATABITS_8");
            DATABITS_8 = f.getInt(null);
            f = classSerialPort.getField("STOPBITS_1");
            STOPBITS_1 = f.getInt(null);
            f = classSerialPort.getField("PARITY_NONE");
            PARITY_NONE = f.getInt(null);
            f = classSerialPort.getField("FLOWCONTROL_RTSCTS_OUT");
            FLOWCONTROL_RTSCTS_OUT = f.getInt(null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private class SerialPortEventListenerHandler
    implements InvocationHandler {
        private SerialPortEventListener realListenerObject;

        public SerialPortEventListenerHandler(SerialPortEventListener realListenerObj) {
            this.realListenerObject = realListenerObj;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            this.realListenerObject.serialEvent(new SerialPortEvent(args[0]));
            return null;
        }
    }
}

