/*
 * Decompiled with CFR 0.152.
 */
package org.smslib;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.UUID;

public abstract class Message
implements Serializable {
    private static final long serialVersionUID = 2L;
    private static long messageIdSeed = 0L;
    private final long messageId = messageIdSeed++;
    private String gtwId;
    private MessageTypes type;
    private Date date;
    private String id;
    private String text;
    private String uuid = UUID.randomUUID().toString();
    private MessageEncodings encoding;
    private MessageClasses messageClass;
    protected int dstPort;
    protected int srcPort;
    protected int messageCharCount;

    public Message(MessageTypes myType, Date myDate, String myText) {
        this.setGatewayId("");
        this.setType(myType);
        this.setId("");
        this.setDate(myDate);
        if (myText != null) {
            this.setText(myText);
        }
        this.setEncoding(MessageEncodings.ENC7BIT);
        this.setSrcPort(-1);
        this.setDstPort(-1);
        this.messageCharCount = 0;
    }

    public Date getDate() {
        return this.date == null ? null : new Date(this.date.getTime());
    }

    public void setDate(Date myDate) {
        this.date = myDate != null ? new Date(myDate.getTime()) : null;
    }

    public MessageEncodings getEncoding() {
        return this.encoding;
    }

    public MessageClasses getDCSMessageClass() {
        return this.messageClass;
    }

    public void setDCSMessageClass(MessageClasses messageClass) {
        this.messageClass = messageClass;
    }

    public String getGatewayId() {
        return this.gtwId;
    }

    public void setGatewayId(String myGtwId) {
        this.gtwId = myGtwId;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String myId) {
        this.id = myId;
    }

    public long getMessageId() {
        return this.messageId;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String myText) {
        this.text = myText;
    }

    public void addText(String addText) throws UnsupportedEncodingException {
        if (this.text == null) {
            this.setText(addText);
        } else {
            this.text = this.text + addText;
        }
    }

    public MessageTypes getType() {
        return this.type;
    }

    void setType(MessageTypes myType) {
        this.type = myType;
    }

    public int getDstPort() {
        return this.dstPort;
    }

    public void setDstPort(int myDstPort) {
        this.dstPort = myDstPort;
    }

    public int getSrcPort() {
        return this.srcPort;
    }

    public void setSrcPort(int mySrcPort) {
        this.srcPort = mySrcPort;
    }

    public void setEncoding(MessageEncodings myEncoding) {
        this.encoding = myEncoding;
    }

    public abstract String getPduUserData();

    public abstract String getPduUserDataHeader();

    protected void copyTo(Message msg) {
        msg.setDate(this.getDate());
        msg.setEncoding(this.getEncoding());
        msg.setDCSMessageClass(this.getDCSMessageClass());
        msg.setId(this.getId());
        msg.setGatewayId(this.getGatewayId());
        msg.setSrcPort(this.getSrcPort());
        msg.setDstPort(this.getDstPort());
        msg.setType(this.getType());
        msg.setText(this.getText());
        msg.messageCharCount = this.messageCharCount;
    }

    public String getUuid() {
        return this.uuid;
    }

    public static enum MessageTypes {
        INBOUND,
        OUTBOUND,
        STATUSREPORT,
        WAPSI,
        UNKNOWN;

    }

    public static enum MessageClasses {
        MSGCLASS_NONE,
        MSGCLASS_FLASH,
        MSGCLASS_ME,
        MSGCLASS_SIM,
        MSGCLASS_TE;

    }

    public static enum MessageEncodings {
        ENC7BIT,
        ENC8BIT,
        ENCUCS2,
        ENCCUSTOM;

    }
}

