/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.MockDirectoryWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockIndexInputWrapper
extends IndexInput {
    private MockDirectoryWrapper dir;
    final String name;
    private IndexInput delegate;
    private boolean isClone;
    private boolean closed;

    public MockIndexInputWrapper(MockDirectoryWrapper dir, String name, IndexInput delegate) {
        super("MockIndexInputWrapper(name=" + name + " delegate=" + delegate + ")");
        this.name = name;
        this.dir = dir;
        this.delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        block0: {
            this.closed = true;
            this.delegate.close();
            if (this.isClone) break block0;
            this.dir.removeIndexInput(this, this.name);
        }
    }

    private void ensureOpen() {
        if (this.closed) {
            throw new RuntimeException("Abusing closed IndexInput!");
        }
    }

    public Object clone() {
        this.ensureOpen();
        this.dir.inputCloneCount.incrementAndGet();
        IndexInput iiclone = (IndexInput)this.delegate.clone();
        MockIndexInputWrapper clone = new MockIndexInputWrapper(this.dir, this.name, iiclone);
        clone.isClone = true;
        return clone;
    }

    public long getFilePointer() {
        this.ensureOpen();
        return this.delegate.getFilePointer();
    }

    public void seek(long pos) throws IOException {
        this.ensureOpen();
        this.delegate.seek(pos);
    }

    public long length() {
        this.ensureOpen();
        return this.delegate.length();
    }

    public byte readByte() throws IOException {
        this.ensureOpen();
        return this.delegate.readByte();
    }

    public void readBytes(byte[] b, int offset, int len) throws IOException {
        this.ensureOpen();
        this.delegate.readBytes(b, offset, len);
    }

    public void copyBytes(IndexOutput out, long numBytes) throws IOException {
        this.ensureOpen();
        this.delegate.copyBytes(out, numBytes);
    }

    public void readBytes(byte[] b, int offset, int len, boolean useBuffer) throws IOException {
        this.ensureOpen();
        this.delegate.readBytes(b, offset, len, useBuffer);
    }

    public int readInt() throws IOException {
        this.ensureOpen();
        return this.delegate.readInt();
    }

    public int readVInt() throws IOException {
        this.ensureOpen();
        return this.delegate.readVInt();
    }

    public long readLong() throws IOException {
        this.ensureOpen();
        return this.delegate.readLong();
    }

    public long readVLong() throws IOException {
        this.ensureOpen();
        return this.delegate.readVLong();
    }

    public String readString() throws IOException {
        this.ensureOpen();
        return this.delegate.readString();
    }

    public Map<String, String> readStringStringMap() throws IOException {
        this.ensureOpen();
        return this.delegate.readStringStringMap();
    }

    public void setModifiedUTF8StringsMode() {
        this.ensureOpen();
        this.delegate.setModifiedUTF8StringsMode();
    }

    public void readChars(char[] buffer, int start, int length) throws IOException {
        this.ensureOpen();
        this.delegate.readChars(buffer, start, length);
    }

    public void skipChars(int length) throws IOException {
        this.ensureOpen();
        this.delegate.skipChars(length);
    }
}

