/*
 * Decompiled with CFR 0.152.
 */
package com.xtframe.sec.wf.service.impl;

import com.xtframe.core.org.entity.Org;
import com.xtframe.core.role.entity.Role;
import com.xtframe.core.user.entity.User;
import com.xtframe.core.utils.Assert;
import com.xtframe.sec.common.BaseSecurityService;
import com.xtframe.sec.wf.dao.WfConfigClrDao;
import com.xtframe.sec.wf.entity.WfConfigClrEntity;
import com.xtframe.sec.wf.entity.WfConfigEntity;
import com.xtframe.sec.wf.service.WfConfigClrService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class WfConfigClrServiceImpl
extends BaseSecurityService
implements WfConfigClrService {
    private WfConfigClrDao dao;

    public void init() {
        this.dao = (WfConfigClrDao)this.getBeans().get("wfConfigClrDao");
        Assert.notNull((Object)this.dao);
    }

    @Override
    public List<WfConfigClrEntity> findByProcessKeyAndTaskKey(String processKey, String taskKey) {
        return this.dao.findByProcessKeyAndTaskKey(processKey, taskKey);
    }

    @Override
    public List<WfConfigClrEntity> findByProcessKeyAndTaskKeyAndType(String processKey, String taskKey, String type) {
        return this.dao.findByProcessKeyAndTaskKeyAndTypeOrderBySortnoAsc(processKey, taskKey, type);
    }

    @Override
    public void saveWfConfigRoleMap(WfConfigEntity config, String[] roles) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("processKey", config.getProcessKey());
        params.put("taskKey", config.getTaskKey());
        params.put("type", "2");
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("delete from T_XTFRAME_WF_CONFIG_CLR WHERE PROCESS_KEY=:processKey and TASK_KEY=:taskKey AND TYPE=:type");
        this.dao.nativeUpdate(sqlBuilder.toString(), params);
        if (roles != null && roles.length > 0) {
            int i = 1;
            ArrayList<WfConfigClrEntity> clrs = new ArrayList<WfConfigClrEntity>();
            String[] stringArray = roles;
            int n = roles.length;
            int n2 = 0;
            while (n2 < n) {
                String r = stringArray[n2];
                Role role = this.securityMgr.roleService().findById(r);
                if (role != null && role.getValid().booleanValue()) {
                    WfConfigClrEntity e = new WfConfigClrEntity();
                    e.setClrid(role.getId());
                    e.setClrmc(role.getName());
                    e.setProcessKey(config.getProcessKey());
                    e.setSortno(i++);
                    e.setTaskKey(config.getTaskKey());
                    e.setType("2");
                    e.setValid(true);
                    clrs.add(e);
                }
                ++n2;
            }
            this.dao.save(clrs);
        }
    }

    @Override
    public void saveWfConfigOrgMap(WfConfigEntity config, String[] orgs) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("processKey", config.getProcessKey());
        params.put("taskKey", config.getTaskKey());
        params.put("type", "1");
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("delete from T_XTFRAME_WF_CONFIG_CLR WHERE PROCESS_KEY=:processKey and TASK_KEY=:taskKey AND TYPE=:type");
        this.dao.nativeUpdate(sqlBuilder.toString(), params);
        int i = 1;
        if (orgs != null && orgs.length > 0) {
            ArrayList<WfConfigClrEntity> clrs = new ArrayList<WfConfigClrEntity>();
            String[] stringArray = orgs;
            int n = orgs.length;
            int n2 = 0;
            while (n2 < n) {
                String o = stringArray[n2];
                Org org = this.securityMgr.orgService().findOne(o);
                if (org != null && org.getValid().booleanValue()) {
                    WfConfigClrEntity e = new WfConfigClrEntity();
                    e.setClrid(org.getId());
                    e.setClrmc(org.getName());
                    e.setProcessKey(config.getProcessKey());
                    e.setSortno(i++);
                    e.setTaskKey(config.getTaskKey());
                    e.setType("1");
                    e.setValid(true);
                    clrs.add(e);
                }
                ++n2;
            }
            this.dao.save(clrs);
        }
    }

    @Override
    public void saveWfConfigUserMap(WfConfigEntity config, String[] users) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("processKey", config.getProcessKey());
        params.put("taskKey", config.getTaskKey());
        params.put("type", "3");
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("delete from T_XTFRAME_WF_CONFIG_CLR WHERE PROCESS_KEY=:processKey and TASK_KEY=:taskKey AND TYPE=:type");
        this.dao.nativeUpdate(sqlBuilder.toString(), params);
        if (users != null && users.length > 0) {
            int i = 1;
            ArrayList<WfConfigClrEntity> clrs = new ArrayList<WfConfigClrEntity>();
            String[] stringArray = users;
            int n = users.length;
            int n2 = 0;
            while (n2 < n) {
                String u = stringArray[n2];
                User user = this.securityMgr.userService().findById(u);
                if (user != null && user.getValid().booleanValue()) {
                    WfConfigClrEntity e = new WfConfigClrEntity();
                    e.setClrid(user.getId());
                    e.setClrmc(user.getName());
                    e.setProcessKey(config.getProcessKey());
                    e.setSortno(i++);
                    e.setTaskKey(config.getTaskKey());
                    e.setType("3");
                    e.setValid(true);
                    clrs.add(e);
                }
                ++n2;
            }
            this.dao.save(clrs);
        }
    }
}

