/*
 * Decompiled with CFR 0.152.
 */
package com.xtframe.sec.support;

import com.xtframe.sec.common.BaseSecurityService;
import com.xtframe.sec.common.QueryService;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.query.QueryUtils;
import org.springframework.util.Assert;

public class QueryServiceImpl
extends BaseSecurityService
implements QueryService {
    @Override
    public <T> Page<T> findAll(Specification<T> spec, Pageable pageable, Class<T> domainClass) {
        TypedQuery<T> query = this.getQuery(spec, pageable, domainClass);
        return pageable == null ? new Page<T>(query.getResultList()) : this.readPage(query, pageable, spec, domainClass);
    }

    @Override
    public <T> List<T> findAll(Specification<T> spec, Class<T> domainClass) {
        return this.getQuery(spec, (Sort)null, domainClass).getResultList();
    }

    protected <T> Page<T> readPage(TypedQuery<T> query, Pageable pageable, Specification<T> spec, Class<T> domainClass) {
        query.setFirstResult(pageable.getOffset());
        query.setMaxResults(pageable.getPageSize());
        Long total = QueryUtils.executeCountQuery(this.getCountQuery(spec, domainClass));
        List content = total > (long)pageable.getOffset() ? query.getResultList() : Collections.emptyList();
        return new PageImpl(content, pageable, total.longValue());
    }

    protected <T> TypedQuery<Long> getCountQuery(Specification<T> spec, Class<T> domainClass) {
        CriteriaBuilder builder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(Long.class);
        Root<T> root = this.applySpecificationToCriteria(spec, query, domainClass);
        if (query.isDistinct()) {
            query.select((Selection)builder.countDistinct(root));
        } else {
            query.select((Selection)builder.count(root));
        }
        return this.entityManager.createQuery(query);
    }

    protected <T> TypedQuery<T> getQuery(Specification<T> spec, Pageable pageable, Class<T> domainClass) {
        Sort sort = pageable == null ? null : pageable.getSort();
        return this.getQuery(spec, sort, domainClass);
    }

    protected <T> TypedQuery<T> getQuery(Specification<T> spec, Sort sort, Class<T> domainClass) {
        CriteriaBuilder builder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(domainClass);
        Root<T> root = this.applySpecificationToCriteria(spec, query, domainClass);
        query.select(root);
        if (sort != null) {
            query.orderBy(QueryUtils.toOrders((Sort)sort, root, (CriteriaBuilder)builder));
        }
        return this.applyRepositoryMethodMetadata(this.entityManager.createQuery(query));
    }

    public void init() {
    }

    private <S, T> Root<T> applySpecificationToCriteria(Specification<T> spec, CriteriaQuery<S> query, Class<T> domainClass) {
        Assert.notNull(query);
        Root root = query.from(domainClass);
        if (spec == null) {
            return root;
        }
        CriteriaBuilder builder = this.entityManager.getCriteriaBuilder();
        Predicate predicate = spec.toPredicate(root, query, builder);
        if (predicate != null) {
            query.where((Expression)predicate);
        }
        return root;
    }

    private <T> TypedQuery<T> applyRepositoryMethodMetadata(TypedQuery<T> query) {
        return query;
    }

    @Override
    public <T> List<T> nativeQuery(String sqlString, Class<T> resultClass, Map<String, Object> params) {
        Query query = this.entityManager.createNativeQuery(sqlString, resultClass);
        if (params != null && params.size() > 0) {
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                query.setParameter(entry.getKey(), entry.getValue());
            }
        }
        return query.getResultList();
    }

    @Override
    public <T> List<?> nativeQuery(String sqlString, Map<String, Object> params) {
        Query query = this.entityManager.createNativeQuery(sqlString);
        if (params != null && params.size() > 0) {
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                query.setParameter(entry.getKey(), entry.getValue());
            }
        }
        return query.getResultList();
    }

    @Override
    public Query createNativeQuery(String sqlString) {
        return this.entityManager.createNativeQuery(sqlString);
    }

    @Override
    public Query createNativeQuery(String sqlString, Class<?> resultClass) {
        return this.entityManager.createNativeQuery(sqlString, resultClass);
    }

    @Override
    public Query createNativeQuery(String sqlString, String resultSetMapping) {
        return this.entityManager.createNativeQuery(sqlString, resultSetMapping);
    }
}

