/*
 * Decompiled with CFR 0.152.
 */
package com.xtframe.sec.role.entity;

import com.fasterxml.jackson.annotation.JsonBackReference;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.xtframe.core.menu.entity.Function;
import com.xtframe.core.menu.entity.Menu;
import com.xtframe.core.role.entity.Role;
import com.xtframe.core.user.entity.User;
import com.xtframe.sec.common.BaseEntity;
import com.xtframe.sec.menu.entity.FunctionEntity;
import com.xtframe.sec.menu.entity.MenuEntity;
import com.xtframe.sec.user.entity.UserEntity;
import com.xtframe.sec.utils.BooleanSerializer;
import java.util.List;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.Table;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Type;

@Entity
@Table(name="t_xtframe_role")
public class RoleEntity
extends BaseEntity<String>
implements Role {
    private static final long serialVersionUID = -5951850104469034274L;
    private String id;
    private String orgid;
    private String name;
    private String code;
    private List<Menu> menus;
    private List<Function> funcs;
    private int sortno;
    private List<User> users;
    @JsonSerialize(using=BooleanSerializer.class)
    private Boolean valid;

    public String getCode() {
        return this.code;
    }

    @ManyToMany(fetch=FetchType.LAZY, targetEntity=FunctionEntity.class)
    @JoinTable(name="T_XTFRAME_ROLE_FUNC ", joinColumns={@JoinColumn(name="rid")}, inverseJoinColumns={@JoinColumn(name="fid")})
    @JsonBackReference
    public List<Function> getFuncs() {
        return this.funcs;
    }

    @Id
    @GenericGenerator(name="systemUUID", strategy="uuid")
    @GeneratedValue(generator="systemUUID")
    public String getId() {
        return this.id;
    }

    @ManyToMany(fetch=FetchType.LAZY, targetEntity=MenuEntity.class)
    @JoinTable(name="T_XTFRAME_ROLE_MENU", joinColumns={@JoinColumn(name="rid")}, inverseJoinColumns={@JoinColumn(name="mid")})
    @JsonBackReference
    public List<Menu> getMenus() {
        return this.menus;
    }

    public String getName() {
        return this.name;
    }

    public String getOrgid() {
        return this.orgid;
    }

    public int getSortno() {
        return this.sortno;
    }

    @ManyToMany(fetch=FetchType.LAZY, targetEntity=UserEntity.class)
    @JoinTable(name="T_XTFRAME_ROLE_USER ", joinColumns={@JoinColumn(name="rid")}, inverseJoinColumns={@JoinColumn(name="userid")})
    @JsonBackReference
    public List<User> getUsers() {
        return this.users;
    }

    @Type(type="yes_no")
    public Boolean getValid() {
        return this.valid;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setFuncs(List<Function> funcs) {
        this.funcs = funcs;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setMenus(List<Menu> menus) {
        this.menus = menus;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setOrgid(String orgid) {
        this.orgid = orgid;
    }

    public void setSortno(int sortno) {
        this.sortno = sortno;
    }

    public void setUsers(List<User> users) {
        this.users = users;
    }

    public void setValid(Boolean valid) {
        this.valid = valid;
    }
}

