/*
 * Decompiled with CFR 0.152.
 */
package com.xtframe.sec.menu.service.impl;

import com.xtframe.core.base.vo.NodeVo;
import com.xtframe.core.exception.BizException;
import com.xtframe.core.menu.entity.Function;
import com.xtframe.core.menu.entity.Menu;
import com.xtframe.core.menu.service.MenuService;
import com.xtframe.core.user.entity.User;
import com.xtframe.sec.common.BaseSecurityService;
import com.xtframe.sec.menu.dao.FunctionDao;
import com.xtframe.sec.menu.dao.MenuDao;
import com.xtframe.sec.menu.entity.FunctionEntity;
import com.xtframe.sec.menu.entity.MenuEntity;
import com.xtframe.sec.utils.SecUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.transaction.Transactional;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.util.Assert;

public class MenuServiceImpl
extends BaseSecurityService
implements MenuService {
    private MenuDao dao;
    private FunctionDao funcDao;

    @Transactional
    public String delete(String ... ids) {
        this.dao.delete((Serializable[])ids);
        return null;
    }

    public void deleteOrgFunctionMap(String arg0, String ... arg1) {
        throw new BizException("\u4e0d\u652f\u6301\u6b64\u65b9\u6cd5\uff01\u8bf7\u4e0e\u7ba1\u7406\u5458\u8054\u7cfb\uff01");
    }

    public void deleteOrgMenuMap(String arg0, String ... arg1) {
        throw new BizException("\u4e0d\u652f\u6301\u6b64\u65b9\u6cd5\uff01\u8bf7\u4e0e\u7ba1\u7406\u5458\u8054\u7cfb\uff01");
    }

    public void deleteRoleFunctionMap(String arg0, String ... arg1) {
        throw new BizException("\u4e0d\u652f\u6301\u6b64\u65b9\u6cd5\uff01\u8bf7\u4e0e\u7ba1\u7406\u5458\u8054\u7cfb\uff01");
    }

    public void deleteRoleMenuMap(String arg0, String ... arg1) {
        throw new BizException("\u4e0d\u652f\u6301\u6b64\u65b9\u6cd5\uff01\u8bf7\u4e0e\u7ba1\u7406\u5458\u8054\u7cfb\uff01");
    }

    public void deleteUserMenuMap(String arg0, String ... arg1) {
        throw new BizException("\u4e0d\u652f\u6301\u6b64\u65b9\u6cd5\uff01\u8bf7\u4e0e\u7ba1\u7406\u5458\u8054\u7cfb\uff01");
    }

    public List<Menu> findAccordionMenus() {
        return this.findAuthedMenuByPid("00");
    }

    public List<Menu> findAuthedMenuByPid(String pid) {
        User u = SecUtils.getCurrUser();
        String sql = "SELECT M.* FROM T_XTFRAME_MENU M WHERE M.VALID='Y' AND M.PID=:pid AND( EXISTS(SELECT 1 FROM T_XTFRAME_USER_MENU UM WHERE UM.MID=M.ID AND UM.USERID=:userid) OR EXISTS( SELECT 1 FROM T_XTFRAME_ROLE_MENU RM JOIN T_XTFRAME_ROLE_USER RU ON RM.RID=RU.RID WHERE RU.USERID=:userid AND RM.MID=M.ID) OR EXISTS( SELECT 1 FROM T_XTFRAME_ORG_MENU OM JOIN T_XTFRAME_USER U ON OM.ORGID=U.ORG WHERE U.ID=:userid AND OM.MID=M.ID)) ORDER BY M.SORTNO ASC";
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("userid", u.getId());
        params.put("pid", pid);
        List<MenuEntity> menus = this.dao.nativeQuery(sql, MenuEntity.class, params);
        ArrayList<Menu> ms = new ArrayList<Menu>(menus.size());
        for (MenuEntity m : menus) {
            ms.add(m);
        }
        return ms;
    }

    public Function findFunction(String id) {
        return (Function)this.funcDao.findOne((Serializable)((Object)id));
    }

    public List<Function> findFunctionByIds(String ... id) {
        return this.funcDao.findByIdInOrderBySortnoAsc(id);
    }

    public Menu findMenu(String id) {
        return (Menu)this.dao.findOne((Serializable)((Object)id));
    }

    public List<Menu> findMenuByIds(String ... id) {
        return this.dao.findByIdInOrderBySortnoAsc(id);
    }

    public List<Function> findValidFunctionByOrgId(String orgId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orgid", orgId);
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("select f.* from T_XTFRAME_FUNC f join T_XTFRAME_ORG_FUNC ofc on f.id=ofc.fid where ofc.orgid=:orgid");
        List<FunctionEntity> fes = this.funcDao.nativeQuery(sqlBuilder.toString(), FunctionEntity.class, params);
        ArrayList<Function> fs = new ArrayList<Function>(fes.size());
        for (FunctionEntity fe : fes) {
            fs.add(fe);
        }
        return fs;
    }

    public List<Function> findValidFunctionByRoleId(String roleId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("roleid", roleId);
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("select f.* from T_XTFRAME_FUNC f join T_XTFRAME_ROLE_FUNC rfc on f.id=rfc.fid where rfc.rid=:roleid");
        List<FunctionEntity> fes = this.funcDao.nativeQuery(sqlBuilder.toString(), FunctionEntity.class, params);
        ArrayList<Function> fs = new ArrayList<Function>(fes.size());
        for (FunctionEntity fe : fes) {
            fs.add(fe);
        }
        return fs;
    }

    public List<Function> findValidFunctionByUserId(String userId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("userid", userId);
        List<FunctionEntity> fes = this.funcDao.nativeQuery("select f.* from T_XTFRAME_FUNC f join T_XTFRAME_USER_FUNC ufc on f.id=ufc.fid where ufc.userid=:userid", FunctionEntity.class, params);
        ArrayList<Function> fs = new ArrayList<Function>(fes.size());
        for (FunctionEntity fe : fes) {
            fs.add(fe);
        }
        return fs;
    }

    public List<Menu> findValidMenuByOrgId(String orgId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orgid", orgId);
        List<MenuEntity> mes = this.dao.nativeQuery("select m.* from T_XTFRAME_MENU m join T_XTFRAME_ORG_MENU om on m.id=om.mid where om.orgid=:orgid", MenuEntity.class, params);
        ArrayList<Menu> ms = new ArrayList<Menu>(mes.size());
        for (MenuEntity me : mes) {
            ms.add(me);
        }
        return ms;
    }

    public List<Menu> findValidMenuByPid(String pid) {
        return this.dao.findValidMenusByPid(pid);
    }

    public List<Menu> findValidMenuByRoleId(String roleId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("roleid", roleId);
        List<MenuEntity> mes = this.dao.nativeQuery("select m.* from T_XTFRAME_MENU m join T_XTFRAME_ROLE_MENU rm on m.id=rm.mid where rm.rid=:roleid", MenuEntity.class, params);
        ArrayList<Menu> ms = new ArrayList<Menu>(mes.size());
        for (MenuEntity me : mes) {
            ms.add(me);
        }
        return ms;
    }

    public List<Menu> findValidMenuByUserId(String userid) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("userid", userid);
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("select m.* from T_XTFRAME_MENU m join T_XTFRAME_USER_MENU um on m.id=um.mid where um.userid=:userid");
        List<MenuEntity> mes = this.dao.nativeQuery(sqlBuilder.toString(), MenuEntity.class, params);
        ArrayList<Menu> ms = new ArrayList<Menu>(mes.size());
        for (MenuEntity me : mes) {
            ms.add(me);
        }
        return ms;
    }

    public List<NodeVo> getCheckedMenusByPid(String pid, Collection<Menu> authedMenus, Collection<Function> authedFuncs, boolean cascade) {
        ArrayList<NodeVo> menuVos = new ArrayList<NodeVo>();
        List menus = this.securityMgr.findValidMenusByPid(pid);
        for (Menu m : menus) {
            if (!(m instanceof MenuEntity)) continue;
            NodeVo mv = new NodeVo();
            mv.setId(m.getId());
            mv.setText(m.getName());
            mv.setParent(m.getPid());
            mv.setState("closed");
            if (authedMenus.contains(m)) {
                mv.setChecked(true);
            } else {
                mv.setChecked(false);
            }
            HashMap<String, String> attr = new HashMap<String, String>();
            attr.put("url", m.getUrl());
            attr.put("leaf", String.valueOf(m.getLeaf()));
            attr.put("type", "menu");
            if (m.getLeaf().booleanValue()) {
                attr.put("funcs", this.getFunctionByMenu(m.getId(), authedFuncs).toString());
                mv.setState("open");
            } else if (cascade) {
                mv.setChildren(this.getCheckedMenusByPid(mv.getId(), authedMenus, authedFuncs, cascade));
            }
            mv.setAttributes(attr);
            menuVos.add(mv);
        }
        return menuVos;
    }

    public JSONArray getFunctionByMenu(final String mid, Collection<Function> authedFuncs) {
        Specification<FunctionEntity> spec = new Specification<FunctionEntity>(){

            public Predicate toPredicate(Root<FunctionEntity> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
                ArrayList<Predicate> list = new ArrayList<Predicate>();
                list.add(cb.equal(root.get("menu").get("id").as(String.class), (Object)mid));
                return cb.and(list.toArray(new Predicate[0]));
            }
        };
        List funcList = this.funcDao.findAll((Specification)spec);
        JSONArray arr = new JSONArray();
        for (FunctionEntity f : funcList) {
            JSONObject jo = new JSONObject();
            jo.put((Object)"id", (Object)f.getId());
            jo.put((Object)"name", (Object)f.getName());
            if (authedFuncs.contains((Object)f)) {
                jo.put((Object)"checked", (Object)true);
            } else {
                jo.put((Object)"checked", (Object)false);
            }
            arr.add((Object)jo);
        }
        return arr;
    }

    public void init() {
        this.dao = (MenuDao)this.getBeans().get("menuDao");
        this.funcDao = (FunctionDao)this.getBeans().get("functionDao");
        Assert.notNull((Object)this.dao);
    }

    @Transactional
    public Menu save(Menu menu) {
        if (menu instanceof MenuEntity) {
            return (Menu)this.dao.save((Object)((MenuEntity)menu));
        }
        return null;
    }

    @Transactional
    public Function saveFunction(Function f) {
        if (f instanceof FunctionEntity) {
            return (Function)this.funcDao.save((Object)((FunctionEntity)f));
        }
        return null;
    }

    public void saveOrgFunctionMap(String orgid, String ... funcIds) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orgid", orgid);
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("delete from T_XTFRAME_ORG_FUNC where orgid=:orgid");
        this.dao.nativeUpdate(sqlBuilder.toString(), params);
        sqlBuilder.setLength(0);
        sqlBuilder.append("insert into T_XTFRAME_ORG_FUNC(orgid,fid)values(:orgid,:fid) ");
        String[] stringArray = funcIds;
        int n = funcIds.length;
        int n2 = 0;
        while (n2 < n) {
            String fid = stringArray[n2];
            params.put("fid", fid);
            this.dao.nativeUpdate(sqlBuilder.toString(), params);
            ++n2;
        }
    }

    @Transactional
    public void saveOrgMenuMap(String orgId, String ... menuIds) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orgid", orgId);
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("delete from T_XTFRAME_ORG_MENU where orgid=:orgid");
        this.dao.nativeUpdate(sqlBuilder.toString(), params);
        sqlBuilder.setLength(0);
        sqlBuilder.append("insert into T_XTFRAME_ORG_MENU(orgid,mid)values(:orgid,:mid) ");
        String[] stringArray = menuIds;
        int n = menuIds.length;
        int n2 = 0;
        while (n2 < n) {
            String mid = stringArray[n2];
            params.put("mid", mid);
            this.dao.nativeUpdate(sqlBuilder.toString(), params);
            ++n2;
        }
    }

    public void saveRoleFunctionMap(String roleid, String ... funcIds) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("roleid", roleid);
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("delete from T_XTFRAME_ROLE_FUNC where rid=:roleid");
        this.dao.nativeUpdate(sqlBuilder.toString(), params);
        sqlBuilder.setLength(0);
        sqlBuilder.append("insert into T_XTFRAME_ROLE_FUNC(rid,fid)values(:roleid,:fid) ");
        String[] stringArray = funcIds;
        int n = funcIds.length;
        int n2 = 0;
        while (n2 < n) {
            String fid = stringArray[n2];
            params.put("fid", fid);
            this.dao.nativeUpdate(sqlBuilder.toString(), params);
            ++n2;
        }
    }

    public void saveRoleMenuMap(String roleid, String ... menuIds) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("roleid", roleid);
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("delete from T_XTFRAME_ROLE_MENU where rid=:roleid");
        this.dao.nativeUpdate(sqlBuilder.toString(), params);
        sqlBuilder.setLength(0);
        sqlBuilder.append("insert into T_XTFRAME_ROLE_MENU(rid,mid)values(:roleid,:mid) ");
        String[] stringArray = menuIds;
        int n = menuIds.length;
        int n2 = 0;
        while (n2 < n) {
            String mid = stringArray[n2];
            params.put("mid", mid);
            this.dao.nativeUpdate(sqlBuilder.toString(), params);
            ++n2;
        }
    }

    public void saveUserFunctionMap(String userid, String ... funcIds) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("userid", userid);
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("delete from T_XTFRAME_USER_FUNC where userid=:userid");
        this.dao.nativeUpdate(sqlBuilder.toString(), params);
        sqlBuilder.setLength(0);
        sqlBuilder.append("insert into T_XTFRAME_USER_FUNC(userid,fid)values(:userid,:fid) ");
        String[] stringArray = funcIds;
        int n = funcIds.length;
        int n2 = 0;
        while (n2 < n) {
            String fid = stringArray[n2];
            params.put("fid", fid);
            this.dao.nativeUpdate(sqlBuilder.toString(), params);
            ++n2;
        }
    }

    public void saveUserMenuMap(String userid, String ... menuIds) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("userid", userid);
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("delete from T_XTFRAME_USER_MENU where userid=:userid");
        this.dao.nativeUpdate(sqlBuilder.toString(), params);
        sqlBuilder.setLength(0);
        sqlBuilder.append("insert into T_XTFRAME_USER_MENU(userid,mid)values(:userid,:mid) ");
        String[] stringArray = menuIds;
        int n = menuIds.length;
        int n2 = 0;
        while (n2 < n) {
            String mid = stringArray[n2];
            params.put("mid", mid);
            this.dao.nativeUpdate(sqlBuilder.toString(), params);
            ++n2;
        }
    }
}

