/*
 * Decompiled with CFR 0.152.
 */
package com.xtframe.sec.log.service.impl;

import com.xtframe.core.anon.BizLog;
import com.xtframe.core.log.BizLogRecorder;
import com.xtframe.core.support.SecurityMgr;
import com.xtframe.core.support.aware.SecurityMgrAware;
import com.xtframe.core.user.entity.User;
import com.xtframe.sec.common.BaseSecurityService;
import com.xtframe.sec.log.dao.BizLogDao;
import com.xtframe.sec.log.entity.BizLogEntity;
import com.xtframe.util.Exceptions;
import com.xtframe.util.StringUtils;
import java.util.Enumeration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.transaction.Transactional;
import org.springframework.web.HttpRequestHandler;
import org.springframework.web.method.HandlerMethod;

public class SpringMvcBizLogRecorder
extends BaseSecurityService
implements BizLogRecorder,
SecurityMgrAware {
    private SecurityMgr securityMgr;
    private BizLogDao dao;

    public void init() {
        this.dao = (BizLogDao)this.beans.get("bizLogDao");
        super.init();
    }

    public void log(Object request, Object response, Object handler, BizLogRecorder.HandlerType type, long cost) {
        User u = this.securityMgr.getCurrUser();
        if (u == null) {
            return;
        }
        if (handler instanceof HttpRequestHandler) {
            return;
        }
        BizLogEntity entity = null;
        switch (type) {
            case PreHandle: {
                entity = this.logPreHandle(request, response, handler);
                break;
            }
            case PostHandle: {
                entity = this.logPostHandle(request, response, handler, cost);
                break;
            }
            case AfterCompletion: {
                entity = this.logAfterCompletion(request, response, handler, cost);
                break;
            }
            case Exception: {
                entity = this.logException(request, response, handler, cost);
                break;
            }
        }
        entity.setHandlerType(type.getValue());
        this.save(entity);
    }

    private BizLogEntity logPreHandle(Object request, Object response, Object handler) {
        BizLogEntity entity = new BizLogEntity();
        entity.setUserid(this.securityMgr.getCurrUser().getId());
        if (handler instanceof HandlerMethod) {
            this.writeHandlerMethodToBizLog(entity, (HandlerMethod)handler);
        }
        if (request instanceof HttpServletRequest) {
            this.writeRequestToBizLog(entity, (HttpServletRequest)request);
        }
        return entity;
    }

    private BizLogEntity logPostHandle(Object request, Object response, Object handler, long cost) {
        BizLogEntity entity = new BizLogEntity();
        entity.setUserid(this.securityMgr.getCurrUser().getId());
        entity.setCost(cost);
        if (handler instanceof HandlerMethod) {
            this.writeHandlerMethodToBizLog(entity, (HandlerMethod)handler);
        }
        if (request instanceof HttpServletRequest) {
            this.writeRequestToBizLog(entity, (HttpServletRequest)request);
        }
        return entity;
    }

    private BizLogEntity logAfterCompletion(Object request, Object response, Object handler, long cost) {
        BizLogEntity entity = new BizLogEntity();
        entity.setUserid(this.securityMgr.getCurrUser().getId());
        entity.setCost(cost);
        if (handler instanceof HandlerMethod) {
            this.writeHandlerMethodToBizLog(entity, (HandlerMethod)handler);
        }
        if (request instanceof HttpServletRequest) {
            this.writeRequestToBizLog(entity, (HttpServletRequest)request);
        }
        return entity;
    }

    private BizLogEntity logException(Object request, Object response, Object handler, long cost) {
        BizLogEntity entity = new BizLogEntity();
        entity.setUserid(this.securityMgr.getCurrUser().getId());
        entity.setCost(cost);
        if (handler instanceof HandlerMethod) {
            this.writeHandlerMethodToBizLog(entity, (HandlerMethod)handler);
        }
        if (request instanceof HttpServletRequest) {
            this.writeRequestToBizLog(entity, (HttpServletRequest)request);
        }
        if (response instanceof Exception) {
            Exception ex = (Exception)response;
            entity.setRemark(StringUtils.toLimitLength((String)Exceptions.getStackTraceAsString((Exception)ex), (int)250));
        }
        return entity;
    }

    private void writeHandlerMethodToBizLog(BizLogEntity entity, HandlerMethod method) {
        entity.setMethod(method.getMethod().toString());
        BizLog log = method.getMethod().getAnnotation(BizLog.class);
        if (log != null) {
            entity.setLogType(log.value().toString());
        }
    }

    private void writeRequestToBizLog(BizLogEntity entity, HttpServletRequest request) {
        entity.setUrl(request.getRequestURL().toString());
        String userAgent = request.getHeader("user-agent");
        entity.setOs(this.getClientOS(userAgent));
        entity.setBrowser(this.getBrowser(userAgent));
        entity.setIp(request.getRemoteAddr());
        Enumeration em = request.getParameterNames();
        StringBuilder params = new StringBuilder();
        while (em.hasMoreElements()) {
            String name = (String)em.nextElement();
            String value = request.getParameter(name);
            params.append(name);
            params.append("=");
            params.append(value);
            params.append(";");
        }
        if (params.length() > 250) {
            params.setLength(250);
        }
        entity.setParam(params.toString());
    }

    @Transactional
    private void save(BizLogEntity entity) {
        this.dao.save((Object)entity);
    }

    @Override
    public void setSecurityMgr(SecurityMgr securityMgr) {
        this.securityMgr = securityMgr;
    }

    private String getClientOS(String userAgent) {
        String cos = "unknow os";
        Pattern p = Pattern.compile(".*(Windows NT 6\\.1).*");
        Matcher m = p.matcher(userAgent);
        if (m.find()) {
            cos = "Win 7";
            return cos;
        }
        p = Pattern.compile(".*(Windows NT 5\\.1|Windows XP).*");
        m = p.matcher(userAgent);
        if (m.find()) {
            cos = "WinXP";
            return cos;
        }
        p = Pattern.compile(".*(Windows NT 5\\.2).*");
        m = p.matcher(userAgent);
        if (m.find()) {
            cos = "Win2003";
            return cos;
        }
        p = Pattern.compile(".*(Win2000|Windows 2000|Windows NT 5\\.0).*");
        m = p.matcher(userAgent);
        if (m.find()) {
            cos = "Win2000";
            return cos;
        }
        p = Pattern.compile(".*(Mac|apple|MacOS8).*");
        m = p.matcher(userAgent);
        if (m.find()) {
            cos = "MAC";
            return cos;
        }
        p = Pattern.compile(".*(WinNT|Windows NT).*");
        m = p.matcher(userAgent);
        if (m.find()) {
            cos = "WinNT";
            return cos;
        }
        p = Pattern.compile(".*Linux.*");
        m = p.matcher(userAgent);
        if (m.find()) {
            cos = "Linux";
            return cos;
        }
        p = Pattern.compile(".*(68k|68000).*");
        m = p.matcher(userAgent);
        if (m.find()) {
            cos = "Mac68k";
            return cos;
        }
        p = Pattern.compile(".*(9x 4.90|Win9(5|8)|Windows 9(5|8)|95/NT|Win32|32bit).*");
        m = p.matcher(userAgent);
        if (m.find()) {
            cos = "Win9x";
            return cos;
        }
        return cos;
    }

    private String getBrowser(String userAgent) {
        userAgent = userAgent.toLowerCase();
        String msieP = "msie ([\\d.]+)";
        String firefoxP = "firefox\\/([\\d.]+)";
        String chromeP = "chrome\\/([\\d.]+)";
        String operaP = "opera.([\\d.]+)";
        String safariP = "version\\/([\\d.]+).*safari";
        Pattern pattern = Pattern.compile(msieP);
        Matcher mat = pattern.matcher(userAgent);
        if (mat.find()) {
            return mat.group();
        }
        pattern = Pattern.compile(firefoxP);
        mat = pattern.matcher(userAgent);
        if (mat.find()) {
            return mat.group();
        }
        pattern = Pattern.compile(chromeP);
        mat = pattern.matcher(userAgent);
        if (mat.find()) {
            return mat.group();
        }
        pattern = Pattern.compile(operaP);
        mat = pattern.matcher(userAgent);
        if (mat.find()) {
            return mat.group();
        }
        pattern = Pattern.compile(safariP);
        mat = pattern.matcher(userAgent);
        if (mat.find()) {
            return mat.group();
        }
        return "unknow";
    }
}

