/*
 * Decompiled with CFR 0.152.
 */
package com.xtframe.sec.job.impl;

import com.xtframe.core.job.entity.JobInfo;
import com.xtframe.core.job.service.JobInfoService;
import com.xtframe.sec.common.BaseSecurityService;
import com.xtframe.sec.job.dao.JobInfoDao;
import com.xtframe.sec.job.entity.JobInfoEntity;
import com.xtframe.sec.job.impl.CommonJobListener;
import com.xtframe.sec.log.dao.BizLogDao;
import com.xtframe.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.JobListener;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class JobInfoServiceImpl
extends BaseSecurityService
implements JobInfoService {
    private static final Logger LOG = LoggerFactory.getLogger(JobInfoServiceImpl.class);
    private JobInfoDao dao;
    private Scheduler scheduler = null;
    private JobListener listener = new CommonJobListener();
    private BizLogDao logDao;

    public int addJob(JobInfo jobInfo) {
        TriggerKey triggerKey = TriggerKey.triggerKey((String)jobInfo.getJobName(), (String)jobInfo.getJobGroup());
        CronTrigger trigger = null;
        try {
            trigger = (CronTrigger)this.scheduler.getTrigger(triggerKey);
        }
        catch (SchedulerException e) {
            e.printStackTrace();
        }
        if (trigger == null) {
            Class<?> c = null;
            try {
                c = Class.forName(jobInfo.getClazz());
            }
            catch (Exception e) {
                LOG.error("\u5b9a\u65f6\u4efb\u52a1\u52a0\u8f7d\u7c7b\u627e\u4e0d\u5230:" + jobInfo.getClazz());
                return -1;
            }
            LOG.info("\u52a0\u8f7d\u5b9a\u65f6\u4efb\u52a1:" + jobInfo.getClazz());
            if (Job.class.isAssignableFrom(c)) {
                try {
                    this.addQuartzJob(jobInfo);
                }
                catch (ClassNotFoundException | SchedulerException e) {
                    e.printStackTrace();
                }
            }
        } else {
            try {
                this.scheduler.rescheduleJob(triggerKey, this.getTriggerFromJobInfo(jobInfo));
            }
            catch (SchedulerException e) {
                e.printStackTrace();
            }
        }
        return 0;
    }

    private void addQuartzJob(JobInfo jobInfo) throws ClassNotFoundException, SchedulerException {
        Class<?> c = Class.forName(jobInfo.getClazz());
        if (!Job.class.isAssignableFrom(c)) {
            return;
        }
        JobDetail jobDetail = JobBuilder.newJob(c).withIdentity(jobInfo.getJobName(), jobInfo.getJobGroup()).build();
        jobDetail.getJobDataMap().put("jobInfo", (Object)jobInfo);
        this.scheduler.scheduleJob(jobDetail, this.getTriggerFromJobInfo(jobInfo));
    }

    public String delete(String ... ids) {
        this.dao.delete((Serializable[])ids);
        return null;
    }

    public int deleteJob(JobInfo jobInfo) {
        JobKey jobKey = JobKey.jobKey((String)jobInfo.getJobName(), (String)jobInfo.getJobGroup());
        try {
            this.scheduler.deleteJob(jobKey);
        }
        catch (SchedulerException e) {
            e.printStackTrace();
            return -1;
        }
        return 0;
    }

    public JobInfo findOne(String id) {
        return (JobInfo)this.dao.findOne((Serializable)((Object)id));
    }

    public JobListener getListener() {
        return this.listener;
    }

    private Trigger getTriggerFromJobInfo(JobInfo jobInfo) {
        TriggerBuilder tb = TriggerBuilder.newTrigger().withIdentity(jobInfo.getJobName(), jobInfo.getJobGroup());
        if (StringUtils.isEmpty((Object)jobInfo.getCronExpression())) {
            tb.startAt(jobInfo.getStartTime());
            if (jobInfo.getCircle().booleanValue()) {
                tb.withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInSeconds(jobInfo.getInterval()).repeatForever());
            }
        } else {
            tb.withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)jobInfo.getCronExpression()));
        }
        return tb.build();
    }

    public void init() {
        this.dao = (JobInfoDao)this.getBeans().get("jobInfoDao");
        this.logDao = (BizLogDao)this.getBeans().get("bizLogDao");
        Assert.notNull((Object)this.dao);
    }

    public void initJobs(Object param) {
        if (param instanceof Scheduler) {
            if (this.listener instanceof CommonJobListener) {
                ((CommonJobListener)this.listener).setLogDao(this.logDao);
                ((CommonJobListener)this.listener).setMgr(this.securityMgr);
            }
            this.scheduler = (Scheduler)param;
            try {
                this.scheduler.getListenerManager().addJobListener(this.listener);
            }
            catch (SchedulerException e) {
                e.printStackTrace();
            }
        } else {
            return;
        }
        Scheduler scheduler = (Scheduler)param;
        List<JobInfo> jobs = this.queryAllJob();
        for (JobInfo job : jobs) {
            this.addJob(job);
        }
        try {
            scheduler.start();
        }
        catch (SchedulerException e) {
            e.printStackTrace();
        }
    }

    public int pauseJob(JobInfo jobInfo) {
        JobKey jobKey = JobKey.jobKey((String)jobInfo.getJobName(), (String)jobInfo.getJobGroup());
        try {
            this.scheduler.pauseJob(jobKey);
        }
        catch (SchedulerException e) {
            e.printStackTrace();
            return -1;
        }
        return 0;
    }

    public List<JobInfo> queryAllJob() {
        ArrayList<JobInfo> jobs = new ArrayList<JobInfo>();
        for (JobInfoEntity j : this.dao.findAll()) {
            jobs.add(j);
        }
        return jobs;
    }

    public int resumeJob(JobInfo jobInfo) {
        JobKey jobKey = JobKey.jobKey((String)jobInfo.getJobName(), (String)jobInfo.getJobGroup());
        try {
            this.scheduler.resumeJob(jobKey);
        }
        catch (SchedulerException e) {
            e.printStackTrace();
            return -1;
        }
        return 0;
    }

    public JobInfo save(JobInfo jobInfo) {
        if (jobInfo instanceof JobInfoEntity) {
            return (JobInfo)this.dao.save((Object)((JobInfoEntity)jobInfo));
        }
        return null;
    }

    public void setListener(JobListener listener) {
        this.listener = listener;
    }

    public int triggerJob(JobInfo jobInfo) {
        JobKey jobKey = JobKey.jobKey((String)jobInfo.getJobName(), (String)jobInfo.getJobGroup());
        try {
            this.scheduler.triggerJob(jobKey);
        }
        catch (SchedulerException e) {
            e.printStackTrace();
            return -1;
        }
        return 0;
    }

    public int updateJob(JobInfo jobInfo) {
        Trigger trigger = this.getTriggerFromJobInfo(jobInfo);
        TriggerKey triggerKey = TriggerKey.triggerKey((String)jobInfo.getJobName(), (String)jobInfo.getJobGroup());
        try {
            this.scheduler.rescheduleJob(triggerKey, trigger);
        }
        catch (SchedulerException e) {
            e.printStackTrace();
            return -1;
        }
        return 0;
    }
}

