/*
 * Decompiled with CFR 0.152.
 */
package com.xtframe.sec.job.impl;

import com.xtframe.core.job.entity.JobInfo;
import com.xtframe.core.support.SecurityMgr;
import com.xtframe.sec.log.dao.BizLogDao;
import com.xtframe.sec.log.entity.BizLogEntity;
import java.util.Date;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonJobListener
implements JobListener {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private SecurityMgr mgr = null;
    private BizLogDao logDao;

    public BizLogDao getLogDao() {
        return this.logDao;
    }

    public void setLogDao(BizLogDao logDao) {
        this.logDao = logDao;
    }

    public void setMgr(SecurityMgr mgr) {
        this.mgr = mgr;
    }

    public String getName() {
        return CommonJobListener.class.getSimpleName();
    }

    private JobInfo getJobInfoFromContext(JobExecutionContext context) {
        return (JobInfo)context.getJobDetail().getJobDataMap().get((Object)"jobInfo");
    }

    public void jobToBeExecuted(JobExecutionContext context) {
        JobInfo info = this.getJobInfoFromContext(context);
        info.setStartTime(new Date());
        this.mgr.jobService().save(info);
        BizLogEntity logEntity = new BizLogEntity();
        logEntity.setMethod("com.xtframe.sec.job.impl.CommonJobListener.jobToBeExecuted");
        logEntity.setInsertTime(new Date());
        logEntity.setOs("sys");
        logEntity.setRemark("start job ID:" + info.getId());
        this.logDao.save((Object)logEntity);
        this.logger.debug("jobToBeExecuted:{}", (Object)info.getJobName());
    }

    public void jobExecutionVetoed(JobExecutionContext context) {
        JobInfo info = this.getJobInfoFromContext(context);
        BizLogEntity logEntity = new BizLogEntity();
        logEntity.setMethod("com.xtframe.sec.job.impl.CommonJobListener.jobExecutionVetoed");
        logEntity.setInsertTime(new Date());
        logEntity.setOs("sys");
        logEntity.setRemark("vetoed job ID:" + info.getId());
        this.logDao.save((Object)logEntity);
        this.logger.debug("jobExecutionVetoed:{}", (Object)info.getJobName());
    }

    public void jobWasExecuted(JobExecutionContext context, JobExecutionException jobException) {
        JobInfo info = this.getJobInfoFromContext(context);
        info.setEndTime(new Date());
        this.mgr.jobService().save(info);
        BizLogEntity logEntity = new BizLogEntity();
        logEntity.setMethod("com.xtframe.sec.job.impl.CommonJobListener.jobWasExecuted");
        logEntity.setInsertTime(new Date());
        logEntity.setOs("sys");
        logEntity.setRemark("executed job ID:" + info.getId());
        this.logDao.save((Object)logEntity);
        this.logger.debug("jobWasExecuted:{}", (Object)info.getJobName());
    }
}

