/*
 * Decompiled with CFR 0.152.
 */
package com.xtframe.sec.common;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.xtframe.core.base.ctl.WebJsonResult;
import com.xtframe.core.org.entity.Org;
import com.xtframe.core.support.SecurityMgr;
import com.xtframe.core.support.aware.SecurityMgrAware;
import com.xtframe.core.user.entity.User;
import com.xtframe.core.utils.Assert;
import com.xtframe.util.DateTime;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.web.filter.authc.FormAuthenticationFilter;
import org.apache.shiro.web.util.WebUtils;

public class CaptchaFormAuthenticationFilter
extends FormAuthenticationFilter
implements SecurityMgrAware {
    private SecurityMgr securityMgr;

    protected boolean isLoginSubmission(ServletRequest request, ServletResponse response) {
        return request instanceof HttpServletRequest && WebUtils.toHttp((ServletRequest)request).getMethod().equalsIgnoreCase("POST");
    }

    protected boolean onLoginSuccess(AuthenticationToken token, Subject subject, ServletRequest request, ServletResponse response) throws Exception {
        Object principal = subject.getPrincipal();
        Assert.isInstanceOf(User.class, (Object)principal);
        User u = (User)principal;
        Assert.notNull((Object)u.getOrg(), (String)"\u7528\u6237\u6240\u5728\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Org org = this.securityMgr.orgService().findOne(u.getOrg());
        Assert.notNull((Object)org, (String)"\u7528\u6237\u6240\u5728\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        subject.getSession().setAttribute((Object)"_ORG", (Object)org);
        return super.onLoginSuccess(token, subject, request, response);
    }

    public void setSecurityMgr(SecurityMgr securityMgr) {
        this.securityMgr = securityMgr;
    }

    private boolean isAjaxRequest(HttpServletRequest httpRequest) {
        Assert.notNull((Object)httpRequest);
        String acceptHeader = httpRequest.getHeader("accept");
        if (acceptHeader != null && acceptHeader.indexOf("application/json") > -1) {
            return true;
        }
        String xRequestedWith = httpRequest.getHeader("X-Requested-With");
        return xRequestedWith != null && xRequestedWith.indexOf("XMLHttpRequest") > -1;
    }

    protected boolean onAccessDenied(ServletRequest request, ServletResponse response) throws Exception {
        if (this.isLoginRequest(request, response) || request instanceof HttpServletRequest && !this.isAjaxRequest((HttpServletRequest)request)) {
            return super.onAccessDenied(request, response);
        }
        WebJsonResult res = new WebJsonResult();
        res.setSuccess(false);
        res.setMessage("_redirect_");
        res.setAttr("url", (Object)this.getLoginUrl());
        ObjectMapper mapper = new ObjectMapper();
        mapper.setDateFormat((DateFormat)new SimpleDateFormat(DateTime.DATE_FORMAT_DATETIME));
        try {
            response.getWriter().write(mapper.writeValueAsString((Object)res));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }
}

