/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.client.util;

import java.io.IOException;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.jasig.cas.client.util.CommonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DelegatingFilter
implements Filter {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String requestParameterName;
    private final Map<String, Filter> delegators;
    private final Filter defaultFilter;
    private final boolean exactMatch;

    public DelegatingFilter(String requestParameterName, Map<String, Filter> delegators, boolean exactMatch) {
        this(requestParameterName, delegators, exactMatch, null);
    }

    public DelegatingFilter(String requestParameterName, Map<String, Filter> delegators, boolean exactMatch, Filter defaultFilter) {
        CommonUtils.assertNotNull(requestParameterName, "requestParameterName cannot be null.");
        CommonUtils.assertTrue(!delegators.isEmpty(), "delegators cannot be empty.");
        this.requestParameterName = requestParameterName;
        this.delegators = delegators;
        this.defaultFilter = defaultFilter;
        this.exactMatch = exactMatch;
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        String parameter = CommonUtils.safeGetParameter((HttpServletRequest)request, this.requestParameterName);
        if (CommonUtils.isNotEmpty(parameter)) {
            for (String key : this.delegators.keySet()) {
                if ((!parameter.equals(key) || !this.exactMatch) && (!parameter.matches(key) || this.exactMatch)) continue;
                Filter filter = this.delegators.get(key);
                this.logger.debug("Match found for parameter [{}] with value [{}]. Delegating to filter [{}]", new Object[]{this.requestParameterName, parameter, filter.getClass().getName()});
                filter.doFilter(request, response, filterChain);
                return;
            }
        }
        this.logger.debug("No match found for parameter [{}] with value [{}]", (Object)this.requestParameterName, (Object)parameter);
        if (this.defaultFilter != null) {
            this.defaultFilter.doFilter(request, response, filterChain);
        } else {
            filterChain.doFilter(request, response);
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }
}

