/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.client.util;

import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jasig.cas.client.util.AbstractConfigurationFilter;
import org.jasig.cas.client.util.CommonUtils;

public abstract class AbstractCasFilter
extends AbstractConfigurationFilter {
    public static final String CONST_CAS_ASSERTION = "_const_cas_assertion_";
    private String artifactParameterName = "ticket";
    private String serviceParameterName = "service";
    private boolean encodeServiceUrl = true;
    private String serverName;
    private String service;

    public final void init(FilterConfig filterConfig) throws ServletException {
        if (!this.isIgnoreInitConfiguration()) {
            this.setServerName(this.getPropertyFromInitParams(filterConfig, "serverName", null));
            this.logger.trace("Loading serverName property: {}", (Object)this.serverName);
            this.setService(this.getPropertyFromInitParams(filterConfig, "service", null));
            this.logger.trace("Loading service property: {}", (Object)this.service);
            this.setArtifactParameterName(this.getPropertyFromInitParams(filterConfig, "artifactParameterName", "ticket"));
            this.logger.trace("Loading artifact parameter name property: {}", (Object)this.artifactParameterName);
            this.setServiceParameterName(this.getPropertyFromInitParams(filterConfig, "serviceParameterName", "service"));
            this.logger.trace("Loading serviceParameterName property: {} ", (Object)this.serviceParameterName);
            this.setEncodeServiceUrl(this.parseBoolean(this.getPropertyFromInitParams(filterConfig, "encodeServiceUrl", "true")));
            this.logger.trace("Loading encodeServiceUrl property: {}", (Object)this.encodeServiceUrl);
            this.initInternal(filterConfig);
        }
        this.init();
    }

    protected void initInternal(FilterConfig filterConfig) throws ServletException {
    }

    public void init() {
        CommonUtils.assertNotNull(this.artifactParameterName, "artifactParameterName cannot be null.");
        CommonUtils.assertNotNull(this.serviceParameterName, "serviceParameterName cannot be null.");
        CommonUtils.assertTrue(CommonUtils.isNotEmpty(this.serverName) || CommonUtils.isNotEmpty(this.service), "serverName or service must be set.");
        CommonUtils.assertTrue(CommonUtils.isBlank(this.serverName) || CommonUtils.isBlank(this.service), "serverName and service cannot both be set.  You MUST ONLY set one.");
    }

    public void destroy() {
    }

    protected final String constructServiceUrl(HttpServletRequest request, HttpServletResponse response) {
        return CommonUtils.constructServiceUrl(request, response, this.service, this.serverName, this.artifactParameterName, this.encodeServiceUrl);
    }

    public final void setServerName(String serverName) {
        if (serverName != null && serverName.endsWith("/")) {
            this.serverName = serverName.substring(0, serverName.length() - 1);
            this.logger.info("Eliminated extra slash from serverName [{}].  It is now [{}]", (Object)serverName, (Object)this.serverName);
        } else {
            this.serverName = serverName;
        }
    }

    public final void setService(String service) {
        this.service = service;
    }

    public final void setArtifactParameterName(String artifactParameterName) {
        this.artifactParameterName = artifactParameterName;
    }

    public final void setServiceParameterName(String serviceParameterName) {
        this.serviceParameterName = serviceParameterName;
    }

    public final void setEncodeServiceUrl(boolean encodeServiceUrl) {
        this.encodeServiceUrl = encodeServiceUrl;
    }

    public final String getArtifactParameterName() {
        return this.artifactParameterName;
    }

    public final String getServiceParameterName() {
        return this.serviceParameterName;
    }

    protected String retrieveTicketFromRequest(HttpServletRequest request) {
        return CommonUtils.safeGetParameter(request, this.getArtifactParameterName());
    }
}

