/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context;

import java.lang.reflect.Method;
import org.springframework.context.ApplicationContext;
import org.springframework.core.AttributeAccessorSupport;
import org.springframework.core.style.ToStringCreator;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.BootstrapContext;
import org.springframework.test.context.CacheAwareContextLoaderDelegate;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.TestContextBootstrapper;
import org.springframework.util.Assert;

class DefaultTestContext
extends AttributeAccessorSupport
implements TestContext {
    private static final long serialVersionUID = -5827157174866681233L;
    private final CacheAwareContextLoaderDelegate cacheAwareContextLoaderDelegate;
    private final MergedContextConfiguration mergedContextConfiguration;
    private final Class<?> testClass;
    private Object testInstance;
    private Method testMethod;
    private Throwable testException;

    DefaultTestContext(TestContextBootstrapper testContextBootstrapper) {
        Assert.notNull((Object)testContextBootstrapper, (String)"TestContextBootstrapper must not be null");
        BootstrapContext bootstrapContext = testContextBootstrapper.getBootstrapContext();
        this.testClass = bootstrapContext.getTestClass();
        this.cacheAwareContextLoaderDelegate = bootstrapContext.getCacheAwareContextLoaderDelegate();
        this.mergedContextConfiguration = testContextBootstrapper.buildMergedContextConfiguration();
    }

    @Override
    public ApplicationContext getApplicationContext() {
        return this.cacheAwareContextLoaderDelegate.loadContext(this.mergedContextConfiguration);
    }

    @Override
    public void markApplicationContextDirty(DirtiesContext.HierarchyMode hierarchyMode) {
        this.cacheAwareContextLoaderDelegate.closeContext(this.mergedContextConfiguration, hierarchyMode);
    }

    @Override
    public final Class<?> getTestClass() {
        return this.testClass;
    }

    @Override
    public final Object getTestInstance() {
        return this.testInstance;
    }

    @Override
    public final Method getTestMethod() {
        return this.testMethod;
    }

    @Override
    public final Throwable getTestException() {
        return this.testException;
    }

    @Override
    public void updateState(Object testInstance, Method testMethod, Throwable testException) {
        this.testInstance = testInstance;
        this.testMethod = testMethod;
        this.testException = testException;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("testClass", this.testClass).append("testInstance", this.testInstance).append("testMethod", (Object)this.testMethod).append("testException", (Object)this.testException).append("mergedContextConfiguration", (Object)this.mergedContextConfiguration).toString();
    }
}

