/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.discovery.resource.classes;

import java.net.URL;
import java.util.Vector;
import org.apache.commons.discovery.ResourceClass;
import org.apache.commons.discovery.ResourceClassDiscover;
import org.apache.commons.discovery.ResourceClassIterator;
import org.apache.commons.discovery.log.DiscoveryLogFactory;
import org.apache.commons.discovery.resource.ClassLoaders;
import org.apache.commons.discovery.resource.classes.ResourceClassDiscoverImpl;
import org.apache.commons.logging.Log;

public class DiscoverClasses
extends ResourceClassDiscoverImpl
implements ResourceClassDiscover {
    private static Log log = DiscoveryLogFactory.newLog(class$org$apache$commons$discovery$resource$classes$DiscoverClasses == null ? (class$org$apache$commons$discovery$resource$classes$DiscoverClasses = DiscoverClasses.class$("org.apache.commons.discovery.resource.classes.DiscoverClasses")) : class$org$apache$commons$discovery$resource$classes$DiscoverClasses);
    static /* synthetic */ Class class$org$apache$commons$discovery$resource$classes$DiscoverClasses;

    public static void setLog(Log _log) {
        log = _log;
    }

    public DiscoverClasses() {
    }

    public DiscoverClasses(ClassLoaders classLoaders) {
        super(classLoaders);
    }

    public ResourceClassIterator findResourceClasses(final String className) {
        final String resourceName = className.replace('.', '/') + ".class";
        if (log.isDebugEnabled()) {
            log.debug((Object)("find: className='" + className + "'"));
        }
        return new ResourceClassIterator(){
            private Vector history = new Vector();
            private int idx = 0;
            private ResourceClass resource = null;

            public boolean hasNext() {
                if (this.resource == null) {
                    this.resource = this.getNextClass();
                }
                return this.resource != null;
            }

            public ResourceClass nextResourceClass() {
                ResourceClass element = this.resource;
                this.resource = null;
                return element;
            }

            private ResourceClass getNextClass() {
                while (this.idx < DiscoverClasses.super.getClassLoaders().size()) {
                    ClassLoader loader = DiscoverClasses.super.getClassLoaders().get(this.idx++);
                    URL url = loader.getResource(resourceName);
                    if (url != null) {
                        if (!this.history.contains(url)) {
                            this.history.addElement(url);
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("getNextClass: next URL='" + url + "'"));
                            }
                            return new ResourceClass(className, url, loader);
                        }
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("getNextClass: duplicate URL='" + url + "'"));
                        continue;
                    }
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("getNextClass: loader " + loader + ": '" + resourceName + "' not found"));
                }
                return null;
            }
        };
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

