/*
 * Decompiled with CFR 0.152.
 */
package org.json.tests;

import junit.framework.TestCase;
import org.json.CookieList;
import org.json.JSONException;
import org.json.JSONObject;

public class TestCookieList
extends TestCase {
    JSONObject jsonobject = new JSONObject();

    public void testToJsonObject_RandomCookieList() {
        try {
            this.jsonobject = CookieList.toJSONObject("  f%oo = b+l=ah  ; o;n%40e = t.wo ");
            TestCookieList.assertEquals((String)"{\n  \"o;n@e\": \"t.wo\",\n  \"f%oo\": \"b l=ah\"\n}", (String)this.jsonobject.toString(2));
            TestCookieList.assertEquals((String)"o%3bn@e=t.wo;f%25oo=b l%3dah", (String)CookieList.toString(this.jsonobject));
        }
        catch (JSONException e) {
            TestCookieList.fail((String)e.getMessage());
        }
    }

    public void testToJsonObject_NullKey() {
        try {
            this.jsonobject = CookieList.toJSONObject("  f%oo = b+l=ah  ; o;n%40e = t.wo ");
            this.jsonobject.put("abc", JSONObject.NULL);
            TestCookieList.assertEquals((String)"o%3bn@e=t.wo;f%25oo=b l%3dah", (String)CookieList.toString(this.jsonobject));
        }
        catch (JSONException e) {
            TestCookieList.fail((String)e.getMessage());
        }
    }

    public static void testConstructor() {
        CookieList cookielist = new CookieList();
        TestCookieList.assertEquals((String)"CookieList", (String)cookielist.getClass().getSimpleName());
    }
}

