/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.ehcache.annotations;

import com.googlecode.ehcache.annotations.RefreshableCacheEntry;
import com.googlecode.ehcache.annotations.resolver.ThreadLocalCacheEntryFactory;
import net.sf.ehcache.constructs.blocking.UpdatingCacheEntryFactory;
import org.aopalliance.intercept.MethodInvocation;

public class RefreshingCacheEntryFactory
extends ThreadLocalCacheEntryFactory
implements UpdatingCacheEntryFactory {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateEntryValue(Object key, Object value) throws Exception {
        if (!(value instanceof RefreshableCacheEntry)) {
            throw new IllegalArgumentException(this.getClass().getSimpleName() + " requires cache entries of type " + RefreshableCacheEntry.class.getSimpleName());
        }
        RefreshableCacheEntry refreshableCacheEntry = (RefreshableCacheEntry)value;
        MethodInvocation methodInvocation = refreshableCacheEntry.getMethodInvocation();
        MethodInvocation existingMethodInvocation = (MethodInvocation)this.entryFactory.get();
        try {
            this.entryFactory.set(methodInvocation);
            RefreshableCacheEntry newEntry = (RefreshableCacheEntry)this.createEntry(key);
            refreshableCacheEntry.setValue(newEntry.getValue());
        }
        finally {
            if (existingMethodInvocation == null) {
                this.entryFactory.remove();
            } else {
                this.entryFactory.set(existingMethodInvocation);
            }
        }
    }

    public Object createEntry(Object key) throws Exception {
        MethodInvocation methodInvocation = (MethodInvocation)this.entryFactory.get();
        Object value = super.createEntry(key);
        return new RefreshableCacheEntry(methodInvocation, value);
    }
}

