/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sojo.core.conversion.interceptor;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import net.sf.sojo.core.ConversionContext;
import net.sf.sojo.core.ConversionException;
import net.sf.sojo.core.ConverterInterceptorRecursive;
import net.sf.sojo.core.reflect.ReflectionHelper;

public class SimpleKeyMapperInterceptor
implements ConverterInterceptorRecursive {
    public static final String DELIMITER = "~_-_~";
    private boolean makeSimple = false;

    public SimpleKeyMapperInterceptor() {
    }

    public SimpleKeyMapperInterceptor(boolean pvMakeSimple) {
        this.setMakeSimple(pvMakeSimple);
    }

    public void setMakeSimple(boolean pvMakeSimple) {
        this.makeSimple = pvMakeSimple;
    }

    public boolean getMakeSimple() {
        return this.makeSimple;
    }

    @Override
    public void beforeConvertRecursion(ConversionContext pvContext) {
        if (this.getMakeSimple()) {
            this.toSimple(pvContext);
        }
    }

    @Override
    public Object beforeConvert(Object pvConvertObject, Class<?> pvToType) {
        HashMap<Object, Object> lvReturn = null;
        if (!this.getMakeSimple()) {
            Map lvMap = pvConvertObject;
            HashMap<Object, Object> lvHashMap = new HashMap<Object, Object>(lvMap.size());
            Map<SimpleKeyComparator, Object> lvOrderedMap = this.map2SortedMap(lvMap);
            for (Map.Entry<SimpleKeyComparator, Object> entry : lvOrderedMap.entrySet()) {
                lvHashMap.put(entry.getKey().getKey(), entry.getValue());
            }
            lvReturn = lvHashMap;
        } else {
            lvReturn = pvConvertObject;
        }
        return lvReturn;
    }

    protected void toSimple(ConversionContext pvContext) {
        String lvNewKey = null;
        lvNewKey = pvContext.key instanceof Date ? Long.toString(((Date)pvContext.key).getTime()) : pvContext.key.toString();
        int l = pvContext.key.toString().split(DELIMITER).length;
        lvNewKey = l < 2 ? (pvContext.key.getClass().equals(String.class) ? pvContext.numberOfRecursion + DELIMITER + lvNewKey : pvContext.numberOfRecursion + DELIMITER + lvNewKey + DELIMITER + pvContext.key.getClass().getName()) : pvContext.key.toString();
        pvContext.key = lvNewKey;
    }

    protected SimpleKeyComparator toComplex(Object pvKey) {
        if (!(pvKey instanceof String)) {
            throw new IllegalArgumentException("Expected String, but key is: " + pvKey + " -> class: " + pvKey.getClass().getName());
        }
        String lvKeyStr = (String)pvKey;
        String[] lvKeyArray = lvKeyStr.split(DELIMITER);
        if (lvKeyArray.length < 2) {
            throw new IllegalArgumentException("The key must contains  the delimiter: ~_-_~ - " + lvKeyStr + " (" + lvKeyArray.length + ")");
        }
        String lvPosStr = lvKeyArray[0];
        Integer integer = Integer.valueOf(lvPosStr);
        int lvPos = integer;
        String lvKeyValue = lvKeyArray[1];
        Object lvKey = null;
        if (lvKeyArray.length == 3) {
            String lvKeyClass = lvKeyArray[2];
            try {
                Class<?> clazz = ReflectionHelper.forName(lvKeyClass);
                lvKey = ReflectionHelper.createNewSimpleObject(clazz, lvKeyValue);
            }
            catch (Exception e) {
                throw new ConversionException("Can't create a new instance of class: " + lvKeyClass + " with value: " + lvKeyValue);
            }
        } else {
            lvKey = lvKeyValue;
        }
        return new SimpleKeyComparator(lvPos, lvKey);
    }

    protected Map<SimpleKeyComparator, Object> map2SortedMap(Map<?, ?> pvMap) {
        TreeMap<SimpleKeyComparator, Object> lvTreeMap = new TreeMap<SimpleKeyComparator, Object>(new SimpleKeyComparator());
        for (Map.Entry<?, ?> entry : pvMap.entrySet()) {
            SimpleKeyComparator skc = this.toComplex(entry.getKey());
            lvTreeMap.put(skc, entry.getValue());
        }
        return lvTreeMap;
    }

    @Override
    public void afterConvertRecursion(ConversionContext pvContext) {
    }

    @Override
    public Object afterConvert(Object pvResult, Class<?> pvToType) {
        return pvResult;
    }

    @Override
    public void onError(Exception pvException) {
    }

    private static class SimpleKeyComparator
    implements Comparator<SimpleKeyComparator>,
    Serializable {
        private static final long serialVersionUID = 7181951816535396688L;
        private int pos = -1;
        private Object key;

        public SimpleKeyComparator() {
        }

        public SimpleKeyComparator(int pvPos, Object pvKey) {
            this.pos = pvPos;
            this.key = pvKey;
        }

        public int getPos() {
            return this.pos;
        }

        public Object getKey() {
            return this.key;
        }

        @Override
        public int compare(SimpleKeyComparator pvO1, SimpleKeyComparator pvO2) {
            int res = pvO1.getPos() - pvO2.getPos();
            if (res > 0) {
                return -1;
            }
            if (res == 0) {
                return 0;
            }
            return 1;
        }
    }
}

