/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.ehcache.annotations.key;

import com.googlecode.ehcache.annotations.key.ReflectionHelper;
import com.googlecode.ehcache.annotations.util.guice.FinalizableReference;
import com.googlecode.ehcache.annotations.util.guice.ReferenceMap;
import com.googlecode.ehcache.annotations.util.guice.ReferenceType;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.reflect.Method;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CachingReflectionHelper
implements DisposableBean,
ReflectionHelper {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ReferenceQueue<Object> referenceQueue = new ReferenceQueue();
    private final Map<Class<?>, Set<ImplementsMethod>> implementsCache = new ReferenceMap(ReferenceType.WEAK, ReferenceType.STRONG, this.referenceQueue);
    private final Thread cleanupThread;
    private final AtomicBoolean running = new AtomicBoolean(false);

    public CachingReflectionHelper() {
        this.cleanupThread = new Thread("CachingReflectionHelper_CleanupThread"){

            public void run() {
                while (CachingReflectionHelper.this.running.get()) {
                    try {
                        Reference reference = CachingReflectionHelper.this.referenceQueue.remove();
                        ((FinalizableReference)((Object)reference)).finalizeReferent();
                    }
                    catch (InterruptedException e) {
                    }
                    catch (Throwable t) {
                        CachingReflectionHelper.this.logger.error("Error finalizing reference.", t);
                    }
                }
            }
        };
        this.cleanupThread.setDaemon(true);
    }

    public void setThreadName(String threadName) {
        this.cleanupThread.setName("CachingReflectionHelper_CleanupThread" + (threadName != null ? "-" + threadName : ""));
    }

    private Map<Class<?>, Set<ImplementsMethod>> getCache() {
        if (!this.running.get() && this.running.compareAndSet(false, true)) {
            this.cleanupThread.start();
        }
        return this.implementsCache;
    }

    protected void finalize() throws Throwable {
        this.destroy();
    }

    public void destroy() throws Exception {
        if (this.running.get() && this.running.compareAndSet(true, false)) {
            this.cleanupThread.interrupt();
            try {
                this.cleanupThread.join(1000L);
            }
            catch (InterruptedException e) {
                this.logger.warn("Failed to join the " + this.cleanupThread.getName() + " thread");
            }
        }
    }

    @Override
    public boolean implementsHashCode(Object element) {
        return this.doesImplement(element.getClass(), ImplementsMethod.HASH_CODE);
    }

    @Override
    public boolean implementsEquals(Object element) {
        return this.doesImplement(element.getClass(), ImplementsMethod.EQUALS);
    }

    @Override
    public boolean implementsToString(Object element) {
        return this.doesImplement(element.getClass(), ImplementsMethod.TO_STRING);
    }

    public void clearCache() {
        Map<Class<?>, Set<ImplementsMethod>> cache = this.getCache();
        cache.clear();
    }

    private boolean doesImplement(Class<?> elementClass, ImplementsMethod method) {
        Map<Class<?>, Set<ImplementsMethod>> cache = this.getCache();
        Set<ImplementsMethod> methodCache = cache.get(elementClass);
        if (methodCache == null) {
            methodCache = EnumSet.noneOf(ImplementsMethod.class);
            cache.put(elementClass, methodCache);
            final Set<ImplementsMethod> implementsSet = methodCache;
            ReflectionUtils.doWithMethods(elementClass, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

                public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                    if (implementsSet.size() == 3 || method.getDeclaringClass() == Object.class) {
                        return;
                    }
                    if (ReflectionUtils.isEqualsMethod((Method)method)) {
                        implementsSet.add(ImplementsMethod.EQUALS);
                    } else if (ReflectionUtils.isHashCodeMethod((Method)method)) {
                        implementsSet.add(ImplementsMethod.HASH_CODE);
                    } else if (ReflectionUtils.isToStringMethod((Method)method)) {
                        implementsSet.add(ImplementsMethod.TO_STRING);
                    }
                }
            });
        }
        return methodCache.contains((Object)method);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ImplementsMethod {
        HASH_CODE,
        EQUALS,
        TO_STRING;

    }
}

