/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.Charset;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetDeletedEvent;
import com.supermap.data.DatasetGroup;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.Datasets;
import com.supermap.data.DatasourceConnectionInfo;
import com.supermap.data.DatasourceDisconnectedEvent;
import com.supermap.data.DatasourceDisconnectedListener;
import com.supermap.data.DatasourceNative;
import com.supermap.data.DatasourceRefreshedEvent;
import com.supermap.data.DatasourceRefreshedListener;
import com.supermap.data.Datasources;
import com.supermap.data.DomainManager;
import com.supermap.data.DynamicSegmentManager;
import com.supermap.data.EncodeType;
import com.supermap.data.EngineType;
import com.supermap.data.Enum;
import com.supermap.data.InternalHandle;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.PrjCoordSys;
import com.supermap.data.Recordset;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedListener;
import com.supermap.data.TextStyle;
import com.supermap.data.Toolkit;
import com.supermap.data.Unit;
import com.supermap.data.VersionManager;
import com.supermap.data.Workspace;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventObject;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.Timer;

public class Datasource
extends InternalHandle {
    private Workspace _$13;
    private Datasets _$12;
    private DatasourceConnectionInfo _$11;
    private PrjCoordSys _$10;
    private VersionManager _$9;
    private DynamicSegmentManager _$8;
    private static Timer _$7 = new Timer(5000, null);
    ActionListener m_Listener = null;
    boolean m_connected = true;
    private transient CopyOnWriteArrayList<DatasourceDisconnectedListener> _$6;
    private transient CopyOnWriteArrayList<DatasourceRefreshedListener> _$5;
    private static Integer _$4 = new Integer(0);
    transient CopyOnWriteArrayList<SteppedListener> m_steppedListeners;
    protected static String m_senderMethodName;
    protected long m_selfEventHandle;
    private DatasetGroup _$3;
    private DomainManager _$2;

    protected Datasource() {
    }

    public Datasource(EngineType engineType) {
        int n = engineType.value();
        long l = DatasourceNative.jni_New(this.getHandle(), n);
        this.setHandle(l);
        l = DatasourceNative.jni_GetConnectionInfo(this.getHandle());
        this._$11 = new DatasourceConnectionInfo(this, l);
        this._$12 = new Datasets(this);
        l = DatasourceNative.jni_GetPrjCoordSys(this.getHandle());
        this._$10 = new PrjCoordSys(l, false);
        this.m_selfEventHandle = DatasourceNative.jni_NewSelfEventHandle(this);
        if (this.m_Listener == null) {
            this.m_Listener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (!Datasource.this.connect()) {
                        DatasourceDisconnectedEvent datasourceDisconnectedEvent = new DatasourceDisconnectedEvent(this, Datasource.this);
                        if (Datasource.this.m_connected) {
                            Datasource.this.fireDisconnected(datasourceDisconnectedEvent);
                            Datasource.this.m_connected = false;
                        }
                    } else {
                        Datasource.this.m_connected = true;
                    }
                }
            };
        }
        _$7.addActionListener(this.m_Listener);
    }

    public boolean open(DatasourceConnectionInfo datasourceConnectionInfo) {
        if (this._$13 != null) {
            Datasources datasources = this._$13.getDatasources();
            datasources.open(datasourceConnectionInfo);
            return true;
        }
        this._$11 = datasourceConnectionInfo;
        boolean bl = DatasourceNative.jni_Open(this.getHandle(), this._$11.getHandle());
        if (bl) {
            this._$12.reset();
            return true;
        }
        return false;
    }

    public void close() {
        if (this._$13 != null) {
            Datasources datasources = this._$13.getDatasources();
            String string = this.getAlias();
            datasources.close(string);
        } else {
            DatasourceNative.jni_Close(this.getHandle());
            this.clearHandle();
        }
    }

    Datasource(long l, Workspace workspace) {
        if (l == 0L) {
            String string = InternalResource.loadString("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (workspace == null || workspace.getHandle() == 0L) {
            String string = InternalResource.loadString("workspace", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this._$13 = workspace;
        this.setHandle(l);
        long l2 = DatasourceNative.jni_GetConnectionInfo(this.getHandle());
        this._$11 = new DatasourceConnectionInfo(this, l2);
        this._$12 = new Datasets(this);
        l2 = DatasourceNative.jni_GetPrjCoordSys(this.getHandle());
        this._$10 = new PrjCoordSys(l2, false);
        this.m_selfEventHandle = DatasourceNative.jni_NewSelfEventHandle(this);
        if (this.m_Listener == null) {
            this.m_Listener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (!Datasource.this.connect()) {
                        DatasourceDisconnectedEvent datasourceDisconnectedEvent = new DatasourceDisconnectedEvent(this, Datasource.this);
                        if (Datasource.this.m_connected) {
                            Datasource.this.fireDisconnected(datasourceDisconnectedEvent);
                            Datasource.this.m_connected = false;
                        }
                    } else {
                        Datasource.this.m_connected = true;
                    }
                }
            };
        }
        _$7.addActionListener(this.m_Listener);
        InternalHandleDisposable.makeSureNativeObjectLive(workspace);
    }

    protected static Datasource createInstance(long l, Workspace workspace) {
        return new Datasource(l, workspace);
    }

    public String getAlias() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasourceNative.jni_GetAlias(this.getHandle());
    }

    public static int getConnectCheckInterval() {
        return _$7.getDelay();
    }

    public static void setConnectCheckInterval(int n) {
        _$7.setDelay(n);
    }

    public boolean isConnected() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasourceNative.jni_GetIsConnected(this.getHandle());
    }

    public boolean isOpened() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasourceNative.jni_GetIsOpened(this.getHandle());
    }

    public boolean isAutoConnect() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasourceNative.jni_GetIsAutoConnected(this.getHandle());
    }

    public void setAutoConnect(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        DatasourceNative.jni_SetIsAutoConnected(this.getHandle(), bl);
    }

    public DatasourceConnectionInfo getConnectionInfo() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this._$11;
    }

    public Datasets getDatasets() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this._$12;
    }

    public String getDescription() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasourceNative.jni_GetDescription(this.getHandle());
    }

    public void setDescription(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null) {
            string = "";
        }
        DatasourceNative.jni_SetDescription(this.getHandle(), string);
    }

    public EngineType getEngineType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        String string = this._$11.getServer();
        if (string.compareToIgnoreCase(":memroy:") == 0) {
            return EngineType.MEMORY;
        }
        return this._$11.getEngineType();
    }

    public boolean isModified() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasourceNative.jni_GetIsModified(this.getHandle());
    }

    public PrjCoordSys getPrjCoordSys() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this._$10;
    }

    public void setPrjCoordSys(PrjCoordSys prjCoordSys) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (prjCoordSys == null || prjCoordSys.getHandle() == 0L) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        DatasourceNative.jni_SetPrjCoordSys(this.getHandle(), prjCoordSys.getHandle());
        InternalHandleDisposable.makeSureNativeObjectLive(prjCoordSys);
    }

    public Unit getCoordUnit() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCoordUnit()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = DatasourceNative.jni_GetCoordUnit(this.getHandle());
        return (Unit)Enum.parseUGCValue(Unit.class, n);
    }

    public void setCoordUnit(Unit unit) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCoordUnit(Unit value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (unit == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = unit.getUGCValue();
        DatasourceNative.jni_SetCoordUnit(this.getHandle(), n);
    }

    public Unit getDistanceUnit() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDistanceUnit()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = DatasourceNative.jni_GetDistanceUnit(this.getHandle());
        return (Unit)Enum.parseUGCValue(Unit.class, n);
    }

    public void setDistanceUnit(Unit unit) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDistanceUnit(Unit value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (unit == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = unit.getUGCValue();
        DatasourceNative.jni_SetDistanceUnit(this.getHandle(), n);
    }

    public boolean isReadOnly() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasourceNative.jni_GetIsReadOnly(this.getHandle());
    }

    public boolean isUnicodeSupported() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasourceNative.jni_GetIsSupportUnicode(this.getHandle());
    }

    public Workspace getWorkspace() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this._$13;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean connect() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = false;
        Workspace workspace = this._$13;
        synchronized (workspace) {
            Integer n = _$4;
            synchronized (n) {
                if (this.isConnected()) {
                    return true;
                }
                bl = DatasourceNative.jni_Connect(this.getHandle());
                if (bl) {
                    this._$12 = new Datasets(this);
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dataset copyDataset(Dataset dataset, String string, EncodeType encodeType) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (this.isReadOnly()) {
            String string3 = InternalResource.loadString("", "Datasource_TheDatasourceIsReadOnly", "data_resources");
            throw new IllegalStateException(string3);
        }
        if (dataset == null || dataset.getHandle() == 0L) {
            String string4 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string4);
        }
        if (string == null || string.trim().length() == 0) {
            String string5 = InternalResource.loadString("desDatasetName", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string5);
        }
        if (!this.getDatasets().isAvailableDatasetName(string)) {
            String string6 = InternalResource.loadString("desDatasetName", "Datasource_DatasetNameIsInvalid", "data_resources");
            throw new IllegalArgumentException(string6);
        }
        if (!Toolkit.isValidEncodeType(Dataset.isVector(dataset), encodeType)) {
            String string7 = InternalResource.loadString("encodeType", "Global_UnsupportedEncodeType", "data_resources");
            throw new IllegalArgumentException(string7);
        }
        Integer n = _$4;
        synchronized (n) {
            int n2 = encodeType.getUGCValue();
            if (dataset.getType().equals(DatasetType.CAD)) {
                n2 = 0;
            }
            m_senderMethodName = "copyDataset";
            this.m_selfEventHandle = DatasourceNative.jni_NewSelfEventHandle(this);
            long l = DatasourceNative.jni_CopyDataset(this.getHandle(), dataset.getHandle(), string, n2, this.m_selfEventHandle);
            if (l == 0L) {
                return null;
            }
            Dataset dataset2 = Dataset.createInstance(l, dataset.getType(), this);
            this._$12.add(dataset2);
            return dataset2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dataset copyDataset(Dataset dataset, String string, EncodeType encodeType, Charset charset) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (this.isReadOnly()) {
            String string3 = InternalResource.loadString("", "Datasource_TheDatasourceIsReadOnly", "data_resources");
            throw new IllegalStateException(string3);
        }
        if (dataset == null || dataset.getHandle() == 0L) {
            String string4 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string4);
        }
        if (string == null || string.trim().length() == 0) {
            String string5 = InternalResource.loadString("desDatasetName", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string5);
        }
        if (!this.getDatasets().isAvailableDatasetName(string)) {
            String string6 = InternalResource.loadString("desDatasetName", "Datasource_DatasetNameIsInvalid", "data_resources");
            throw new IllegalArgumentException(string6);
        }
        if (!Toolkit.isValidEncodeType(Dataset.isVector(dataset), encodeType)) {
            String string7 = InternalResource.loadString("encodeType", "Global_UnsupportedEncodeType", "data_resources");
            throw new IllegalArgumentException(string7);
        }
        Integer n = _$4;
        synchronized (n) {
            int n2 = encodeType.getUGCValue();
            if (dataset.getType().equals(DatasetType.CAD)) {
                n2 = 0;
            }
            int n3 = charset.getUGCValue();
            m_senderMethodName = "copyDataset";
            this.m_selfEventHandle = DatasourceNative.jni_NewSelfEventHandle(this);
            long l = DatasourceNative.jni_CopyDataset2(this.getHandle(), dataset.getHandle(), string, n2, n3, this.m_selfEventHandle);
            if (l == 0L) {
                return null;
            }
            Dataset dataset2 = Dataset.createInstance(l, dataset.getType(), this);
            this._$12.add(dataset2);
            return dataset2;
        }
    }

    public DatasetVector innerPointToDataset(DatasetVector datasetVector, String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (this.isReadOnly()) {
            String string3 = InternalResource.loadString("", "Datasource_TheDatasourceIsReadOnly", "data_resources");
            throw new IllegalStateException(string3);
        }
        if (datasetVector.getType().equals(DatasetType.TABULAR) || datasetVector.getType().equals(DatasetType.LINKTABLE)) {
            String string4 = InternalResource.loadString("innerPointToDataset", "Datasource_DatasetHasNoInnerPoint", "data_resources");
            throw new UnsupportedOperationException(string4);
        }
        if (string == null || string.trim().length() == 0) {
            String string5 = InternalResource.loadString("desDatasetName", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string5);
        }
        if (!this.getDatasets().isAvailableDatasetName(string)) {
            String string6 = InternalResource.loadString("desDatasetName", "Datasource_DatasetNameIsInvalid", "data_resources");
            throw new IllegalArgumentException(string6);
        }
        long l = DatasourceNative.jni_InnerPointToDataset(this.getHandle(), datasetVector.getHandle(), string);
        if (l == 0L) {
            return null;
        }
        DatasetVector datasetVector2 = new DatasetVector(l, this);
        this.getDatasets().add(datasetVector2);
        return datasetVector2;
    }

    public DatasetVector fieldToPointDataset(DatasetVector datasetVector, String string, String string2, String string3) {
        if (this.getHandle() == 0L) {
            String string4 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string4);
        }
        if (this.isReadOnly()) {
            String string5 = InternalResource.loadString("", "Datasource_TheDatasourceIsReadOnly", "data_resources");
            throw new IllegalStateException(string5);
        }
        if (datasetVector == null || datasetVector.getHandle() == 0L) {
            String string6 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string6);
        }
        if (string == null || string.trim().equals("")) {
            String string7 = InternalResource.loadString("desDatasetName", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string7);
        }
        if (!this.getDatasets().isAvailableDatasetName(string)) {
            String string8 = InternalResource.loadString("desDatasetName", "Datasource_DatasetNameIsInvalid", "data_resources");
            throw new IllegalArgumentException(string8);
        }
        if (string2 == null || string2.trim().equals("")) {
            String string9 = InternalResource.loadString("fieldX", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string9);
        }
        if (string3 == null || string3.trim().equals("")) {
            String string10 = InternalResource.loadString("fieldY", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string10);
        }
        if (datasetVector.getFieldInfos().indexOf(string2) == -1) {
            String string11 = InternalResource.loadString("fieldX", "Datasource_FieldIsNotExist", "data_resources");
            throw new IllegalArgumentException(string11);
        }
        if (datasetVector.getFieldInfos().indexOf(string3) == -1) {
            String string12 = InternalResource.loadString("fieldY", "Datasource_FieldIsNotExist", "data_resources");
            throw new IllegalArgumentException(string12);
        }
        long l = DatasourceNative.jni_FieldToPointDataset(this.getHandle(), datasetVector.getHandle(), string, string2, string3);
        if (l == 0L) {
            return null;
        }
        DatasetVector datasetVector2 = new DatasetVector(l, this);
        this._$12.add(datasetVector2);
        return datasetVector2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatasetVector labelToTextDataset(DatasetVector datasetVector, String string, String string2, TextStyle textStyle) {
        if (this.getHandle() == 0L) {
            String string3 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string3);
        }
        if (this.isReadOnly()) {
            String string4 = InternalResource.loadString("", "Datasource_TheDatasourceIsReadOnly", "data_resources");
            throw new IllegalStateException(string4);
        }
        if (datasetVector.getType().equals(DatasetType.TABULAR) || datasetVector.getType().equals(DatasetType.LINKTABLE)) {
            String string5 = InternalResource.loadString("labelToTextDataset", "Datasource_DatasetHasNoInnerPoint", "data_resources");
            throw new UnsupportedOperationException(string5);
        }
        if (string2 == null || string2.trim().equals("")) {
            String string6 = InternalResource.loadString("textField", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string6);
        }
        if (string == null || string.trim().length() == 0) {
            String string7 = InternalResource.loadString("desDatasetName", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string7);
        }
        if (!this.getDatasets().isAvailableDatasetName(string)) {
            String string8 = InternalResource.loadString("desDatasetName", "Datasource_DatasetNameIsInvalid", "data_resources");
            throw new IllegalArgumentException(string8);
        }
        Integer n = _$4;
        synchronized (n) {
            long l;
            long l2 = 0L;
            if (textStyle != null) {
                l2 = textStyle.getHandle();
            }
            if ((l = DatasourceNative.jni_LabelToTextDataset(this.getHandle(), datasetVector.getHandle(), string, string2, l2)) == 0L) {
                return null;
            }
            DatasetVector datasetVector2 = new DatasetVector(l, this);
            this._$12.add(datasetVector2);
            InternalHandleDisposable.makeSureNativeObjectLive(textStyle);
            return datasetVector2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatasetVector recordsetToDataset(Recordset recordset, String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (this.isReadOnly()) {
            String string3 = InternalResource.loadString("", "Datasource_TheDatasourceIsReadOnly", "data_resources");
            throw new IllegalStateException(string3);
        }
        if (recordset == null || recordset.getHandle() == 0L) {
            String string4 = InternalResource.loadString("recordset", "Global_ArgumentNull", "data_resources");
            throw new IllegalStateException(string4);
        }
        if (string == null || string.trim().length() == 0) {
            String string5 = InternalResource.loadString("desDatasetName", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string5);
        }
        if (!this.getDatasets().isAvailableDatasetName(string)) {
            String string6 = InternalResource.loadString("desDatasetName", "Datasource_DatasetNameIsInvalid", "data_resources");
            throw new IllegalArgumentException(string6);
        }
        long l = DatasourceNative.jni_RecordsetToDataset(this.getHandle(), recordset.getHandle(), string);
        if (l == 0L) {
            InternalHandleDisposable.makeSureNativeObjectLive(recordset);
            return null;
        }
        DatasetVector datasetVector = new DatasetVector(l, this);
        Integer n = _$4;
        synchronized (n) {
            this._$12.add(datasetVector);
            InternalHandleDisposable.makeSureNativeObjectLive(recordset);
            return datasetVector;
        }
    }

    public VersionManager getVersionManager() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        EngineType engineType = this.getEngineType();
        if ((engineType.equals(EngineType.ORACLEPLUS) || engineType.equals(EngineType.SQLPLUS)) && this._$9 == null && (l = DatasourceNative.jni_GetVersionManager(this.getHandle())) != 0L) {
            this._$9 = new VersionManager(l, this);
        }
        return this._$9;
    }

    public DomainManager getDomainManager() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this._$2 == null && (l = DatasourceNative.jni_GetDomainManager(this.getHandle())) != 0L) {
            this._$2 = new DomainManager(l, this);
        }
        return this._$2;
    }

    public boolean changePassword(String string, String string2) {
        if (this.getHandle() == 0L) {
            String string3 = InternalResource.loadString("changePassword(String oldPassword, String newPassword)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string3);
        }
        if (string == null || string2 == null) {
            String string4 = InternalResource.loadString("password", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string4);
        }
        String string5 = this.getConnectionInfo().getPassword();
        boolean bl = false;
        if (string.equals(string5)) {
            bl = DatasourceNative.jni_ChangePassword(this.getHandle(), string2);
        }
        return bl;
    }

    public boolean createSequence(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("getCoordUnit()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        return DatasourceNative.jni_CreateSequence(this.getHandle(), string);
    }

    public boolean createSequence(String string, long l, long l2, int n) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("getCoordUnit()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        return DatasourceNative.jni_CreateSequence1(this.getHandle(), string, l, l2, n);
    }

    public long getSequenceNextValue(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("getCoordUnit()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        String string3 = DatasourceNative.jni_GetSequenceNextValue(this.getHandle(), string);
        if (null == string3) {
            String string4 = "";
            string4 = false == this.isSequenceExist(string) ? InternalResource.loadString("", "Sequence_Not_Exist", "data_resources") : InternalResource.loadString("", "Sequence_Is_MAX", "data_resources");
            throw new IllegalStateException(string4);
        }
        long l = Long.parseLong(string3);
        return l;
    }

    public boolean deleteSequence(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("getCoordUnit()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        return DatasourceNative.jni_DeleteSequence(this.getHandle(), string);
    }

    public boolean isSequenceExist(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("getCoordUnit()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        return DatasourceNative.jni_IsSequenceExist(this.getHandle(), string);
    }

    public boolean executeSQL(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null || string.trim().length() == 0) {
            String string3 = InternalResource.loadString("sql", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string3);
        }
        return DatasourceNative.jni_ExecuteSQL(this.getHandle(), string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.getEngineType() == EngineType.UDB || this.getEngineType() == EngineType.MEMORY) {
            return;
        }
        Integer n = _$4;
        synchronized (n) {
            int[] nArray = new int[2];
            String[] stringArray = DatasourceNative.jni_Refresh(this.getHandle(), nArray, this.m_selfEventHandle);
            if (nArray[1] > 0) {
                String[] stringArray2 = new String[nArray[1]];
                for (int i = 0; i < stringArray2.length; ++i) {
                    stringArray2[i] = stringArray[nArray[0] + i];
                }
                this.getDatasets().addRange(stringArray2);
            }
        }
    }

    public boolean flush(String string) {
        Dataset dataset;
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null) {
            String string3 = InternalResource.loadString("datasetName", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string3);
        }
        if (string.trim().length() != 0 && (dataset = this._$12.get(string)) == null) {
            String string4 = InternalResource.loadString("datasetName", "Global_SpecifiedNameNotExist", "data_resources");
            throw new IllegalArgumentException(string4);
        }
        return DatasourceNative.jni_Flush(this.getHandle(), string);
    }

    private int _$1(String[] stringArray, String string) {
        int n = -1;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equalsIgnoreCase(string)) continue;
            n = i;
            break;
        }
        return n;
    }

    protected void clearHandle() {
        this._$13 = null;
        this._$12.clearHandle();
        this._$12 = null;
        this._$11.clearHandle();
        this._$11 = null;
        this.clearSelfEventHandle();
        if (this._$9 != null) {
            this._$9.clearHandle();
            this._$9 = null;
        }
        if (this._$8 != null) {
            this._$8.clearHandle();
            this._$8 = null;
        }
        if (this.m_Listener != null) {
            _$7.removeActionListener(this.m_Listener);
            this.m_Listener = null;
            if (_$7.getActionListeners().length == 0) {
                _$7.stop();
            }
        }
        this.setHandle(0L);
    }

    protected void clearSelfEventHandle() {
        if (this.m_selfEventHandle != 0L) {
            DatasourceNative.jni_DeleteSelfEventHandle(this.m_selfEventHandle);
            this.m_selfEventHandle = 0L;
        }
    }

    public synchronized void addDisconnectedListener(DatasourceDisconnectedListener datasourceDisconnectedListener) {
        if (this._$6 == null) {
            this._$6 = new CopyOnWriteArrayList();
        }
        if (!this._$6.contains(datasourceDisconnectedListener)) {
            this._$6.add(datasourceDisconnectedListener);
        }
        if (!_$7.isRunning()) {
            _$7.start();
        }
    }

    public void removeDisconnectedListener(DatasourceDisconnectedListener datasourceDisconnectedListener) {
        if (this._$6 != null && this._$6.contains(datasourceDisconnectedListener)) {
            this._$6.remove(datasourceDisconnectedListener);
        }
    }

    protected void fireDisconnected(DatasourceDisconnectedEvent datasourceDisconnectedEvent) {
        if (this._$6 != null) {
            CopyOnWriteArrayList<DatasourceDisconnectedListener> copyOnWriteArrayList = this._$6;
            for (DatasourceDisconnectedListener datasourceDisconnectedListener : copyOnWriteArrayList) {
                datasourceDisconnectedListener.datasourceDisconnected(datasourceDisconnectedEvent);
            }
        }
    }

    public synchronized void addRefreshedListener(DatasourceRefreshedListener datasourceRefreshedListener) {
        if (this._$5 == null) {
            this._$5 = new CopyOnWriteArrayList();
        }
        if (!this._$5.contains(datasourceRefreshedListener)) {
            this._$5.add(datasourceRefreshedListener);
        }
        if (!_$7.isRunning()) {
            _$7.start();
        }
    }

    public void removeRefreshedListener(DatasourceRefreshedListener datasourceRefreshedListener) {
        if (this._$5 != null && this._$5.contains(datasourceRefreshedListener)) {
            this._$5.remove(datasourceRefreshedListener);
        }
        if (this._$5.size() == 0) {
            _$7.stop();
        }
    }

    protected void fireRefreshed(DatasourceRefreshedEvent datasourceRefreshedEvent) {
        if (this._$5 != null) {
            CopyOnWriteArrayList<DatasourceRefreshedListener> copyOnWriteArrayList = this._$5;
            for (DatasourceRefreshedListener datasourceRefreshedListener : copyOnWriteArrayList) {
                datasourceRefreshedListener.datasourceRefreshed(datasourceRefreshedEvent);
            }
        }
    }

    static void refreshDatasourceCallBack(Datasource datasource, String string) {
        if (datasource != null) {
            EventObject eventObject;
            Datasets datasets = datasource.getDatasets();
            int n = datasets.indexOf(string);
            if (n != -1) {
                datasets.getList().remove(n);
                eventObject = new DatasetDeletedEvent(datasets, string);
                datasets.fireDeleted((DatasetDeletedEvent)eventObject);
            }
            eventObject = new DatasourceRefreshedEvent(datasource, datasource);
            datasource.fireRefreshed((DatasourceRefreshedEvent)eventObject);
        }
    }

    public synchronized void addSteppedListener(SteppedListener steppedListener) {
        if (this.m_steppedListeners == null) {
            this.m_steppedListeners = new CopyOnWriteArrayList();
        }
        if (!this.m_steppedListeners.contains(steppedListener)) {
            this.m_steppedListeners.add(steppedListener);
        }
    }

    public void removeSteppedListener(SteppedListener steppedListener) {
        if (this.m_steppedListeners != null && this.m_steppedListeners.contains(steppedListener)) {
            this.m_steppedListeners.remove(steppedListener);
        }
    }

    protected void fireStepped(SteppedEvent steppedEvent) {
        if (this.m_steppedListeners != null) {
            CopyOnWriteArrayList<SteppedListener> copyOnWriteArrayList = this.m_steppedListeners;
            for (SteppedListener steppedListener : copyOnWriteArrayList) {
                steppedListener.stepped(steppedEvent);
            }
        }
    }

    static void steppedCallBack(Datasource datasource, int n, long l, String string, String string2) {
        if (datasource != null) {
            SteppedEvent steppedEvent = new SteppedEvent(datasource, n, l, string, string2, m_senderMethodName);
            datasource.fireStepped(steppedEvent);
        }
    }

    static boolean compareDatasources(Datasource datasource, Datasource datasource2) {
        boolean bl = false;
        DatasourceConnectionInfo datasourceConnectionInfo = datasource.getConnectionInfo();
        DatasourceConnectionInfo datasourceConnectionInfo2 = datasource2.getConnectionInfo();
        if (datasourceConnectionInfo.getEngineType().equals(datasourceConnectionInfo2.getEngineType()) && datasourceConnectionInfo.getServer().equals(datasourceConnectionInfo2.getServer()) && datasourceConnectionInfo.getDatabase().equals(datasourceConnectionInfo2.getDatabase()) && datasourceConnectionInfo.getUser().equals(datasourceConnectionInfo2.getUser())) {
            bl = true;
        }
        return bl;
    }

    protected static void refresh(Datasource datasource) {
        datasource.getDatasets().refresh();
        DatasetGroup datasetGroup = datasource.getRootGroup();
        if (datasetGroup != null) {
            datasetGroup.getChildGroups().refreshManagedItem();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDataset() {
        Integer n = _$4;
        synchronized (n) {
            int n2 = DatasourceNative.jni_GetDatasetsCount(this.getHandle());
            long[] lArray = new long[n2];
            int[] nArray = new int[n2];
            DatasourceNative.jni_GetDatasets(this.getHandle(), lArray, nArray);
            DatasetType datasetType = (DatasetType)Enum.parseUGCValue(DatasetType.class, nArray[n2 - 1]);
            try {
                Dataset dataset = Dataset.createInstance(lArray[n2 - 1], datasetType, this);
                if (dataset != null) {
                    this.getDatasets().add(dataset);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public DatasetGroup getRootGroup() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this._$3 == null && (l = DatasourceNative.jni_GetRootGroupHandle(this.getHandle())) != 0L) {
            this._$3 = new DatasetGroup(l, this, null);
        }
        return this._$3;
    }
}

