/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.BlockSizeOption;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetImage;
import com.supermap.data.DatasetImageInfoNative;
import com.supermap.data.EncodeType;
import com.supermap.data.Enum;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalInvalidState;
import com.supermap.data.InternalResource;
import com.supermap.data.PixelFormat;
import com.supermap.data.Rectangle2D;
import com.supermap.data.Toolkit;

public class DatasetImageInfo
extends InternalHandleDisposable {
    public DatasetImageInfo() {
        this.setHandle(DatasetImageInfoNative.jni_New(1), true);
        this.reset();
    }

    public DatasetImageInfo(DatasetImageInfo datasetImageInfo) {
        if (datasetImageInfo == null) {
            String string = InternalResource.loadString("datasetImageInfo", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (datasetImageInfo.getHandle() == 0L) {
            String string = InternalResource.loadString("datasetImageInfo", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = DatasetImageInfoNative.jni_Clone(datasetImageInfo.getHandle());
        this.setHandle(l, true);
        InternalHandleDisposable.makeSureNativeObjectLive(datasetImageInfo);
    }

    public DatasetImageInfo(String string, int n, int n2, PixelFormat pixelFormat, EncodeType encodeType, BlockSizeOption blockSizeOption, int n3) {
        if (string == null || string.trim().length() == 0) {
            String string2 = InternalResource.loadString("name", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string2);
        }
        if (pixelFormat == null) {
            String string3 = InternalResource.loadString("pixelFormat", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string3);
        }
        if (encodeType == null) {
            String string4 = InternalResource.loadString("encodeType", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string4);
        }
        this.setHandle(DatasetImageInfoNative.jni_New(n3), true);
        this.reset();
        this.setName(string);
        this.setWidth(n);
        this.setHeight(n2);
        this.setPixelFormat(pixelFormat);
        this.setBlockSizeOption(blockSizeOption);
        this.setEncodeType(encodeType);
    }

    public DatasetImageInfo(String string, DatasetImage datasetImage) {
        if (datasetImage == null) {
            String string2 = InternalResource.loadString("templateDataset", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string2);
        }
        long l = datasetImage.getHandle();
        if (l == 0L) {
            String string3 = InternalResource.loadString("templateDataset", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string3);
        }
        long l2 = DatasetImageInfoNative.jni_New2(l);
        this.setHandle(l2, true);
        this.setName(string);
    }

    public String getName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetImageInfoNative.jni_GetName(this.getHandle());
    }

    public void setName(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null || string.trim().length() == 0) {
            String string3 = InternalResource.loadString("value", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string3);
        }
        InternalInvalidState internalInvalidState = Dataset.isValidDatasetName(string);
        if (internalInvalidState != null) {
            String string4 = "";
            if (internalInvalidState.equals(InternalInvalidState.ISEMPTY)) {
                string4 = "Dataset_NameIsEmpty";
            } else if (internalInvalidState.equals(InternalInvalidState.AGAINSYSTEMNAME)) {
                string4 = "Dataset_NameAgainstSys";
            } else if (internalInvalidState.equals(InternalInvalidState.BEYONDLIMIT)) {
                string4 = "Dataset_NameBeyondLimit";
            } else if (internalInvalidState.equals(InternalInvalidState.INVALIDCHAR)) {
                string4 = "Dataset_NameIncludeInvalidChar";
            } else if (internalInvalidState.equals(InternalInvalidState.PREFIXERROR)) {
                string4 = "Dataset_NameErrorPrefix";
            }
            String string5 = InternalResource.loadString("value", string4, "data_resources");
            throw new IllegalArgumentException(string5);
        }
        DatasetImageInfoNative.jni_SetName(this.getHandle(), string);
    }

    public int getBandCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetImageInfoNative.jni_GetBandCount(this.getHandle());
    }

    public void setBandCount(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0) {
            String string = InternalResource.loadString("value", "DatasetImage_WidthShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        DatasetImageInfoNative.jni_SetBandCount(this.getHandle(), n);
    }

    public Rectangle2D getBounds() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[4];
        DatasetImageInfoNative.jni_GetBounds(this.getHandle(), dArray);
        return new Rectangle2D(dArray[0], dArray[1], dArray[2], dArray[3]);
    }

    public void setBounds(Rectangle2D rectangle2D) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (rectangle2D == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        DatasetImageInfoNative.jni_SetBounds(this.getHandle(), rectangle2D.getLeft(), rectangle2D.getBottom(), rectangle2D.getRight(), rectangle2D.getTop());
    }

    public int getWidth() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetImageInfoNative.jni_GetWidth(this.getHandle());
    }

    public void setWidth(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n <= 0) {
            String string = InternalResource.loadString("value", "DatasetImage_WidthShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        DatasetImageInfoNative.jni_SetWidth(this.getHandle(), n);
    }

    public int getHeight() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetImageInfoNative.jni_GetHeight(this.getHandle());
    }

    public void setHeight(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n <= 0) {
            String string = InternalResource.loadString("value", "DatasetImage_HeightShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        DatasetImageInfoNative.jni_SetHeight(this.getHandle(), n);
    }

    public PixelFormat getPixelFormat() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = DatasetImageInfoNative.jni_GetPixelFormat(this.getHandle());
        return (PixelFormat)Enum.parseUGCValue(PixelFormat.class, n);
    }

    public void setPixelFormat(PixelFormat pixelFormat) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (pixelFormat == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        DatasetImageInfoNative.jni_SetPixelFormat(this.getHandle(), pixelFormat.getUGCValue());
    }

    public BlockSizeOption getBlockSizeOption() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = DatasetImageInfoNative.jni_GetBlockSize(this.getHandle());
        return (BlockSizeOption)Enum.parseUGCValue(BlockSizeOption.class, n);
    }

    public void setBlockSizeOption(BlockSizeOption blockSizeOption) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        DatasetImageInfoNative.jni_SetBlockSize(this.getHandle(), blockSizeOption.getUGCValue());
    }

    public EncodeType getEncodeType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = DatasetImageInfoNative.jni_GetEncodeType(this.getHandle());
        return (EncodeType)Enum.parseUGCValue(EncodeType.class, n);
    }

    public void setEncodeType(EncodeType encodeType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (encodeType == null) {
            String string = InternalResource.loadString("encodeType", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (!Toolkit.isValidEncodeType(false, encodeType)) {
            String string = InternalResource.loadString("encodeType", "Global_UnsupportedEncodeType", "data_resources");
            throw new IllegalArgumentException(string);
        }
        DatasetImageInfoNative.jni_SetEncodeType(this.getHandle(), encodeType.getUGCValue());
    }

    public void dispose() {
        if (!super.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (super.getHandle() != 0L) {
            DatasetImageInfoNative.jni_Delete(super.getHandle());
            this.clearHandle();
        }
    }

    public String toString() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{Nmae = ");
        stringBuffer.append(this.getName());
        stringBuffer.append(",Bounds = {");
        stringBuffer.append(this.getBounds().toString());
        stringBuffer.append("},Width = ");
        stringBuffer.append(this.getWidth());
        stringBuffer.append(",Height = ");
        stringBuffer.append(this.getHeight());
        stringBuffer.append(",PixelFormat = ");
        stringBuffer.append(this.getPixelFormat().name());
        stringBuffer.append(",BlockSize = ");
        stringBuffer.append(this.getBlockSizeOption());
        stringBuffer.append(",EncodeType = ");
        stringBuffer.append(this.getEncodeType().name());
        stringBuffer.append("}\n");
        return stringBuffer.toString();
    }

    protected void clearHandle() {
        this.setHandle(0L);
    }

    void reset() {
        if (this.getHandle() != 0L) {
            DatasetImageInfoNative.jni_Reset(this.getHandle());
        }
    }
}

