/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.BlockSizeOption;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetGridCollectionInfoNative;
import com.supermap.data.EncodeType;
import com.supermap.data.Enum;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalInvalidState;
import com.supermap.data.InternalResource;
import com.supermap.data.PixelFormat;

public class DatasetGridCollectionInfo
extends InternalHandleDisposable {
    public DatasetGridCollectionInfo() {
        this.setHandle(DatasetGridCollectionInfoNative.jni_New(), true);
        this.reset();
    }

    public DatasetGridCollectionInfo(DatasetGridCollectionInfo datasetGridCollectionInfo) {
        if (datasetGridCollectionInfo == null) {
            String string = InternalResource.loadString("DatasetGridCollectionInfo", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (datasetGridCollectionInfo.getHandle() == 0L) {
            String string = InternalResource.loadString("DatasetGridCollectionInfo", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = DatasetGridCollectionInfoNative.jni_Clone(datasetGridCollectionInfo.getHandle());
        this.setHandle(l, true);
        InternalHandleDisposable.makeSureNativeObjectLive(datasetGridCollectionInfo);
    }

    public DatasetGridCollectionInfo(String string, PixelFormat pixelFormat, EncodeType encodeType, BlockSizeOption blockSizeOption) {
        if (string == null || string.trim().length() == 0) {
            String string2 = InternalResource.loadString("name", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string2);
        }
        if (pixelFormat == null) {
            String string3 = InternalResource.loadString("pixelFormat", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string3);
        }
        if (encodeType == null) {
            String string4 = InternalResource.loadString("encodeType", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string4);
        }
        this.setHandle(DatasetGridCollectionInfoNative.jni_New(), true);
        this.reset();
        this.setName(string);
        this.setPixelFormat(pixelFormat);
        this.setBlockSizeOption(blockSizeOption);
        this.setEncodeType(encodeType);
    }

    public String getName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetGridCollectionInfoNative.jni_GetName(this.getHandle());
    }

    public void setName(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null || string.trim().length() == 0) {
            String string3 = InternalResource.loadString("value", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string3);
        }
        InternalInvalidState internalInvalidState = Dataset.isValidDatasetName(string);
        if (internalInvalidState != null) {
            String string4 = "";
            if (internalInvalidState.equals(InternalInvalidState.ISEMPTY)) {
                string4 = "Dataset_NameIsEmpty";
            } else if (internalInvalidState.equals(InternalInvalidState.AGAINSYSTEMNAME)) {
                string4 = "Dataset_NameAgainstSys";
            } else if (internalInvalidState.equals(InternalInvalidState.BEYONDLIMIT)) {
                string4 = "Dataset_NameBeyondLimit";
            } else if (internalInvalidState.equals(InternalInvalidState.INVALIDCHAR)) {
                string4 = "Dataset_NameIncludeInvalidChar";
            } else if (internalInvalidState.equals(InternalInvalidState.PREFIXERROR)) {
                string4 = "Dataset_NameErrorPrefix";
            }
            String string5 = InternalResource.loadString("value", string4, "data_resources");
            throw new IllegalArgumentException(string5);
        }
        DatasetGridCollectionInfoNative.jni_SetName(this.getHandle(), string);
    }

    public PixelFormat getPixelFormat() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = DatasetGridCollectionInfoNative.jni_GetPixelFormat(this.getHandle());
        return (PixelFormat)Enum.parseUGCValue(PixelFormat.class, n);
    }

    public void setPixelFormat(PixelFormat pixelFormat) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (pixelFormat == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (pixelFormat.equals(PixelFormat.RGB) || pixelFormat.equals(PixelFormat.RGBA)) {
            String string = InternalResource.loadString("pixelFormat", "DatasetGridInfo_UnSupportedPixelFormat", "data_resources");
            throw new IllegalArgumentException(string);
        }
        DatasetGridCollectionInfoNative.jni_SetPixelFormat(this.getHandle(), pixelFormat.getUGCValue());
    }

    public BlockSizeOption getBlockSizeOption() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = DatasetGridCollectionInfoNative.jni_GetBlockSize(this.getHandle());
        return (BlockSizeOption)Enum.parseUGCValue(BlockSizeOption.class, n);
    }

    public void setBlockSizeOption(BlockSizeOption blockSizeOption) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        DatasetGridCollectionInfoNative.jni_SetBlockSize(this.getHandle(), blockSizeOption.getUGCValue());
    }

    public EncodeType getEncodeType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = DatasetGridCollectionInfoNative.jni_GetEncodeType(this.getHandle());
        return (EncodeType)Enum.parseUGCValue(EncodeType.class, n);
    }

    public void setEncodeType(EncodeType encodeType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (encodeType == null) {
            String string = InternalResource.loadString("encodeType", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (encodeType != EncodeType.SGL && encodeType != EncodeType.LZW) {
            encodeType = EncodeType.LZW;
        }
        DatasetGridCollectionInfoNative.jni_SetEncodeType(this.getHandle(), encodeType.getUGCValue());
    }

    public void dispose() {
        if (!super.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (super.getHandle() != 0L) {
            DatasetGridCollectionInfoNative.jni_Delete(super.getHandle());
            this.clearHandle();
        }
    }

    public String toString() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{Nmae = ");
        stringBuffer.append(this.getName());
        stringBuffer.append(",PixelFormat = ");
        stringBuffer.append(this.getPixelFormat().name());
        stringBuffer.append(",BlockSize = ");
        stringBuffer.append(this.getBlockSizeOption());
        stringBuffer.append(",EncodeType = ");
        stringBuffer.append(this.getEncodeType().name());
        stringBuffer.append("}\n");
        return stringBuffer.toString();
    }

    protected void clearHandle() {
        this.setHandle(0L);
    }

    void reset() {
        if (this.getHandle() != 0L) {
            DatasetGridCollectionInfoNative.jni_Reset(this.getHandle());
        }
    }
}

