// Copyright (c) 1998 by W3C
//
// DOM is a trademark of W3C
// The DOM level 1 specification, from which this
// source is derived, is copyright by W3C.
// See: http://www.w3.org/TR/REC-DOM-Level-1/
//

package org.w3c.dom;

/**
<P><A HREF='EntityReference.html'><CODE>EntityReference</CODE></A> objects may be inserted into the
      structure model when an entity reference is in the source document,
      or when the user wishes to insert an entity reference. Note that 
      character references and references to predefined entities are
      considered to be expanded by the HTML or XML
      processor so that characters are represented by their Unicode
      equivalent rather than by an entity reference. Moreover, the XML 
      processor may completely expand references to entities while building the
      structure model, instead of providing <A HREF='EntityReference.html'><CODE>EntityReference</CODE></A>
      objects. If it does provide such objects, then for a given
      <A HREF='EntityReference.html'><CODE>EntityReference</CODE></A> node, it may be that there is no
      <A HREF='Entity.html'><CODE>Entity</CODE></A> node representing the referenced entity;
      but if such an <A HREF='Entity.html'><CODE>Entity</CODE></A> exists, then the child list of the
      <A HREF='EntityReference.html'><CODE>EntityReference</CODE></A> node is the same as that of the
      <A HREF='Entity.html'><CODE>Entity</CODE></A> node. As with the <A HREF='Entity.html'><CODE>Entity</CODE></A> node, all
      descendants of the <A HREF='EntityReference.html'><CODE>EntityReference</CODE></A> are readonly.
<P>The resolution of the children of the <A HREF='EntityReference.html'><CODE>EntityReference</CODE></A> (the 
      replacement value of the referenced <A HREF='Entity.html'><CODE>Entity</CODE></A>) may be lazily 
      evaluated; actions by the user (such as calling the 
      <code>childNodes</code> method on the <A HREF='EntityReference.html'><CODE>EntityReference</CODE></A> node) 
      are assumed to trigger the evaluation.

*/
public interface EntityReference
extends Node
{
}
