/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.debug;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.security.config.debug.DebugFilter;
import org.springframework.security.config.debug.Logger;
import org.springframework.security.web.FilterChainProxy;

public class SecurityDebugBeanFactoryPostProcessor
implements BeanFactoryPostProcessor {
    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        Logger.logger.warn((Object)"\n\n********************************************************************\n**********        Security debugging is enabled.       *************\n**********    This may include sensitive information.  *************\n**********      Do not use in a production system!     *************\n********************************************************************\n\n");
        if (beanFactory.getBean("springSecurityFilterChain") != null) {
            FilterChainProxy fcp = (FilterChainProxy)beanFactory.getBean("org.springframework.security.filterChainProxy", FilterChainProxy.class);
            beanFactory.registerSingleton("org.springframework.security.debugFilter", (Object)new DebugFilter(fcp));
            beanFactory.registerAlias("org.springframework.security.debugFilter", "springSecurityFilterChain");
        }
    }
}

