/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sojo.interchange.json;

import net.sf.sojo.interchange.AbstractSerializer;
import net.sf.sojo.interchange.json.JsonParser;
import net.sf.sojo.interchange.json.JsonWalkerInterceptor;

public class JsonSerializer
extends AbstractSerializer {
    private JsonWalkerInterceptor jsonInterceptor = new JsonWalkerInterceptor();

    public JsonSerializer() {
        this.setWithSimpleKeyMapper(false);
        this.setWithNullValuesInMap(true);
        this.walker.addInterceptor(this.jsonInterceptor);
    }

    public boolean getWithNullValuesInMap() {
        return this.jsonInterceptor.getWithNullValuesInMap();
    }

    public void setWithNullValuesInMap(boolean pvWithNullValuesInMap) {
        this.jsonInterceptor.setWithNullValuesInMap(pvWithNullValuesInMap);
    }

    @Override
    public Object serialize(Object pvRootObject) {
        this.walker.walk(pvRootObject);
        return this.jsonInterceptor.getJsonString();
    }

    @Override
    public Object deserialize(Object pvSourceObject, Class<?> pvRootClass) {
        String lvParseString = pvSourceObject == null ? null : pvSourceObject.toString();
        Object lvResult = new JsonParser().parse(lvParseString);
        lvResult = this.getObjectUtil().makeComplex(lvResult, pvRootClass);
        return lvResult;
    }
}

