/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sojo.core.conversion;

import java.text.Format;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import net.sf.sojo.core.ConversionException;
import net.sf.sojo.core.SimpleConversion;

public class SimpleFormatConversion
extends SimpleConversion {
    private Map<Class<?>, Format> formatter = new HashMap();

    public SimpleFormatConversion() {
        super(String.class);
    }

    public void addFormatter(Class<?> pvType, Format pvFormat) {
        this.formatter.put(pvType, pvFormat);
    }

    public int getFormatterSize() {
        return this.formatter.size();
    }

    public void removeFormatterByType(Class<?> pvType) {
        this.formatter.remove(pvType);
    }

    @Override
    public boolean isAssignableFrom(Object pvObject) {
        if (pvObject == null) {
            return false;
        }
        if (pvObject.getClass().equals(String.class)) {
            return true;
        }
        return this.formatter.containsKey(pvObject.getClass());
    }

    @Override
    public boolean isAssignableTo(Class<?> pvToType) {
        return this.formatter.containsKey(pvToType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object convert(Object pvObject, Class<?> pvToType) {
        Object lvReturn = pvObject;
        Class<?> lvClass = lvReturn.getClass();
        Format lvFormat = null;
        if (lvClass.equals(String.class) && pvToType != null) {
            try {
                lvFormat = this.formatter.get(pvToType);
                if (lvFormat == null) return lvReturn;
                return lvFormat.parseObject(lvReturn.toString());
            }
            catch (ParseException e) {
                throw new ConversionException("Can't convert value: " + lvReturn + " to: " + pvToType.getName());
            }
        }
        lvFormat = this.formatter.get(lvClass);
        if (lvFormat == null) return lvReturn;
        return lvFormat.format(lvReturn);
    }
}

