/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sojo.core.conversion;

import java.lang.reflect.AccessibleObject;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import net.sf.sojo.core.ComplexConversion;
import net.sf.sojo.core.IConverter;
import net.sf.sojo.core.IConverterExtension;
import net.sf.sojo.core.NonCriticalExceptionHandler;
import net.sf.sojo.core.filter.ClassPropertyFilterHelper;
import net.sf.sojo.core.reflect.Property;
import net.sf.sojo.core.reflect.ReflectionHelper;
import net.sf.sojo.core.reflect.ReflectionPropertyHelper;
import net.sf.sojo.util.Util;

public class ComplexBean2MapConversion
extends ComplexConversion {
    public static final Class<?> DEFAULT_MAP_TYPE = LinkedHashMap.class;
    private Class<?> newBeanConversionType = null;

    public ComplexBean2MapConversion() {
        this(null);
    }

    public ComplexBean2MapConversion(Class<?> pvBeanType) {
        this.newBeanConversionType = pvBeanType;
        if (this.newBeanConversionType == null) {
            this.newBeanConversionType = DEFAULT_MAP_TYPE;
        }
        if (!Map.class.isAssignableFrom(this.newBeanConversionType)) {
            throw new IllegalArgumentException("The class: " + this.newBeanConversionType + " must be implements the java.util.Map interface.");
        }
        if (this.newBeanConversionType.isInterface()) {
            throw new IllegalArgumentException("The class: " + this.newBeanConversionType + " mus be a implementation and not a interface.");
        }
    }

    @Override
    public final boolean isAssignableFrom(Object pvObject) {
        return ReflectionHelper.isComplexType(pvObject);
    }

    @Override
    public boolean isAssignableTo(Class<?> pvToType) {
        return ReflectionHelper.isMapType(pvToType);
    }

    @Override
    public Object convert(Object pvObject, Class<?> pvToType, IConverterExtension pvConverter) {
        Map lvBeanMap;
        block3: {
            lvBeanMap = null;
            try {
                Class<?> lvToType = pvToType == null || pvToType.isInterface() ? this.newBeanConversionType : pvToType;
                Map<?, ?> lvGetterMap = ReflectionPropertyHelper.getAllGetterProperties(pvObject.getClass(), null);
                lvBeanMap = (Map)ReflectionHelper.createNewIterableInstance(lvToType, lvGetterMap.size());
                if (!ClassPropertyFilterHelper.isPropertyToFiltering(this.classPropertyFilterHandler, pvObject.getClass(), "~unique-id~")) {
                    String lvUniqueId = pvConverter.getUniqueId(pvObject);
                    lvBeanMap.put("~unique-id~", lvUniqueId);
                }
                Iterator<Map.Entry<?, ?>> it = lvGetterMap.entrySet().iterator();
                lvBeanMap = (Map)super.iterate(pvObject, lvBeanMap, it, pvConverter);
            }
            catch (Exception e) {
                if (!NonCriticalExceptionHandler.isNonCriticalExceptionHandlerEnabled()) break block3;
                NonCriticalExceptionHandler.handleException(ComplexBean2MapConversion.class, e, "Problem by conver bean to map: " + e);
            }
        }
        return lvBeanMap;
    }

    @Override
    protected Object[] doTransformIteratorObject2KeyValuePair(Object pvIteratorObject) {
        Map.Entry lvMapEntry = (Map.Entry)pvIteratorObject;
        Object lvKey = lvMapEntry.getKey();
        Object lvValue = lvMapEntry.getValue();
        return new Object[]{lvKey, lvValue};
    }

    @Override
    protected Object[] doConvert(Object pvSourceObject, Object pvNewTargetObject, Object pvKey, Object pvValue, IConverter pvConverter) {
        Object lvNewValue;
        block3: {
            String propName = (String)pvKey;
            lvNewValue = null;
            if (!Util.getKeyWordClass().equals(propName)) {
                Object lvValue = null;
                AccessibleObject lvAccessibleObject = null;
                try {
                    lvAccessibleObject = (AccessibleObject)pvValue;
                    lvValue = new Property(lvAccessibleObject).executeGetValue(pvSourceObject);
                    lvNewValue = pvConverter.convert(lvValue);
                }
                catch (Exception e) {
                    if (!NonCriticalExceptionHandler.isNonCriticalExceptionHandlerEnabled()) break block3;
                    NonCriticalExceptionHandler.handleException(ComplexBean2MapConversion.class, e, "Problem by invoke get from property: " + lvAccessibleObject);
                }
            }
        }
        return new Object[]{pvKey, lvNewValue};
    }

    @Override
    protected void doAddObject(Object pvSourceObject, Object pvNewTargetObject, Object pvKey, Object pvValue, int pvIteratorPosition) {
        Map lvBeanMap = (Map)pvNewTargetObject;
        String propName = (String)pvKey;
        if (!Util.getKeyWordClass().equals(propName)) {
            try {
                lvBeanMap.put(propName, pvValue);
            }
            catch (NullPointerException e) {
                if (NonCriticalExceptionHandler.isNonCriticalExceptionHandlerEnabled()) {
                    NonCriticalExceptionHandler.handleException(ComplexBean2MapConversion.class, e, "Try to add a null-value to Map: " + lvBeanMap.getClass().getName());
                }
            }
        } else {
            lvBeanMap.put(Util.getKeyWordClass(), pvSourceObject.getClass().getName());
        }
    }
}

