/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.ui;

import com.supermap.data.DatasetType;
import com.supermap.data.GeoLine;
import com.supermap.data.GeoPoint;
import com.supermap.data.GeoRegion;
import com.supermap.data.GeoStyle;
import com.supermap.data.GeoStyle3D;
import com.supermap.data.Geometry;
import com.supermap.data.Point2D;
import com.supermap.data.Point2Ds;
import com.supermap.data.Resources;
import com.supermap.data.Size2D;
import com.supermap.data.Toolkit;
import com.supermap.realspace.Feature3D;
import com.supermap.realspace.Feature3Ds;
import com.supermap.realspace.Layer3DDataset;
import com.supermap.realspace.Theme3DRangeItem;
import com.supermap.realspace.Theme3DUniqueItem;
import com.supermap.ui.InternalImageIconFactory;
import com.supermap.ui.TreeNodeData;
import com.supermap.ui.TreeNodeDecorator;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

class Theme3DItemGeneralNodeDecorator
implements TreeNodeDecorator {
    Theme3DItemGeneralNodeDecorator() {
    }

    public void decorate(JLabel jLabel, TreeNodeData treeNodeData) {
        Object object = treeNodeData.getData();
        BufferedImage bufferedImage = new BufferedImage(16, 16, 2);
        Graphics graphics = bufferedImage.getGraphics();
        ImageIcon imageIcon = (ImageIcon)jLabel.getIcon();
        if (object instanceof Theme3DRangeItem) {
            Layer3DDataset layer3DDataset = (Layer3DDataset)treeNodeData.getParentLayer3D();
            Resources resources = layer3DDataset.getDataset().getDatasource().getWorkspace().getResources();
            Theme3DRangeItem theme3DRangeItem = (Theme3DRangeItem)object;
            jLabel.setText(theme3DRangeItem.getCaption());
            GeoStyle geoStyle = this._$1(theme3DRangeItem.getStyle());
            Geometry geometry = this._$1(layer3DDataset.getDataset().getType());
            geometry.setStyle(geoStyle);
            Toolkit.draw((Geometry)geometry, (Resources)resources, (Graphics)graphics);
            imageIcon.setImage(bufferedImage);
        } else if (object instanceof Theme3DUniqueItem) {
            Layer3DDataset layer3DDataset = (Layer3DDataset)treeNodeData.getParentLayer3D();
            Resources resources = layer3DDataset.getDataset().getDatasource().getWorkspace().getResources();
            Theme3DUniqueItem theme3DUniqueItem = (Theme3DUniqueItem)object;
            jLabel.setText(theme3DUniqueItem.getCaption());
            GeoStyle geoStyle = this._$1(theme3DUniqueItem.getStyle());
            Geometry geometry = this._$1(layer3DDataset.getDataset().getType());
            geometry.setStyle(geoStyle);
            Toolkit.draw((Geometry)geometry, (Resources)resources, (Graphics)graphics);
            imageIcon.setImage(bufferedImage);
        } else if (object instanceof Feature3D) {
            Feature3D feature3D = (Feature3D)object;
            jLabel.setText(feature3D.getName());
            graphics.drawImage(InternalImageIconFactory.FEATURE3D.getImage(), 0, 0, jLabel);
            imageIcon.setImage(bufferedImage);
        } else if (object instanceof Feature3Ds) {
            Feature3Ds feature3Ds = (Feature3Ds)object;
            jLabel.setText(feature3Ds.getName());
            graphics.drawImage(InternalImageIconFactory.FEATURE3DS.getImage(), 0, 0, jLabel);
            imageIcon.setImage(bufferedImage);
        }
    }

    private Geometry _$1(DatasetType datasetType) {
        if (datasetType.equals((Object)DatasetType.POINT) || datasetType.equals((Object)DatasetType.POINT3D)) {
            GeoPoint geoPoint = new GeoPoint();
            return geoPoint;
        }
        if (datasetType.equals((Object)DatasetType.LINE) || datasetType.equals((Object)DatasetType.LINE3D)) {
            Point2D[] point2DArray = new Point2D[]{new Point2D(0.0, 16.0), new Point2D(4.0, 0.0), new Point2D(12.0, 16.0), new Point2D(16.0, 0.0)};
            Point2Ds point2Ds = new Point2Ds(point2DArray);
            GeoLine geoLine = new GeoLine(point2Ds);
            return geoLine;
        }
        if (datasetType.equals((Object)DatasetType.REGION) || datasetType.equals((Object)DatasetType.REGION3D)) {
            Point2D[] point2DArray = new Point2D[]{new Point2D(1.0, 15.0), new Point2D(1.0, 5.0), new Point2D(10.0, 1.0), new Point2D(15.0, 5.0), new Point2D(15.0, 15.0), new Point2D(1.0, 15.0)};
            Point2Ds point2Ds = new Point2Ds(point2DArray);
            GeoRegion geoRegion = new GeoRegion(point2Ds);
            return geoRegion;
        }
        return null;
    }

    private GeoStyle _$1(GeoStyle3D geoStyle3D) {
        GeoStyle geoStyle = new GeoStyle();
        geoStyle.setFillBackColor(geoStyle3D.getFillForeColor());
        geoStyle.setFillForeColor(geoStyle3D.getFillForeColor());
        geoStyle.setLineColor(geoStyle3D.getLineColor());
        if (geoStyle3D.getLineWidth() > 0.2) {
            geoStyle.setLineWidth(0.2);
        } else {
            geoStyle.setLineWidth(geoStyle3D.getLineWidth());
        }
        geoStyle.setMarkerSize(new Size2D(geoStyle3D.getMarkerSize(), geoStyle3D.getMarkerSize()));
        return geoStyle;
    }
}

