/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.ui;

import com.supermap.data.ColorGradientType;
import com.supermap.data.Colors;
import com.supermap.ui.ColorScheme;
import com.supermap.ui.ColorSchemeEditorDialog;
import com.supermap.ui.ColorsCellRenderer;
import com.supermap.ui.DialogResult;
import com.supermap.ui.UIEnvironment;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JComboBox;

class ColorsComboBox
extends JComboBox {
    private static final long serialVersionUID = 1L;
    private ColorsCellRenderer _$4 = new ColorsCellRenderer();
    private int _$3;
    private ActionListener _$2;
    private Colors _$1;

    public ColorsComboBox() {
        this.setRenderer(this._$4);
        this._$3 = 32;
        this._$2 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ColorsComboBox.this.getSelectedIndex() == ColorsComboBox.this.getItemCount() - 1) {
                    ColorSchemeEditorDialog colorSchemeEditorDialog = new ColorSchemeEditorDialog(ColorsComboBox.this._$1);
                    colorSchemeEditorDialog.setVisible(true);
                    DialogResult dialogResult = colorSchemeEditorDialog.getResult();
                    if (dialogResult.equals((Object)DialogResult.APPLY)) {
                        ColorsComboBox.this._$1 = colorSchemeEditorDialog.getResultColors();
                        ColorsComboBox.this.removeItemAt(ColorsComboBox.this.getItemCount() - 1);
                        ColorsComboBox.this.addItem(ColorsComboBox.this._$1);
                        ColorsComboBox.this.setSelectedItem(ColorsComboBox.this._$1);
                    }
                    colorSchemeEditorDialog.dispose();
                }
            }
        };
        this._$1();
    }

    public Dimension getColorRendererSize() {
        return this._$4.getPreferredSize();
    }

    public void setColorRendererSize(Dimension dimension) {
        this._$4.setPreferredSize(dimension);
    }

    public int getColorsCount() {
        return this._$3;
    }

    public void setColorsCount(int n) {
        this._$3 = n;
        this._$1 = Colors.makeGradient((int)n, (ColorGradientType)ColorGradientType.RAINBOW, (boolean)false);
    }

    private void _$1() {
        String string = UIEnvironment.jni_GetBasePath() + "Resource/Templates/ColorScheme/Extension/";
        File file = new File(string);
        String[] stringArray = file.list();
        ColorScheme colorScheme = new ColorScheme();
        for (int i = 0; i < stringArray.length; ++i) {
            File file2 = new File(string + stringArray[i]);
            boolean bl = colorScheme.fromXML(file2);
            if (!bl) continue;
            ArrayList<Color> arrayList = colorScheme.getColors();
            Color[] colorArray = new Color[arrayList.size()];
            arrayList.toArray(colorArray);
            int n = colorScheme.getIntervalColorCount();
            if (n < 2) {
                n = 16;
            }
            Colors colors = null;
            ColorScheme.IntervalColorBuildMethod intervalColorBuildMethod = colorScheme.getIntervalColorBuildMethod();
            if (intervalColorBuildMethod.equals((Object)ColorScheme.IntervalColorBuildMethod.ICBM_GRADIENT)) {
                colors = Colors.makeGradient((int)(n + colorScheme.getKeyColorCount()), (Color[])colorArray);
            } else if (intervalColorBuildMethod.equals((Object)ColorScheme.IntervalColorBuildMethod.ICBM_RANDOM)) {
                colors = ColorsComboBox._$1(n + colorScheme.getKeyColorCount(), colorArray);
            }
            this.addItem(colors);
        }
        this._$1 = Colors.makeGradient((int)this.getColorsCount(), (ColorGradientType)ColorGradientType.RAINBOW, (boolean)false);
        this.addItem(this._$1);
        this.addActionListener(this._$2);
    }

    private static Colors _$1(int n, Color[] colorArray) {
        Colors colors = new Colors();
        if (n <= colorArray.length) {
            for (int i = 0; i < n; ++i) {
                colors.add(colorArray[i]);
            }
        } else {
            int n2 = (int)Math.floor((double)n * 1.0 / (double)(colorArray.length - 1));
            int n3 = n - n2 * (colorArray.length - 1);
            for (int i = 0; i < colorArray.length - 1; ++i) {
                Color[] colorArray2 = new Color[]{colorArray[i], colorArray[i + 1]};
                colors.addRange(Colors.makeGradient((int)n2, (Color[])colorArray2).toArray());
            }
            if (n3 > 0) {
                Color[] colorArray3 = new Color[]{colorArray[colorArray.length - 2], colorArray[colorArray.length - 1]};
                colors.addRange(Colors.makeGradient((int)n3, (Color[])colorArray3).toArray());
            }
        }
        return colors;
    }
}

